/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missingelement;

import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclaration;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolverRequest;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolvesParticipant;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class required_elements_missing_expectedCodeActionResolver
implements ICodeActionResolvesParticipant {
    public static final String PARTICIPANT_ID = required_elements_missing_expectedCodeActionResolver.class.getName();

    @Override
    public CodeAction resolveCodeAction(ICodeActionResolverRequest request, CancelChecker cancelChecker) {
        DOMDocument document = request.getDocument();
        Diagnostic diagnostic = request.getUnresolved().getDiagnostics().get(0);
        CodeAction resolved = request.getUnresolved();
        try {
            Range diagnosticRange = diagnostic.getRange();
            int startOffset = document.offsetAt(diagnosticRange.getStart()) + 1;
            DOMNode node = document.findNodeAt(startOffset);
            if (node == null || !node.isElement()) {
                return null;
            }
            DOMElement element = (DOMElement)node;
            Position childElementPositionStartTag = document.positionAt(element.getStartTagCloseOffset() + 1);
            Position childElementPositionEndTag = document.positionAt(element.getEndTagOpenOffset());
            Range targetRange = new Range(childElementPositionStartTag, childElementPositionEndTag);
            XMLGenerator generator = request.getXMLGenerator(targetRange);
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            for (CMDocument cmDocument : contentModelManager.findCMDocument(element)) {
                CMElementDeclaration matchesCMElement = cmDocument.findCMElement(element);
                if (matchesCMElement == null) continue;
                for (CMElementDeclaration child : ((CMRelaxNGElementDeclaration)matchesCMElement).getPossibleRequiredElements()) {
                    if (!child.getLocalName().equals(request.getDataProperty("element"))) continue;
                    StringBuilder generatedXml = new StringBuilder();
                    generatedXml.append(generator.generate(child, null, true, false, 1, true));
                    String replaceText = generatedXml.toString();
                    resolved.setEdit(CodeActionFactory.getReplaceWorkspaceEdit(replaceText, targetRange, document.getTextDocument()));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return resolved;
    }
}

