/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.team.internal.ui.mapping.ResourceMappingLabelProvider;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class ResourceMappingSelectionArea
extends DialogArea {
    public static final String SELECTED_MAPPING = "SelectedMapping";
    public static final String CHECKED_MAPPINGS = "CheckedMappings";
    private final ResourceMapping[] mappings;
    private TableViewer viewer;
    private ResourceMapping[] checkedMappings;
    private ResourceMapping selectedMapping;
    private String description;
    private final boolean supportsChecking;
    private final boolean supportsSelection;

    public ResourceMappingSelectionArea(ResourceMapping[] mappings, boolean supportSelection, boolean supportChecking) {
        this.mappings = mappings;
        this.supportsChecking = supportChecking;
        this.supportsSelection = supportSelection;
    }

    @Override
    public void createArea(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        if (this.description != null) {
            this.createWrappingLabel(composite, this.description, 1);
        }
        this.createViewer(composite);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 300;
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceMappingLabelProvider());
        this.viewer.setInput((Object)new AdaptableList((IAdaptable[])this.mappings));
        if (this.isSupportsSelection()) {
            this.viewer.addSelectionChangedListener(event -> {
                ResourceMapping oldSelection = this.selectedMapping;
                this.selectedMapping = this.internalGetSelectedMapping();
                if (oldSelection != this.selectedMapping) {
                    this.firePropertyChangeChange(SELECTED_MAPPING, oldSelection, this.selectedMapping);
                }
            });
        }
        if (this.isSupportsChecking()) {
            this.initializeCheckboxViewer(composite);
        }
    }

    private void initializeCheckboxViewer(Composite composite) {
        final CheckboxTableViewer checkboxViewer = this.getCheckboxTableViewer();
        checkboxViewer.addCheckStateListener(event -> {
            ResourceMapping[] oldMappings = this.checkedMappings;
            this.checkedMappings = this.internalGetCheckedMappings();
            if (oldMappings != this.checkedMappings) {
                this.firePropertyChangeChange(CHECKED_MAPPINGS, oldMappings, this.checkedMappings);
            }
        });
        checkboxViewer.setCheckedElements((Object[])this.mappings);
        this.checkedMappings = this.mappings;
        Composite buttons = this.createEmbeddedButtonComposite(composite);
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(TeamUIMessages.ResourceMappingSelectionArea_0);
        selectAll.setLayoutData((Object)new GridData(1808));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                checkboxViewer.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(TeamUIMessages.ResourceMappingSelectionArea_1);
        deselectAll.setLayoutData((Object)new GridData(1808));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                checkboxViewer.setAllChecked(false);
            }
        });
    }

    private void createViewer(Composite composite) {
        this.viewer = this.isSupportsChecking() ? CheckboxTableViewer.newCheckList((Composite)composite, (int)this.getViewerStyle()) : new TableViewer(new Table(composite, this.getViewerStyle()));
    }

    private int getViewerStyle() {
        int style = 2048;
        if (this.isSupportsSelection()) {
            style |= 4;
        }
        return style;
    }

    ResourceMapping[] internalGetCheckedMappings() {
        Object[] checked = this.getCheckboxTableViewer().getCheckedElements();
        ResourceMapping[] mappings = new ResourceMapping[checked.length];
        int i = 0;
        while (i < checked.length) {
            Object object = checked[i];
            mappings[i] = (ResourceMapping)object;
            ++i;
        }
        return mappings;
    }

    private Composite createEmbeddedButtonComposite(Composite composite) {
        Composite buttons = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        GridData data = new GridData(132);
        buttons.setLayoutData((Object)data);
        return buttons;
    }

    ResourceMapping internalGetSelectedMapping() {
        IStructuredSelection ss;
        Object firstElement;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ResourceMapping) {
            return (ResourceMapping)firstElement;
        }
        return null;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceMapping[] getCheckedMappings() {
        return this.checkedMappings;
    }

    public ResourceMapping getSelectedMapping() {
        return this.selectedMapping;
    }

    private CheckboxTableViewer getCheckboxTableViewer() {
        return (CheckboxTableViewer)this.viewer;
    }

    public boolean isSupportsChecking() {
        return this.supportsChecking;
    }

    public boolean isSupportsSelection() {
        return this.supportsSelection;
    }
}

