/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.XtendEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.sphinx.xtendxpand.util.XtendXpandUtil;
import org.eclipse.xpand2.XpandUtil;
import org.eclipse.xtend.XtendFacade;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.MetaModel;

public class XtendJob
extends Job {
    protected static final Log log = LogFactory.getLog(XtendJob.class);
    protected List<MetaModel> metaModels = null;
    protected TypeSystem typeSystem = null;
    protected Collection<XtendEvaluationRequest> xtendEvaluationRequests;
    private IWorkspaceResourceLoader workspaceResourceLoader;
    private String operationLabel = null;
    private Map<String, Object> transactionOptions = null;
    protected Map<Object, Collection<?>> resultObjects = new HashMap();

    public XtendJob(String name, MetaModel metaModel, XtendEvaluationRequest xtendEvaluationRequest) {
        this(name, Collections.singletonList(metaModel), Collections.singleton(xtendEvaluationRequest));
    }

    public XtendJob(String name, MetaModel metaModel, Collection<XtendEvaluationRequest> xtendEvaluationRequests) {
        this(name, Collections.singletonList(metaModel), xtendEvaluationRequests);
    }

    public XtendJob(String name, List<MetaModel> metaModels, XtendEvaluationRequest xtendEvaluationRequest) {
        this(name, metaModels, Collections.singleton(xtendEvaluationRequest));
    }

    public XtendJob(String name, List<MetaModel> metaModels, Collection<XtendEvaluationRequest> xtendEvaluationRequests) {
        super(name);
        Assert.isNotNull(metaModels);
        Assert.isNotNull(xtendEvaluationRequests);
        this.metaModels = metaModels;
        this.xtendEvaluationRequests = xtendEvaluationRequests;
    }

    public XtendJob(String name, TypeSystem typeSystem, XtendEvaluationRequest xtendEvaluationRequest) {
        this(name, typeSystem, Collections.singleton(xtendEvaluationRequest));
    }

    public XtendJob(String name, TypeSystem typeSystem, Collection<XtendEvaluationRequest> xtendEvaluationRequests) {
        super(name);
        Assert.isNotNull((Object)typeSystem);
        Assert.isNotNull(xtendEvaluationRequests);
        this.typeSystem = typeSystem;
        this.xtendEvaluationRequests = xtendEvaluationRequests;
    }

    protected Map<TransactionalEditingDomain, Collection<XtendEvaluationRequest>> getXtendEvaluationRequests() {
        HashMap<TransactionalEditingDomain, Collection<XtendEvaluationRequest>> requests = new HashMap<TransactionalEditingDomain, Collection<XtendEvaluationRequest>>();
        for (XtendEvaluationRequest request : this.xtendEvaluationRequests) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)request.getTargetObject());
            HashSet<XtendEvaluationRequest> requestsInEditingDomain = (HashSet<XtendEvaluationRequest>)requests.get(editingDomain);
            if (requestsInEditingDomain == null) {
                requestsInEditingDomain = new HashSet<XtendEvaluationRequest>();
                requests.put(editingDomain, requestsInEditingDomain);
            }
            requestsInEditingDomain.add(request);
        }
        return requests;
    }

    public void setWorkspaceResourceLoader(IWorkspaceResourceLoader resourceLoader) {
        this.workspaceResourceLoader = resourceLoader;
    }

    protected String getOperationLabel() {
        if (this.operationLabel == null) {
            this.operationLabel = this.getName();
        }
        return this.operationLabel;
    }

    public void setOperationLabel(String operationLabel) {
        this.operationLabel = operationLabel;
    }

    protected IOperationHistory getOperationHistory(TransactionalEditingDomain editingDomain) {
        return WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain);
    }

    protected Map<String, Object> getTransactionOptions() {
        if (this.transactionOptions == null) {
            this.transactionOptions = WorkspaceTransactionUtil.getDefaultTransactionOptions();
        }
        return this.transactionOptions;
    }

    public void setTransactionOptions(Map<String, Object> transactionOptions) {
        this.transactionOptions = transactionOptions;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            if (this.xtendEvaluationRequests.isEmpty()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            log.info((Object)"Xtend started...");
            this.installResourceLoader();
            ResourceManagerDefaultImpl resourceManager = new ResourceManagerDefaultImpl();
            HashMap variables = new HashMap();
            HashMap globalVarsMap = new HashMap();
            ExecutionContextImpl execCtx = new ExecutionContextImpl((ResourceManager)resourceManager, null, this.typeSystem instanceof TypeSystemImpl ? (TypeSystemImpl)this.typeSystem : new TypeSystemImpl(), variables, globalVarsMap, (ProgressMonitor)new ProgressMonitorAdapter(monitor), null, null, null, null, null, null, null);
            if (this.metaModels != null) {
                for (MetaModel metaModel : this.metaModels) {
                    execCtx.registerMetaModel(metaModel);
                }
            }
            long startTime = System.currentTimeMillis();
            final Map<TransactionalEditingDomain, Collection<XtendEvaluationRequest>> requests = this.getXtendEvaluationRequests();
            for (final TransactionalEditingDomain editingDomain : requests.keySet()) {
                Runnable runnable = new Runnable((ResourceManager)resourceManager, execCtx){
                    private final /* synthetic */ ResourceManager val$resourceManager;
                    private final /* synthetic */ ExecutionContextImpl val$execCtx;
                    {
                        this.val$resourceManager = resourceManager;
                        this.val$execCtx = executionContextImpl;
                    }

                    @Override
                    public void run() {
                        for (XtendEvaluationRequest request : (Collection)requests.get(editingDomain)) {
                            log.info((Object)("Xtend transformation for " + request.getTargetObject() + " with '" + request.getExtensionName() + "'"));
                            XtendJob.this.updateResourceLoaderContext(request.getTargetObject());
                            IFile extensionFile = XtendXpandUtil.getUnderlyingFile(request.getExtensionName(), "ext", (ResourceLoader)XtendJob.this.workspaceResourceLoader);
                            if (extensionFile != null) {
                                try {
                                    this.val$resourceManager.setFileEncoding(extensionFile.getCharset());
                                }
                                catch (CoreException coreException) {
                                    // empty catch block
                                }
                            }
                            XtendFacade facade = XtendFacade.create((ExecutionContext)this.val$execCtx, (String[])new String[]{XpandUtil.withoutLastSegment((String)request.getExtensionName())});
                            ArrayList<Object> parameterList = new ArrayList<Object>();
                            parameterList.add(request.getTargetObject());
                            parameterList.addAll(request.getParameterList());
                            Object result = facade.call(XpandUtil.getLastSegment((String)request.getExtensionName()), parameterList);
                            if (result == null) continue;
                            if (result instanceof Collection) {
                                XtendJob.this.resultObjects.put(request.getTargetObject(), (Collection)result);
                                continue;
                            }
                            if (result instanceof Object[]) {
                                XtendJob.this.resultObjects.put(request.getTargetObject(), Arrays.asList((Object[])result));
                                continue;
                            }
                            XtendJob.this.resultObjects.put(request.getTargetObject(), Collections.singleton(result));
                        }
                    }
                };
                if (editingDomain != null) {
                    WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)runnable, (String)this.getOperationLabel(), (IOperationHistory)this.getOperationHistory(editingDomain), this.getTransactionOptions());
                    continue;
                }
                runnable.run();
            }
            long duration = System.currentTimeMillis() - startTime;
            log.info((Object)("Xtend completed in " + duration + "ms!"));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OperationCanceledException exception) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception ex) {
            IStatus iStatus = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            return iStatus;
        }
        finally {
            this.uninstallResourceLoader();
        }
    }

    protected void installResourceLoader() {
        if (this.workspaceResourceLoader == null) {
            if (ResourceLoaderFactory.getCurrentThreadResourceLoader() instanceof IWorkspaceResourceLoader) {
                this.workspaceResourceLoader = (IWorkspaceResourceLoader)ResourceLoaderFactory.getCurrentThreadResourceLoader();
            }
        } else {
            ResourceLoaderFactory.setCurrentThreadResourceLoader((ResourceLoader)this.workspaceResourceLoader);
        }
    }

    protected void updateResourceLoaderContext(Object contextObject) {
        IFile contextFile;
        IModelDescriptor contextModel;
        if (this.workspaceResourceLoader != null && (contextModel = ModelDescriptorRegistry.INSTANCE.getModel(contextFile = EcorePlatformUtil.getFile((Object)contextObject))) != null) {
            this.workspaceResourceLoader.setContextModel(contextModel);
        }
    }

    protected void uninstallResourceLoader() {
        ResourceLoaderFactory.setCurrentThreadResourceLoader(null);
    }

    public Map<Object, Collection<?>> getResultObjects() {
        return this.resultObjects;
    }

    public boolean belongsTo(Object family) {
        return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
    }
}

