/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.sphinx.platform.ui.preferences.AbstractPreferenceAndPropertyPage;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;
import org.eclipse.sphinx.xtendxpand.ui.groups.OutletsGroup;
import org.eclipse.sphinx.xtendxpand.ui.groups.ProtectedRegionGroup;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.outlet.providers.OutletProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class AbstractOutletsPreferencePage
extends AbstractPreferenceAndPropertyPage {
    private OutletsGroup outletsGroup;
    private ProtectedRegionGroup protectedRegionGroup;
    private TableViewer tableViewer;
    private OutletProvider outletProvider;

    public AbstractOutletsPreferencePage() {
        super("org.eclipse.xtend.shared.ui.xtendXPandNature", 1);
    }

    public AbstractOutletsPreferencePage(String requiredProjectNatureId, int style) {
        super(requiredProjectNatureId, style);
    }

    protected OutletsPreference getOutletsPreference() {
        return OutletsPreference.INSTANCE;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        if (this.isProjectPreferencePage()) {
            ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope((IProject)this.getElement()), this.getOutletsPreference().getQualifier());
            return scopedPreferenceStore;
        }
        return null;
    }

    protected void addFields(Composite parent) {
        this.addOutletsGroup(parent);
        this.addProtectedRegionGroup(parent);
    }

    protected void addOutletsGroup(Composite parent) {
        this.outletProvider = new OutletProvider((IProject)this.getElement(), this.getOutletsPreference());
        this.outletsGroup = new OutletsGroup(Messages.label_outletsGroupName, this.outletProvider);
        this.outletsGroup.createContent(parent, 2);
        this.tableViewer = this.outletsGroup.getTableViewer();
        Dialog.applyDialogFont((Control)parent);
    }

    protected void addProtectedRegionGroup(Composite parent) {
        this.protectedRegionGroup = new ProtectedRegionGroup(Messages.label_protectedRegionGroupName, (IProject)this.getElement());
        this.protectedRegionGroup.createContent(parent, 3);
    }

    protected void enablePreferenceContent(boolean useProjectSpecificSettings) {
        if (this.outletsGroup != null) {
            this.outletsGroup.setEnabled(useProjectSpecificSettings);
        }
    }

    protected void performDefaults() {
        this.outletsGroup.setToDefault();
        this.protectedRegionGroup.setToDefault();
        this.tableViewer.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        this.outletsGroup.store();
        this.protectedRegionGroup.store();
        return super.performOk();
    }

    public void dispose() {
        this.outletsGroup.dispose();
        this.protectedRegionGroup.dispose();
        super.dispose();
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        if (((GridLayout)this.getFieldEditorParent().getLayout()).numColumns == 0) {
            ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 1;
        }
    }
}

