/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.scoping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.resources.DefaultResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.IResourceChangeHandler;
import org.eclipse.sphinx.platform.resources.ResourceDeltaVisitor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

@Deprecated
public class ProjectResourceCache {
    private final Map<IProject, Set<URI>> cache = new HashMap<IProject, Set<URI>>();
    private InvalidationListener invalidationListener = null;

    private final void buildCache(IProject project) {
        try {
            if (!this.cache.containsKey(project)) {
                final HashSet resources = new HashSet();
                if (project.exists() && project.isOpen()) {
                    project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource instanceof IContainer) {
                                return true;
                            }
                            resources.add(EcorePlatformUtil.createURI(resource.getFullPath()));
                            return false;
                        }
                    });
                }
                this.cache.put(project, resources);
            }
            if (this.invalidationListener == null) {
                this.invalidationListener = new InvalidationListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.invalidationListener);
            }
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)ex));
        }
    }

    private final void invalidate() {
        if (this.invalidationListener != null) {
            this.cache.clear();
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.invalidationListener);
            this.invalidationListener = null;
        }
    }

    public Set<URI> getResources(IProject project) {
        this.buildCache(project);
        return this.cache.containsKey(project) ? this.cache.get(project) : Collections.emptySet();
    }

    class InvalidationListener
    implements IResourceChangeListener {
        InvalidationListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(event.getType(), (IResourceChangeHandler)new DefaultResourceChangeHandler(){

                        public void handleProjectCreated(int eventType, IProject project) {
                            ProjectResourceCache.this.invalidate();
                        }

                        public void handleProjectOpened(int eventType, IProject project) {
                            ProjectResourceCache.this.invalidate();
                        }

                        public void handleProjectRenamed(int eventType, IProject oldProject, IProject newProject) {
                            ProjectResourceCache.this.invalidate();
                        }

                        public void handleProjectDescriptionChanged(int eventType, IProject project) {
                            ProjectResourceCache.this.invalidate();
                        }

                        public void handleProjectClosed(int eventType, IProject project) {
                            ProjectResourceCache.this.invalidate();
                        }

                        public void handleProjectRemoved(int eventType, IProject project) {
                            ProjectResourceCache.this.invalidate();
                        }
                    });
                    delta.accept((IResourceDeltaVisitor)visitor);
                }
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)ex));
            }
        }
    }
}

