/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.operations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.check.internal.Activator;
import org.eclipse.sphinx.emf.check.internal.messages.Messages;
import org.eclipse.sphinx.emf.check.services.CheckProblemMarkerService;
import org.eclipse.sphinx.emf.check.util.ExtendedDiagnostician;
import org.eclipse.sphinx.platform.operations.AbstractLabeledWorkspaceRunnable;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class BasicCheckValidationOperation
extends AbstractLabeledWorkspaceRunnable {
    protected static final Object ALL_MODEL_OBJECT_COUNT = "ALL_MODEL_OBJECT_COUNT";
    protected static final float PROBLEM_MARKER_TO_VALIDATION_WORK_RATIO = 0.1f;
    private List<?> modelObjects;
    private Map<Object, Object> options;
    private ExtendedDiagnostician diagnostician;

    public BasicCheckValidationOperation(List<?> modelObjects, Map<Object, Object> options) {
        this(Messages.operation_validate_label, modelObjects, options);
    }

    public BasicCheckValidationOperation(String label, List<? extends Object> modelObjects, Map<Object, Object> options) {
        super(label);
        Assert.isNotNull(modelObjects);
        this.modelObjects = modelObjects;
        this.options = options;
    }

    protected List<?> getModelObjects() {
        return this.modelObjects;
    }

    protected Map<Object, Integer> getModelObjectCounts() {
        List<?> objects = this.getModelObjects();
        HashMap<Object, Integer> counts = new HashMap<Object, Integer>(objects.size());
        int allCount = 0;
        for (Object object : objects) {
            int count = this.getModelObjectCount(object);
            counts.put(object, count);
            allCount += count;
        }
        counts.put(ALL_MODEL_OBJECT_COUNT, allCount);
        return counts;
    }

    protected int getModelObjectCount(Object object) {
        int count = 1;
        if (object instanceof EObject) {
            TreeIterator iter = ((EObject)object).eAllContents();
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
        }
        return count;
    }

    protected Map<Object, Object> getOptions() {
        if (this.options == null) {
            this.options = new HashMap<Object, Object>();
        }
        return this.options;
    }

    protected ExtendedDiagnostician getDiagnostician() {
        if (this.diagnostician == null) {
            this.diagnostician = this.createDiagnostician();
        }
        return this.diagnostician;
    }

    protected ExtendedDiagnostician createDiagnostician() {
        return new ExtendedDiagnostician();
    }

    protected float getProblemMarkerToValidationWorkRatio() {
        return 0.1f;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        List<?> objects = this.getModelObjects();
        if (!objects.isEmpty()) {
            return TransactionUtil.getEditingDomain(objects.get(0));
        }
        return null;
    }

    public void run(final IProgressMonitor monitor) throws CoreException {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Map<Object, Integer> modelObjectCounts = BasicCheckValidationOperation.this.getModelObjectCounts();
                    float problemMarkerToValidationWorkRatio = BasicCheckValidationOperation.this.getProblemMarkerToValidationWorkRatio();
                    int totalWork = Math.round((float)modelObjectCounts.get(ALL_MODEL_OBJECT_COUNT).intValue() * (1.0f + problemMarkerToValidationWorkRatio));
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_validating, (int)totalWork);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    for (Object modelObject : BasicCheckValidationOperation.this.getModelObjects()) {
                        int validationWork = modelObjectCounts.get(modelObject);
                        int problemMarkerWork = Math.round((float)validationWork * problemMarkerToValidationWorkRatio);
                        BasicCheckValidationOperation.this.validate(modelObject, progress.newChild(validationWork + problemMarkerWork), validationWork, problemMarkerWork);
                        if (!progress.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
            };
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            if (editingDomain != null) {
                editingDomain.runExclusive(runnable);
            } else {
                runnable.run();
            }
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            throw new CoreException(status);
        }
    }

    protected void validate(Object modelObject, SubMonitor progress, int validationWork, int problemMarkerWork) throws OperationCanceledException {
        Assert.isNotNull((Object)progress);
        if (modelObject instanceof EObject) {
            Diagnostic diagnostic = this.getDiagnostician().validate((EObject)modelObject, this.getOptions(), (IProgressMonitor)progress.newChild(validationWork));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.updateProblemMarkers((EObject)modelObject, diagnostic, (IProgressMonitor)progress.newChild(problemMarkerWork));
        } else {
            progress.done();
        }
    }

    protected void updateProblemMarkers(EObject eObject, Diagnostic diagnostic, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        CheckProblemMarkerService.INSTANCE.updateProblemMarkers(eObject, diagnostic);
        progress.worked(1);
    }
}

