/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.business.internal.migration.ActivatedFilterSortingMigrationParticipant;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Version;

public class LabelOnBorderMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION_6_1_4 = new Version("14.1.4.201908131800");
    public static final Version MIGRATION_VERSION_6_3_0 = ActivatedFilterSortingMigrationParticipant.MIGRATION_VERSION_FILTER_SORTING;
    public static final Version MIGRATION_VERSION = new Version("14.3.1.202003261200");
    private boolean migrationOccured;

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if ((loadedVersion.compareTo(MIGRATION_VERSION_6_1_4) == 0 || loadedVersion.compareTo(MIGRATION_VERSION_6_3_0) >= 0) && loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            super.postLoad(dAnalysis, loadedVersion);
            StringBuilder sb = new StringBuilder(Messages.LabelOnBorderMigrationParticipant_title);
            dAnalysis.getOwnedViews().stream().flatMap(view -> new DViewQuery(view).getLoadedRepresentations().stream()).filter(rep -> rep instanceof DDiagram).map(DDiagram.class::cast).forEach(dDiagram -> {
                boolean isLabelMoved = false;
                Collection<Node> nodesWithLabelOnBorder = this.getNodesWithLabelOnBorder((DDiagram)dDiagram);
                for (Node node : nodesWithLabelOnBorder) {
                    boolean bl = isLabelMoved = this.checkAndFixGMFCoordinatesOfLabelOnBorder(node) || isLabelMoved;
                }
                if (isLabelMoved) {
                    this.migrationOccured = true;
                    this.updateChangeId(dAnalysis, (DRepresentation)dDiagram);
                    sb.append(MessageFormat.format(Messages.LabelOnBorderMigrationParticipant_labelsModified, dDiagram.getName()));
                }
            });
            if (this.migrationOccured) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
                this.migrationOccured = false;
            }
        }
    }

    private boolean checkAndFixGMFCoordinatesOfLabelOnBorder(final Node node) {
        boolean isLabelMoved = false;
        for (Object child : node.getChildren()) {
            Dimension labelSize;
            Node childNode;
            int id;
            if (!(child instanceof Node) || (id = SiriusVisualIDRegistry.getVisualID((childNode = (Node)child).getType())) != 5002 && id != 5001 && id != 5003 && id != 5010) continue;
            LayoutConstraint labelLayoutConstraint = childNode.getLayoutConstraint();
            LayoutConstraint nodeLayoutConstraint = node.getLayoutConstraint();
            if (!(labelLayoutConstraint instanceof Location) || !(nodeLayoutConstraint instanceof Size)) continue;
            if (Display.getCurrent() != null) {
                labelSize = GMFHelper.getLabelDimension(node, new Dimension(50, 20));
            } else {
                RunnableWithResult.Impl<Dimension> getLabelDimension = new RunnableWithResult.Impl<Dimension>(){

                    public void run() {
                        this.setResult(GMFHelper.getLabelDimension(node, new Dimension(50, 20)));
                    }
                };
                EclipseUIUtil.displaySyncExec((Runnable)getLabelDimension);
                labelSize = (Dimension)getLabelDimension.getResult();
            }
            Size nodeSize = (Size)nodeLayoutConstraint;
            Location currentLabelLocation = (Location)labelLayoutConstraint;
            Location currentNodeLocation = (Location)nodeLayoutConstraint;
            if (currentLabelLocation.getY() == -labelSize.height() + IBorderItemOffsets.NO_OFFSET.height() || currentLabelLocation.getY() == nodeSize.getHeight() - IBorderItemOffsets.NO_OFFSET.height()) {
                isLabelMoved = this.computeNewLocationForNorthOrSouthSide(labelSize, nodeSize, currentLabelLocation, currentNodeLocation) || isLabelMoved;
                continue;
            }
            boolean bl = isLabelMoved = this.computeNewLocationForEastOrWestSide(labelSize, nodeSize, currentLabelLocation, currentNodeLocation) || isLabelMoved;
        }
        return isLabelMoved;
    }

    private boolean computeNewLocationForNorthOrSouthSide(Dimension labelSize, Size nodeSize, Location currentLabelLocation, Location currentNodeLocation) {
        boolean isLabelMoved = false;
        if (labelSize.width() > nodeSize.getWidth()) {
            if (currentLabelLocation.getX() != 0) {
                isLabelMoved = true;
                currentLabelLocation.setX(0);
            }
        } else if (currentLabelLocation.getX() < 0) {
            isLabelMoved = true;
            currentLabelLocation.setX(0);
        } else if (currentLabelLocation.getX() + labelSize.width() > nodeSize.getWidth()) {
            isLabelMoved = true;
            currentLabelLocation.setX(nodeSize.getWidth() - labelSize.width());
        }
        return isLabelMoved;
    }

    private boolean computeNewLocationForEastOrWestSide(Dimension labelSize, Size nodeSize, Location currentLabelLocation, Location currentNodeLocation) {
        boolean isLabelMoved = false;
        if (currentLabelLocation.getY() < 0) {
            isLabelMoved = true;
            currentLabelLocation.setY(0);
        } else if (currentLabelLocation.getY() + labelSize.height() > nodeSize.getHeight()) {
            isLabelMoved = true;
            currentLabelLocation.setY(nodeSize.getHeight() - labelSize.height());
        }
        return isLabelMoved;
    }

    private Collection<Node> getNodesWithLabelOnBorder(DDiagram dDiagram) {
        HashSet<Node> nodes = new HashSet<Node>();
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        Option<Diagram> gmfDiagram = query.getAssociatedGMFDiagram();
        if (gmfDiagram.some()) {
            ((Diagram)gmfDiagram.get()).eAllContents().forEachRemaining(eObject -> {
                Node node;
                if (eObject instanceof Node && this.isNodeWithLabelOnBorder(node = (Node)eObject)) {
                    nodes.add(node);
                }
            });
        }
        return nodes;
    }

    private boolean isNodeWithLabelOnBorder(Node node) {
        int id = SiriusVisualIDRegistry.getVisualID(node.getType());
        if (id == 2001 || id == 3001 || id == 3007 || id == 3012) {
            EObject element = node.getElement();
            return element instanceof DNode && ((DNode)element).getLabelPosition().equals((Object)LabelPosition.BORDER_LITERAL);
        }
        return false;
    }
}

