/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.routing;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.intermediate.loops.ordering.PortRestorer;
import org.eclipse.elk.core.options.PortSide;

public class RoutingDirector {
    private static final Comparator<SelfLoopPort> COMPARE_BY_ID = (slPort1, slPort2) -> Integer.compare(slPort1.getLPort().id, slPort2.getLPort().id);
    private static final int UNCONNECTED_PORT_PENALTY = 1;
    private static final int CONNECTED_PORT_PENALTY = 3;
    private int[] portPenalties = null;

    public void determineLoopRoutes(SelfLoopHolder slHolder) {
        this.assignPortIds(slHolder.getLNode().getPorts());
        this.sortHyperLoopPortLists(slHolder);
        for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            switch (slLoop.getSelfLoopType()) {
                case ONE_SIDE: {
                    this.determineOneSideLoopRoutes(slLoop);
                    break;
                }
                case TWO_SIDES_CORNER: {
                    this.determineTwoSideCornerLoopRoutes(slLoop);
                    break;
                }
                case TWO_SIDES_OPPOSING: {
                    this.determineTwoSideOpposingLoopRoutes(slLoop);
                    break;
                }
                case THREE_SIDES: {
                    this.determineThreeSideLoopRoutes(slLoop);
                    break;
                }
                case FOUR_SIDES: {
                    this.determineFourSideLoopRoutes(slLoop);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.computeOccupiedPortSides(slLoop);
        }
        this.portPenalties = null;
    }

    private void assignPortIds(List<LPort> lPorts) {
        int i = 0;
        while (i < lPorts.size()) {
            lPorts.get((int)i).id = i;
            ++i;
        }
    }

    private void sortHyperLoopPortLists(SelfLoopHolder slHolder) {
        slHolder.getSLHyperLoops().stream().map(slLoop -> slLoop.getSLPorts()).forEach(slPorts -> slPorts.sort(COMPARE_BY_ID));
    }

    private void computeOccupiedPortSides(SelfHyperLoop slLoop) {
        PortSide currPortSide = slLoop.getLeftmostPort().getLPort().getSide();
        PortSide targetSide = slLoop.getRightmostPort().getLPort().getSide();
        while (currPortSide != targetSide) {
            slLoop.getOccupiedPortSides().add(currPortSide);
            currPortSide = currPortSide.right();
        }
        slLoop.getOccupiedPortSides().add(currPortSide);
    }

    private void determineOneSideLoopRoutes(SelfHyperLoop slLoop) {
        PortSide side = slLoop.getSLPorts().get(0).getLPort().getSide();
        this.assignLeftmostRightmostPorts(slLoop, side, side);
    }

    private void determineTwoSideCornerLoopRoutes(SelfHyperLoop slLoop) {
        PortSide[] sides = PortRestorer.sortedTwoSideLoopPortSides(slLoop);
        this.assignLeftmostRightmostPorts(slLoop, sides[0], sides[1]);
    }

    private void determineTwoSideOpposingLoopRoutes(SelfHyperLoop slLoop) {
        SelfLoopPort option2RightmostPort;
        SelfLoopPort option2LeftmostPort;
        int option2Penalty;
        SelfLoopPort option1RightmostPort;
        SelfLoopPort option1LeftmostPort;
        PortSide[] sides = slLoop.getSLPortsBySide().keySet().toArray(new PortSide[2]);
        assert (sides.length == 2);
        SelfLoopHolder slHolder = slLoop.getSLHolder();
        int option1Penalty = this.computeEdgePenalty(slHolder, option1LeftmostPort = this.lowestPortOnSide(slLoop, sides[0]), option1RightmostPort = this.highestPortOnSide(slLoop, sides[1]));
        if (option1Penalty <= (option2Penalty = this.computeEdgePenalty(slHolder, option2LeftmostPort = this.lowestPortOnSide(slLoop, sides[1]), option2RightmostPort = this.highestPortOnSide(slLoop, sides[0])))) {
            slLoop.setLeftmostPort(option1LeftmostPort);
            slLoop.setRightmostPort(option1RightmostPort);
        } else {
            slLoop.setLeftmostPort(option2LeftmostPort);
            slLoop.setRightmostPort(option2RightmostPort);
        }
    }

    private void determineThreeSideLoopRoutes(SelfHyperLoop slLoop) {
        PortSide leftmostSide = null;
        PortSide rightmostSide = null;
        switch (this.computeMissingPortSide(slLoop)) {
            case NORTH: {
                leftmostSide = PortSide.EAST;
                rightmostSide = PortSide.WEST;
                break;
            }
            case EAST: {
                leftmostSide = PortSide.SOUTH;
                rightmostSide = PortSide.NORTH;
                break;
            }
            case SOUTH: {
                leftmostSide = PortSide.WEST;
                rightmostSide = PortSide.EAST;
                break;
            }
            case WEST: {
                leftmostSide = PortSide.NORTH;
                rightmostSide = PortSide.SOUTH;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.assignLeftmostRightmostPorts(slLoop, leftmostSide, rightmostSide);
    }

    private PortSide computeMissingPortSide(SelfHyperLoop slLoop) {
        Set sides = slLoop.getSLPortsBySide().keySet();
        assert (sides.size() == 3);
        assert (!sides.contains(PortSide.UNDEFINED));
        PortSide[] portSideArray = PortSide.values();
        int n = portSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortSide side = portSideArray[n2];
            if (side != PortSide.UNDEFINED && !sides.contains(side)) {
                return side;
            }
            ++n2;
        }
        assert (false);
        return null;
    }

    private void determineFourSideLoopRoutes(SelfHyperLoop slLoop) {
        List<SelfLoopPort> sortedSLPorts = slLoop.getSLPorts();
        SelfLoopHolder slHolder = slLoop.getSLHolder();
        SelfLoopPort worstLeftPort = sortedSLPorts.get(sortedSLPorts.size() - 1);
        SelfLoopPort worstRightPort = sortedSLPorts.get(0);
        int worstPenalty = this.computeEdgePenalty(slHolder, worstLeftPort, worstRightPort);
        int rightPortIndex = 1;
        while (rightPortIndex < sortedSLPorts.size()) {
            SelfLoopPort currRightPort;
            SelfLoopPort currLeftPort = sortedSLPorts.get(rightPortIndex - 1);
            int currPenalty = this.computeEdgePenalty(slHolder, currLeftPort, currRightPort = sortedSLPorts.get(rightPortIndex));
            if (currPenalty > worstPenalty) {
                worstLeftPort = currLeftPort;
                worstRightPort = currRightPort;
                worstPenalty = currPenalty;
            }
            ++rightPortIndex;
        }
        slLoop.setLeftmostPort(worstRightPort);
        slLoop.setRightmostPort(worstLeftPort);
    }

    private void assignLeftmostRightmostPorts(SelfHyperLoop slLoop, PortSide leftmostSide, PortSide rightmostSide) {
        slLoop.setLeftmostPort(this.lowestPortOnSide(slLoop, leftmostSide));
        slLoop.setRightmostPort(this.highestPortOnSide(slLoop, rightmostSide));
    }

    private SelfLoopPort lowestPortOnSide(SelfHyperLoop slLoop, PortSide side) {
        return slLoop.getSLPortsBySide(side).stream().min(COMPARE_BY_ID).get();
    }

    private SelfLoopPort highestPortOnSide(SelfHyperLoop slLoop, PortSide side) {
        return slLoop.getSLPortsBySide(side).stream().max(COMPARE_BY_ID).get();
    }

    private int computeEdgePenalty(SelfLoopHolder slHolder, SelfLoopPort leftmostPort, SelfLoopPort rightmostPort) {
        if (this.portPenalties == null) {
            this.computePenalties(slHolder);
        }
        int portCount = slHolder.getLNode().getPorts().size();
        int leftmostPortId = leftmostPort.getLPort().id;
        int rightmostPortId = rightmostPort.getLPort().id;
        int leftOfRightmostPortId = rightmostPortId - 1;
        if (leftOfRightmostPortId < 0) {
            leftOfRightmostPortId = portCount - 1;
        }
        if (leftmostPortId <= leftOfRightmostPortId) {
            return this.portPenalties[leftOfRightmostPortId] - this.portPenalties[leftmostPortId];
        }
        return this.portPenalties[portCount - 1] - this.portPenalties[leftmostPortId] + this.portPenalties[leftOfRightmostPortId];
    }

    private void computePenalties(SelfLoopHolder slHolder) {
        List<LPort> ports = slHolder.getLNode().getPorts();
        this.portPenalties = new int[ports.size()];
        int penaltySum = 0;
        int i = 0;
        while (i < ports.size()) {
            LPort currPort = ports.get(i);
            if (!currPort.getIncomingEdges().isEmpty() || !currPort.getOutgoingEdges().isEmpty()) {
                penaltySum += 3;
            }
            this.portPenalties[i] = ++penaltySum;
            ++i;
        }
    }
}

