/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.compaction.oned;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.elk.alg.common.compaction.Scanline;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.CompareFuzzy;
import org.eclipse.elk.alg.common.compaction.oned.IConstraintCalculationAlgorithm;
import org.eclipse.elk.alg.common.compaction.oned.OneDimensionalCompactor;

public class ScanlineConstraintCalculator
implements IConstraintCalculationAlgorithm {
    protected OneDimensionalCompactor compactor;
    private final Comparator<Timestamp> constraintsScanlineComparator = (p1, p2) -> {
        int cmp;
        double y1 = p1.node.hitbox.y;
        if (!p1.low) {
            y1 += p1.node.hitbox.height;
        }
        double y2 = p2.node.hitbox.y;
        if (!p2.low) {
            y2 += p2.node.hitbox.height;
        }
        if ((cmp = Double.compare(y1, y2)) == 0) {
            if (!p1.low && p2.low) {
                return -1;
            }
            if (!p2.low && p1.low) {
                return 1;
            }
        }
        return cmp;
    };
    private final ConstraintsScanlineHandler constraintsScanlineHandler = new ConstraintsScanlineHandler();

    @Override
    public void calculateConstraints(OneDimensionalCompactor theCompactor) {
        this.compactor = theCompactor;
        this.sweep((Predicate<CNode>)((Predicate)n -> true));
    }

    protected void sweep(Predicate<CNode> filterFun) {
        ArrayList points = Lists.newArrayList();
        for (CNode n : this.compactor.cGraph.cNodes) {
            if (!filterFun.apply((Object)n)) continue;
            points.add(new Timestamp(n, true));
            points.add(new Timestamp(n, false));
        }
        this.constraintsScanlineHandler.reset();
        Scanline.execute(points, this.constraintsScanlineComparator, this.constraintsScanlineHandler);
    }

    private boolean overlap(CNode n1, CNode n2) {
        if (n1 == null || n2 == null || n1 == n2) {
            return false;
        }
        return CompareFuzzy.le(n1.hitbox.x, n2.hitbox.x + n2.hitbox.width) && CompareFuzzy.le(n2.hitbox.x, n1.hitbox.x + n1.hitbox.width);
    }

    private class ConstraintsScanlineHandler
    implements Scanline.EventHandler<Timestamp> {
        private TreeSet<CNode> intervals = Sets.newTreeSet((c1, c2) -> Double.compare(c1.hitbox.x + c1.hitbox.width / 2.0, c2.hitbox.x + c2.hitbox.width / 2.0));
        private CNode[] cand;

        private ConstraintsScanlineHandler() {
        }

        public void reset() {
            this.intervals.clear();
            this.cand = new CNode[ScanlineConstraintCalculator.this.compactor.cGraph.cNodes.size()];
            int index = 0;
            for (CNode n : ScanlineConstraintCalculator.this.compactor.cGraph.cNodes) {
                n.id = index++;
            }
        }

        @Override
        public void handle(Timestamp p) {
            if (p.low) {
                this.insert(p);
            } else {
                this.delete(p);
            }
        }

        private void insert(Timestamp p) {
            boolean success = this.intervals.add(p.node);
            if (!success) {
                throw new IllegalStateException("Invalid hitboxes for scanline constraint calculation.");
            }
            if (ScanlineConstraintCalculator.this.overlap(p.node, this.intervals.floor(p.node)) || ScanlineConstraintCalculator.this.overlap(p.node, this.intervals.ceiling(p.node))) {
                System.err.println(p.node + " has overlap.");
            }
            this.cand[p.node.id] = this.intervals.lower(p.node);
            CNode right = this.intervals.higher(p.node);
            if (right != null) {
                this.cand[right.id] = p.node;
            }
        }

        private void delete(Timestamp p) {
            CNode right;
            CNode left = this.intervals.lower(p.node);
            if (left != null && left == this.cand[p.node.id] && left.cGroup != null && left.cGroup != p.node.cGroup) {
                left.constraints.add(p.node);
            }
            if ((right = this.intervals.higher(p.node)) != null && this.cand[right.id] == p.node && right.cGroup != null && right.cGroup != p.node.cGroup) {
                p.node.constraints.add(right);
            }
            this.intervals.remove(p.node);
        }
    }

    private class Timestamp {
        private boolean low;
        private CNode node;

        Timestamp(CNode node, boolean low) {
            this.node = node;
            this.low = low;
        }
    }
}

