/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout.horizontal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionContainer;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.AbstractSequenceOrderingLayout;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.horizontal.LostMessageEndHorizontalLayoutHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceElementQuery;
import org.eclipse.sirius.ext.base.Option;

public class SequenceHorizontalLayout
extends AbstractSequenceOrderingLayout<ISequenceElement, Rectangle, InstanceRole> {
    private static final boolean INTERACTION_CONTAINER_DYNAMIC_LEFT = Boolean.getBoolean("org.eclipse.sirius.diagram.sequence.layout.interaction.container.dynamic.left");
    private static final Function<Rectangle, Integer> RECT_TO_X = new Function<Rectangle, Integer>(){

        public Integer apply(Rectangle input) {
            return input.x;
        }
    };
    private final Insets padding = new Insets(50, 50, 0, -40);
    private final Collection<AbstractFrame> frames = new ArrayList<AbstractFrame>();
    private final Multimap<AbstractFrame, Lifeline> coverage = HashMultimap.create();
    private final Multimap<Lifeline, AbstractFrame> invCoverage = HashMultimap.create();
    private final Map<AbstractFrame, Range> ranges = new HashMap<AbstractFrame, Range>();
    private final Map<AbstractFrame, Integer> frameChildrenDepths = new HashMap<AbstractFrame, Integer>();
    private final Map<Lifeline, Integer> lifelineChildrenDepths = new HashMap<Lifeline, Integer>();
    private LostMessageEndHorizontalLayoutHelper lostMessageEndHorizontalLayoutHelper;
    private final Map<Message, Integer> reflexiveMessagesToLayout = new HashMap<Message, Integer>();

    public SequenceHorizontalLayout(SequenceDiagram diagram) {
        super(diagram);
    }

    @Override
    protected void init(boolean pack) {
        if (pack) {
            this.padding.left = 50;
            this.padding.right = -20;
        }
        this.populateSortedIntanceRoles();
        this.populateLifelineDepth();
        this.populateFrames();
        this.populateLostMessageEnds();
        this.populateReflexiveMessages();
    }

    @Override
    protected Rectangle getOldLayoutData(ISequenceElement ise) {
        return ise.getProperLogicalBounds();
    }

    @Override
    protected Map<ISequenceElement, Rectangle> computeLayout(boolean pack) {
        LinkedHashMap<ISequenceElement, Rectangle> allMoves = new LinkedHashMap<ISequenceElement, Rectangle>();
        Map<LostMessageEnd, Integer> lostEndsDelta = this.lostMessageEndHorizontalLayoutHelper.computeLostMessageEndDeltaWithLifeline(pack);
        Map<Message, Rectangle> reflexiveMessagesMoves = this.computeReflexiveMessagesHorizontalBounds();
        Map<InstanceRole, Rectangle> irMoves = this.computeInstanceRoleHorizontalLocations(pack, lostEndsDelta);
        Map<LostMessageEnd, Rectangle> lostMessageEndMoves = this.lostMessageEndHorizontalLayoutHelper.computeLostMessageEndsHorizontalBounds(irMoves, lostEndsDelta);
        Map<AbstractFrame, Rectangle> frameMoves = this.computeFrameHorizontalBounds(irMoves, lostEndsDelta);
        allMoves.putAll(irMoves);
        allMoves.putAll(frameMoves);
        allMoves.putAll(lostMessageEndMoves);
        allMoves.putAll(reflexiveMessagesMoves);
        Optional<InteractionContainer> optionalInteractionContainer = this.sequenceDiagram.getInteractionContainer();
        if (optionalInteractionContainer.isPresent()) {
            Rectangle interactionContainerMove = this.computeInteractionContainerLayout(optionalInteractionContainer.get(), allMoves, lostEndsDelta);
            allMoves.put(optionalInteractionContainer.get(), interactionContainerMove);
        }
        return allMoves;
    }

    @Override
    protected boolean applyComputedLayout(Map<? extends ISequenceElement, Rectangle> bounds, boolean pack) {
        boolean applied = false;
        applied = this.layoutInstanceRoles(bounds, pack) || applied;
        applied = this.layoutFrames(bounds, pack) || applied;
        applied = this.layoutLostMessageEnds(bounds, pack) || applied;
        applied = this.layoutReflexiveMessages(bounds, pack) || applied;
        applied = this.layoutInteractionContainer(bounds, pack) || applied;
        return applied;
    }

    @Override
    protected void dispose() {
        this.frameChildrenDepths.clear();
        this.lifelineChildrenDepths.clear();
        this.coverage.clear();
        this.invCoverage.clear();
        this.ranges.clear();
        this.frames.clear();
        this.lostMessageEndHorizontalLayoutHelper.dispose();
        this.reflexiveMessagesToLayout.clear();
        super.dispose();
    }

    private void correctGmfLocations() {
        this.layoutAbstractNodes();
        this.layoutLifeline();
    }

    private void layoutLifeline() {
        for (Lifeline lifeline : this.sequenceDiagram.getAllLifelines()) {
            Rectangle properLogicalBounds = lifeline.getProperLogicalBounds();
            Rectangle parentLogicalBounds = lifeline.getInstanceRole().getProperLogicalBounds();
            LayoutConstraint layoutConstraint = lifeline.getNotationNode().getLayoutConstraint();
            if (!(layoutConstraint instanceof Location)) continue;
            Location loc = (Location)layoutConstraint;
            loc.setX(properLogicalBounds.x - parentLogicalBounds.x);
        }
    }

    private void layoutAbstractNodes() {
        for (AbstractNodeEvent exec : this.sequenceDiagram.getAllAbstractNodeEvents()) {
            Rectangle properLogicalBounds = exec.getProperLogicalBounds();
            Rectangle parentLogicalBounds = exec.getHierarchicalParentEvent().getProperLogicalBounds();
            LayoutConstraint layoutConstraint = exec.getNotationNode().getLayoutConstraint();
            if (!(layoutConstraint instanceof Location)) continue;
            Location loc = (Location)layoutConstraint;
            loc.setX(properLogicalBounds.x - parentLogicalBounds.x);
        }
    }

    private void populateSortedIntanceRoles() {
        this.graphicalOrdering.addAll(this.sequenceDiagram.getSortedInstanceRole());
        this.semanticOrdering.addAll(this.graphicalOrdering);
        SequenceDDiagram sequenceDDiagram = this.sequenceDiagram.getSequenceDDiagram();
        if (sequenceDDiagram != null && !sequenceDDiagram.getInstanceRoleSemanticOrdering().getSemanticInstanceRoles().isEmpty()) {
            EList semanticOrder = sequenceDDiagram.getInstanceRoleSemanticOrdering().getSemanticInstanceRoles();
            Function<InstanceRole, Integer> semanticIndex = new Function<InstanceRole, Integer>((List)semanticOrder){
                private final /* synthetic */ List val$semanticOrder;
                {
                    this.val$semanticOrder = list;
                }

                public Integer apply(InstanceRole ir) {
                    Option<EObject> semIr = ir.getSemanticTargetElement();
                    return semIr.some() ? this.val$semanticOrder.indexOf(semIr.get()) : -1;
                }
            };
            Collections.sort(this.semanticOrdering, Ordering.natural().onResultOf((Function)semanticIndex));
        }
        for (InstanceRole role : this.semanticOrdering) {
            ISequenceElementQuery query = new ISequenceElementQuery(role);
            if (!query.hasAbsoluteBoundsFlag()) continue;
            Rectangle flaggedAbsoluteBounds = query.getFlaggedAbsoluteBounds();
            this.oldFlaggedLayoutData.put(role, flaggedAbsoluteBounds);
            this.flaggedEnds.add(role);
        }
        Collections.sort(this.flaggedEnds, Ordering.natural().onResultOf(this.getOldFlaggedPosition()));
        this.checkOrderingSync();
    }

    private void populateLifelineDepth() {
        List<Lifeline> allLifelines = this.sequenceDiagram.getAllLifelines();
        for (Lifeline lifeline : allLifelines) {
            int depth = this.getOrComputeMaxChildrenDepth(lifeline.getNotationNode(), lifeline.getVerticalRange());
            this.lifelineChildrenDepths.put(lifeline, depth);
        }
    }

    private void populateLostMessageEnds() {
        this.lostMessageEndHorizontalLayoutHelper = new LostMessageEndHorizontalLayoutHelper(this.sequenceDiagram);
        this.lostMessageEndHorizontalLayoutHelper.populateLostMessageEnds();
    }

    private void populateFrames() {
        ArrayList<AbstractFrame> allFrames = new ArrayList<AbstractFrame>();
        allFrames.addAll(this.sequenceDiagram.getAllInteractionUses());
        allFrames.addAll(this.sequenceDiagram.getAllCombinedFragments());
        for (AbstractFrame frame : allFrames) {
            Collection<Lifeline> coveredLifelines = frame.computeCoveredLifelines();
            if (coveredLifelines.isEmpty()) continue;
            this.frames.add(frame);
            this.coverage.putAll((Object)frame, coveredLifelines);
            this.ranges.put(frame, frame.getVerticalRange());
        }
        for (AbstractFrame frame : this.frames) {
            this.getOrComputeMaxChildrenDepth(frame, Collections.singletonList(frame));
        }
        Multimaps.invertFrom(this.coverage, this.invCoverage);
    }

    private void populateReflexiveMessages() {
        for (Message msg : this.sequenceDiagram.getAllMessages()) {
            int width;
            if (!msg.isReflective() || (width = msg.getReflexiveMessageWidth()) == 0) continue;
            this.reflexiveMessagesToLayout.put(msg, width);
        }
    }

    private int getOrComputeMaxChildrenDepth(Node node, Range range) {
        int maxChildrenDepth = 0;
        for (Node child : Iterables.filter((Iterable)Iterables.filter((Iterable)node.getChildren(), Node.class), AbstractNodeEvent.notationPredicate())) {
            AbstractNodeEvent childExec = (AbstractNodeEvent)ISequenceElementAccessor.getAbstractNodeEvent((View)child).get();
            if (range != null && !range.intersects(childExec.getVerticalRange())) continue;
            int childDepth = 1 + this.getOrComputeMaxChildrenDepth(child, range);
            maxChildrenDepth = Math.max(childDepth, maxChildrenDepth);
        }
        return maxChildrenDepth;
    }

    private int getOrComputeMaxChildrenDepth(AbstractFrame frame, Collection<AbstractFrame> framesToIgnore) {
        int children = 0;
        if (!this.frameChildrenDepths.containsKey(frame)) {
            Collection frameCoverage = this.coverage.get((Object)frame);
            Range frameRange = this.ranges.get(frame);
            for (AbstractFrame potentialChild : Iterables.filter(this.frames, (Predicate)Predicates.not((Predicate)Predicates.in(framesToIgnore)))) {
                Collection potentialCoverage = this.coverage.get((Object)potentialChild);
                Range potentialRange = this.ranges.get(potentialChild);
                if (frame == potentialChild || !frameCoverage.containsAll(potentialCoverage) || !frameRange.includes(potentialRange)) continue;
                ArrayList<AbstractFrame> newArrayList = new ArrayList<AbstractFrame>(framesToIgnore);
                newArrayList.add(potentialChild);
                children = Math.max(children, 1 + this.getOrComputeMaxChildrenDepth(potentialChild, newArrayList));
            }
            this.frameChildrenDepths.put(frame, children);
        } else {
            children = this.frameChildrenDepths.get(frame);
        }
        return children;
    }

    private Map<AbstractFrame, Rectangle> computeFrameHorizontalBounds(Map<InstanceRole, Rectangle> irMoves, Map<LostMessageEnd, Integer> lostEndsDelta) {
        HashMap<AbstractFrame, Rectangle> frameMoves = new HashMap<AbstractFrame, Rectangle>();
        for (AbstractFrame frame : this.frames) {
            int irWidth;
            Range verticalRange;
            Rectangle newBounds = null;
            Lifeline leftLifeline = null;
            Lifeline rightLifeline = null;
            for (Lifeline lifeline : this.coverage.get((Object)frame)) {
                Rectangle lBounds = this.getInstanceRoleBounds(lifeline.getInstanceRole(), irMoves);
                if (newBounds == null) {
                    newBounds = lBounds.getCopy();
                } else {
                    newBounds.union(lBounds);
                }
                if (lBounds.right() == newBounds.right()) {
                    rightLifeline = lifeline;
                }
                if (lBounds.x != newBounds.x) continue;
                leftLifeline = lifeline;
            }
            Integer frameDepth = this.frameChildrenDepths.get(frame);
            int frameDepthGap = frameDepth * 10;
            if (rightLifeline != null) {
                verticalRange = frame.getVerticalRange();
                irWidth = this.getInstanceRoleBounds((InstanceRole)rightLifeline.getInstanceRole(), irMoves).width;
                int lifelineRightGap = this.getLifelineRightGap(rightLifeline, verticalRange, irWidth, lostEndsDelta);
                newBounds.setWidth(newBounds.width + Math.max(lifelineRightGap, frameDepthGap));
            }
            if (leftLifeline != null) {
                verticalRange = frame.getVerticalRange();
                irWidth = this.getInstanceRoleBounds((InstanceRole)leftLifeline.getInstanceRole(), irMoves).width;
                int lifelineLeftGap = this.getLifelineLeftGap(rightLifeline, verticalRange, irWidth, lostEndsDelta);
                lifelineLeftGap = Math.max(lifelineLeftGap, frameDepthGap);
                newBounds.setX(newBounds.x - lifelineLeftGap);
                newBounds.setWidth(newBounds.width + lifelineLeftGap);
            }
            frameMoves.put(frame, newBounds);
        }
        return frameMoves;
    }

    private Rectangle getInstanceRoleBounds(InstanceRole instanceRole, Map<InstanceRole, Rectangle> irMoves) {
        if (irMoves.containsKey(instanceRole)) {
            return irMoves.get(instanceRole);
        }
        return instanceRole.getBounds();
    }

    private Map<InstanceRole, Rectangle> computeInstanceRoleHorizontalLocations(boolean pack, Map<LostMessageEnd, Integer> lostEndsDelta) {
        HashMap<InstanceRole, Rectangle> computedMoves = new HashMap<InstanceRole, Rectangle>();
        int currentX = this.padding.left;
        for (InstanceRole instanceRole : this.semanticOrdering) {
            currentX = this.computeLocation(currentX, instanceRole, pack, lostEndsDelta, computedMoves);
        }
        return computedMoves;
    }

    private int computeLocation(int currentX, InstanceRole instanceRole, boolean pack, Map<LostMessageEnd, Integer> lostEndsDelta, Map<InstanceRole, Rectangle> computedMoves) {
        Rectangle oldBounds = instanceRole.getProperLogicalBounds();
        Option<Lifeline> lifeline = instanceRole.getLifeline();
        int newMinX = currentX;
        int rightComputedGap = 0;
        if (lifeline.some()) {
            int maxFrameDepth = this.getMaxFrameDepth((Lifeline)lifeline.get());
            int foundMessagesGap = this.getLifelineLeftGap((Lifeline)lifeline.get(), null, oldBounds.width, lostEndsDelta);
            int frameGap = maxFrameDepth * 10;
            int rightGap = this.getLifelineRightGap((Lifeline)lifeline.get(), null, oldBounds.width, lostEndsDelta);
            newMinX += frameGap + foundMessagesGap;
            rightComputedGap = frameGap + rightGap;
        }
        Rectangle newBounds = oldBounds.getCopy();
        if (pack) {
            newBounds.setX(newMinX);
        } else {
            int deltaStablePosition = this.getDeltaStablePosition(newMinX, instanceRole, Maps.transformValues(computedMoves, RECT_TO_X));
            newBounds.setX(Math.max(newMinX, Math.max(newBounds.x, deltaStablePosition)));
        }
        computedMoves.put(instanceRole, newBounds);
        return newBounds.right() + this.getMinInstanceRoleGap() + rightComputedGap;
    }

    private int getMaxReflexiveDepth(Lifeline lifeline, Range zone) {
        int maxWidth = 0;
        for (Map.Entry<Message, Integer> msg : this.reflexiveMessagesToLayout.entrySet()) {
            if (!lifeline.equals(msg.getKey().getLifeline().get()) || zone != null && !zone.includes(msg.getKey().getVerticalRange())) continue;
            maxWidth = Math.max(maxWidth, msg.getValue());
        }
        return maxWidth;
    }

    private Map<Message, Rectangle> computeReflexiveMessagesHorizontalBounds() {
        HashMap<Message, Rectangle> computedMoves = new HashMap<Message, Rectangle>();
        for (Map.Entry<Message, Integer> msg : this.reflexiveMessagesToLayout.entrySet()) {
            Rectangle properLogicalBounds = msg.getKey().getProperLogicalBounds();
            properLogicalBounds.setWidth(msg.getValue().intValue());
            computedMoves.put(msg.getKey(), properLogicalBounds);
        }
        return computedMoves;
    }

    private int getMinInstanceRoleGap() {
        return this.padding.right + this.padding.left;
    }

    private int getMaxExecDepth(Lifeline lifeline) {
        int depth = 0;
        if (this.lifelineChildrenDepths.containsKey(lifeline)) {
            depth = this.lifelineChildrenDepths.get(lifeline);
        }
        return depth;
    }

    private int getMaxFrameDepth(Lifeline lifeline) {
        int depth = 0;
        Collection collection = this.invCoverage.get((Object)lifeline);
        if (collection != null && !collection.isEmpty()) {
            for (AbstractFrame abstractFrame : collection) {
                Integer integer = this.frameChildrenDepths.get(abstractFrame);
                depth = Math.max(integer, depth);
            }
        }
        return depth;
    }

    private int getLifelineRightGap(Lifeline lifeline, Range zone, int irWidth, Map<LostMessageEnd, Integer> lostEndsDelta) {
        int execDepth;
        int rightGap = 0;
        int n = execDepth = zone == null ? this.getMaxExecDepth(lifeline) : this.getOrComputeMaxChildrenDepth(lifeline.getNotationNode(), zone);
        if (execDepth != 0) {
            int gap = 10;
            gap += (execDepth - 1) * 15;
            rightGap = Math.max(0, gap += -irWidth / 2 + 10);
        }
        int reflexiveGap = this.getMaxReflexiveDepth(lifeline, zone) - irWidth / 2;
        rightGap = Math.max(rightGap, reflexiveGap);
        rightGap = Math.max(rightGap, this.lostMessageEndHorizontalLayoutHelper.getRightEndsGap(lifeline, zone, lostEndsDelta) - irWidth / 2);
        return rightGap;
    }

    private int getLifelineLeftGap(Lifeline lifeline, Range zone, int irWidth, Map<LostMessageEnd, Integer> lostEndsDelta) {
        int leftGap = 0;
        leftGap = Math.max(leftGap, this.lostMessageEndHorizontalLayoutHelper.getLeftGap(lifeline, zone, lostEndsDelta) - irWidth / 2);
        return leftGap;
    }

    private Rectangle computeInteractionContainerLayout(InteractionContainer interactionContainer, Map<? extends ISequenceElement, Rectangle> bounds, Map<LostMessageEnd, Integer> lostEndsDelta) {
        Rectangle rectangle = new Rectangle(-1, 0, 180, 500);
        if (INTERACTION_CONTAINER_DYNAMIC_LEFT) {
            rectangle.setX(-1);
        }
        for (Map.Entry<? extends ISequenceElement, Rectangle> entry : bounds.entrySet()) {
            int left;
            int executionOrMessageDepthRightGap;
            ISequenceElement elt = entry.getKey();
            Rectangle sequenceElementRectangle = entry.getValue();
            int right = sequenceElementRectangle.right() + 50;
            if (elt instanceof InstanceRole && elt.getLifeline().some() && (executionOrMessageDepthRightGap = this.getLifelineRightGap((Lifeline)elt.getLifeline().get(), null, sequenceElementRectangle.width, lostEndsDelta)) > 10) {
                right += executionOrMessageDepthRightGap - 10;
            }
            if (right > rectangle.right()) {
                rectangle.setRight(right);
            }
            if (!INTERACTION_CONTAINER_DYNAMIC_LEFT || (left = sequenceElementRectangle.x() - 50) >= rectangle.x() && rectangle.x() != -1) continue;
            if (rectangle.x() == -1) {
                rectangle.setX(0);
            }
            rectangle.shrinkLeft(left - rectangle.x());
        }
        return rectangle;
    }

    private boolean layoutInstanceRoles(Map<? extends ISequenceElement, Rectangle> bounds, boolean pack) {
        boolean applied = false;
        for (InstanceRole instanceRole : Iterables.filter(bounds.keySet(), InstanceRole.class)) {
            Node node = instanceRole.getNotationNode();
            Integer computedX = bounds.get((Object)instanceRole).x;
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Location) {
                Location location = (Location)layoutConstraint;
                location.setX(computedX.intValue());
            }
            applied = true;
        }
        return applied;
    }

    private boolean layoutFrames(Map<? extends ISequenceElement, Rectangle> bounds, boolean pack) {
        boolean applied = false;
        for (AbstractFrame frame : Iterables.filter(bounds.keySet(), AbstractFrame.class)) {
            Rectangle newBounds = bounds.get(frame);
            Node notationNode = frame.getNotationNode();
            LayoutConstraint layoutConstraint = notationNode.getLayoutConstraint();
            if (layoutConstraint instanceof Bounds && newBounds != null) {
                Bounds b = (Bounds)layoutConstraint;
                b.setWidth(newBounds.width);
                b.setX(newBounds.x);
                applied = true;
            }
            if (!(frame instanceof CombinedFragment)) continue;
            CombinedFragment cf = (CombinedFragment)frame;
            for (Operand op : cf.getOperands()) {
                Node opNode = op.getNotationNode();
                LayoutConstraint opLC = opNode.getLayoutConstraint();
                if (!(opLC instanceof Bounds) || newBounds == null) continue;
                Bounds opBounds = (Bounds)opLC;
                opBounds.setWidth(newBounds.width);
                opBounds.setX(0);
                applied = true;
            }
        }
        return applied;
    }

    private boolean layoutLostMessageEnds(Map<? extends ISequenceElement, Rectangle> bounds, boolean pack) {
        boolean applied = false;
        for (LostMessageEnd lostMessageEnd : Iterables.filter(bounds.keySet(), LostMessageEnd.class)) {
            Node node = lostMessageEnd.getNotationNode();
            Integer computedX = bounds.get((Object)lostMessageEnd).x;
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (!(layoutConstraint instanceof Location)) continue;
            Location location = (Location)layoutConstraint;
            location.setX(computedX.intValue());
            applied = true;
        }
        return applied;
    }

    private boolean layoutReflexiveMessages(Map<? extends ISequenceElement, Rectangle> bounds, boolean pack) {
        boolean applied = false;
        for (Message msg : Iterables.filter(bounds.keySet(), Message.class)) {
            RelativeBendpoints relativeBendpoints;
            Iterable points;
            Bendpoints bendpoints = msg.getNotationEdge().getBendpoints();
            if (!msg.isReflective() || !(bendpoints instanceof RelativeBendpoints) || Iterables.size((Iterable)(points = Iterables.filter((Iterable)(relativeBendpoints = (RelativeBendpoints)bendpoints).getPoints(), RelativeBendpoint.class))) != 4) continue;
            RelativeBendpoint p0 = (RelativeBendpoint)Iterables.get((Iterable)points, (int)0);
            RelativeBendpoint p1 = (RelativeBendpoint)Iterables.get((Iterable)points, (int)1);
            RelativeBendpoint p2 = (RelativeBendpoint)Iterables.get((Iterable)points, (int)2);
            RelativeBendpoint p3 = (RelativeBendpoint)Iterables.get((Iterable)points, (int)3);
            int deltaX = bounds.get((Object)msg).width - p1.getSourceX();
            RelativeBendpoint newP1 = new RelativeBendpoint(p1.getSourceX() + deltaX, p1.getSourceY(), p1.getTargetX() + deltaX, p1.getTargetY());
            RelativeBendpoint newP2 = new RelativeBendpoint(p2.getSourceX() + deltaX, p2.getSourceY(), p2.getTargetX() + deltaX, p2.getTargetY());
            ArrayList<RelativeBendpoint> newPoints = new ArrayList<RelativeBendpoint>();
            newPoints.add(p0);
            newPoints.add(newP1);
            newPoints.add(newP2);
            newPoints.add(p3);
            relativeBendpoints.setPoints(newPoints);
            applied = true;
        }
        return applied;
    }

    /*
     * WARNING - void declaration
     */
    private boolean layoutInteractionContainer(Map<? extends ISequenceElement, Rectangle> bounds, boolean pack) {
        boolean applied = false;
        for (InteractionContainer interactionContainer : Iterables.filter(bounds.keySet(), InteractionContainer.class)) {
            void interactionContainerBounds;
            Rectangle rectangle = bounds.get(interactionContainer);
            Node node = interactionContainer.getNotationNode();
            LayoutConstraint interactionContainerLayoutConstraint = node.getLayoutConstraint();
            LayoutConstraint layoutConstraint = interactionContainerLayoutConstraint;
            if (!(layoutConstraint instanceof Bounds)) continue;
            Bounds cfr_ignored_0 = (Bounds)layoutConstraint;
            Bounds cfr_ignored_1 = (Bounds)layoutConstraint;
            if (rectangle == null) continue;
            interactionContainerBounds.setX(rectangle.x);
            interactionContainerBounds.setWidth(rectangle.width);
            applied = true;
        }
        return applied;
    }

    @Override
    protected Function<InstanceRole, Integer> getOldPosition() {
        return new Function<InstanceRole, Integer>(){

            public Integer apply(InstanceRole input) {
                return input.getProperLogicalBounds().x;
            }
        };
    }

    @Override
    protected Function<InstanceRole, Integer> getOldFlaggedPosition() {
        return new Function<InstanceRole, Integer>(){

            public Integer apply(InstanceRole input) {
                int oldFlaggedPosition = Integer.MIN_VALUE;
                Rectangle flaggedData = (Rectangle)SequenceHorizontalLayout.this.oldFlaggedLayoutData.get(input);
                if (flaggedData != null) {
                    oldFlaggedPosition = flaggedData.x;
                }
                return oldFlaggedPosition;
            }
        };
    }
}

