/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.api.controllers;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public abstract class AbstractEEFWidgetController
extends AbstractEEFController
implements IEEFWidgetController {
    protected Consumer<String> newLabelConsumer;
    protected Consumer<String> newHelpConsumer;

    public AbstractEEFWidgetController(IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
    }

    protected abstract EEFWidgetDescription getDescription();

    @Override
    protected EObject getValidationRulesContainer() {
        return this.getDescription();
    }

    @Override
    protected EReference getValidationRulesReference() {
        return EefPackage.Literals.EEF_WIDGET_DESCRIPTION__PROPERTY_VALIDATION_RULES;
    }

    @Override
    public void onNewLabel(Consumer<String> consumer) {
        this.newLabelConsumer = consumer;
    }

    @Override
    public void removeNewLabelConsumer() {
        this.newLabelConsumer = null;
    }

    @Override
    public void onNewHelp(Consumer<String> consumer) {
        this.newHelpConsumer = consumer;
    }

    @Override
    public void removeNewHelpConsumer() {
        this.newHelpConsumer = null;
    }

    @Override
    public void refresh() {
        super.refresh();
        String labelExpression = this.getDescription().getLabelExpression();
        Optional.ofNullable(this.newLabelConsumer).ifPresent(consumer -> this.newEval().logIfInvalidType(String.class).call(labelExpression, (Consumer<String>)consumer));
    }

    @Override
    public void computeHelp() {
        String helpExpression = this.getDescription().getHelpExpression();
        Optional.ofNullable(this.newHelpConsumer).ifPresent(consumer -> this.newEval().logIfInvalidType(String.class).call(helpExpression, (Consumer<String>)consumer));
    }
}

