/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICreationTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.helper.decoration.DecorationHelperInternal;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.diagram.tools.api.refresh.BestMappingGetter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;

public class CreateDEdgeTask
extends AbstractCommandTask
implements ICreationTask {
    private EdgeCreationDescription tool;
    private DCommand cmd;
    private ModelAccessor modelAccessor;
    private EdgeTarget sourceView;
    private EdgeTarget targetView;
    private Collection<DEdge> createdDEdges = new ArrayList<DEdge>();

    public CreateDEdgeTask(EdgeCreationDescription tool, DCommand cmd, ModelAccessor modelAccessor, EdgeTarget sourceView, EdgeTarget targetView) {
        this.tool = tool;
        this.cmd = cmd;
        this.modelAccessor = modelAccessor;
        this.sourceView = sourceView;
        this.targetView = targetView;
    }

    public void execute() {
        EObjectQuery eObjectQuery = new EObjectQuery((EObject)this.sourceView);
        DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)eObjectQuery.getParentDiagram().get();
        Session session = eObjectQuery.getSession();
        IInterpreter interpreter = session.getInterpreter();
        DDiagramSynchronizer dDiagramSynchronizer = new DDiagramSynchronizer(interpreter, dSemanticDiagram.getDescription(), this.modelAccessor);
        dDiagramSynchronizer.setDiagram(dSemanticDiagram);
        dDiagramSynchronizer.setTool(true);
        DDiagramElementSynchronizer dDiagramElementSynchronizer = dDiagramSynchronizer.getElementSynchronizer();
        HashMap<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration = new HashMap<EdgeMapping, Collection<MappingBasedDecoration>>();
        HashMap<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration = new HashMap<String, Collection<SemanticBasedDecoration>>();
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, (DDiagram)dSemanticDiagram);
        Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets = dDiagramElementSynchronizer.computeMappingsToEdgeTargets(session.getSelectedViewpoints(false));
        new DecorationHelperInternal((DDiagram)dSemanticDiagram, interpreter, this.modelAccessor).computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
        for (EObject semanticElt : this.getAllSemantics()) {
            Option<DEdge> createdDEdgeOption;
            BestMappingGetter bestMappingGetter = new BestMappingGetter(this.sourceView, this.targetView, semanticElt);
            EdgeMapping bestEdgeMapping = bestMappingGetter.getBestEdgeMapping((Collection<EdgeMapping>)this.tool.getEdgeMappings());
            if (bestEdgeMapping == null || !(createdDEdgeOption = dDiagramSynchronizer.createEdgeMapping(mappingManager, mappingsToEdgeTargets, bestEdgeMapping, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration)).some()) continue;
            this.createdDEdges.add((DEdge)createdDEdgeOption.get());
        }
    }

    public String getLabel() {
        return Messages.CreateDEdgeTask_label;
    }

    private Collection<EObject> getAllSemantics() {
        LinkedHashSet<EObject> semantics = new LinkedHashSet<EObject>(this.cmd.getCreatedObjects());
        semantics.addAll(this.cmd.getAffectedElements());
        return semantics;
    }

    public Collection<DRepresentationElement> getCreatedRepresentationElements() {
        return new ArrayList<DEdge>(this.createdDEdges);
    }

    public Collection<EObject> getCreatedElements() {
        return Collections.emptySet();
    }

    public Collection<EObject> getAffectedElements() {
        return Collections.emptySet();
    }

    public Collection<EObject> getCreatedReferences() {
        return Collections.emptySet();
    }
}

