/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.LayoutingModeSwitchingAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.VisibilityModeSwitchingAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.StandardModeAction;
import org.eclipse.ui.IWorkbenchPage;

public class ModesMenuManager
extends ActionMenuManager {
    private StandardModeAction standardModeAction;
    private LayoutingModeSwitchingAction layoutingModeSwitchingAction;
    private VisibilityModeSwitchingAction visibilityModeSwitchingAction;

    public ModesMenuManager(IWorkbenchPage page, DDiagram editorDiagram) {
        super("defaultMode", (IAction)new StandardModeMenuAction(), true);
    }

    public void setDefaultAction(String actionId) {
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && actionId.equals(((ActionContributionItem)item).getAction().getId())) {
                IAction defaultAction = ((ActionContributionItem)item).getAction();
                this.setHandler(defaultAction);
                super.setDefaultAction(defaultAction);
                return;
            }
            ++n2;
        }
    }

    private void setHandler(IAction defaultAction) {
        try {
            Method method = ActionMenuManager.MenuCreatorAction.class.getDeclaredMethod("setActionHandler", IAction.class);
            method.setAccessible(true);
            method.invoke((Object)this.action, defaultAction);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    protected void itemRemoved(IContributionItem item) {
        IAction action;
        if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof IDisposableAction) {
            ((IDisposableAction)action).dispose();
        }
    }

    public void dispose() {
        this.standardModeAction = null;
        this.layoutingModeSwitchingAction = null;
        this.visibilityModeSwitchingAction = null;
        this.removeAll();
        super.dispose();
    }

    public void refresh() {
        this.standardModeAction.refresh();
        if (this.visibilityModeSwitchingAction != null) {
            this.visibilityModeSwitchingAction.refresh();
        }
        if (this.layoutingModeSwitchingAction != null) {
            this.layoutingModeSwitchingAction.refresh();
        }
    }

    public void setVisible(boolean visible) {
        if (this.isEmpty() && visible) {
            IWorkbenchPage page = EclipseUIUtil.getActivePage();
            if (page != null && page.getActivePart() instanceof DDiagramEditor) {
                DDiagramEditor editor = (DDiagramEditor)page.getActivePart();
                DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
                boolean visibilityModeActive = VisibilityModeSwitchingAction.diagramAllowsVisibilityMode(editorDiagram);
                boolean layoutingModeActive = LayoutingModeSwitchingAction.diagramAllowsLayoutingMode(editorDiagram);
                if (!visibilityModeActive && !layoutingModeActive) {
                    super.setVisible(false);
                } else {
                    this.standardModeAction = new StandardModeAction(page, editor, editorDiagram, this);
                    this.add((IAction)this.standardModeAction);
                    if (visibilityModeActive) {
                        this.visibilityModeSwitchingAction = new VisibilityModeSwitchingAction(page, editor, editorDiagram, this);
                        this.add((IAction)this.visibilityModeSwitchingAction);
                    }
                    if (layoutingModeActive) {
                        this.layoutingModeSwitchingAction = new LayoutingModeSwitchingAction(page, editor, editorDiagram, this);
                        this.add((IAction)this.layoutingModeSwitchingAction);
                    }
                    if (editorDiagram != null && editorDiagram.isIsInLayoutingMode() && this.layoutingModeSwitchingAction != null) {
                        this.setDefaultAction("switchLayoutingMode");
                        this.layoutingModeSwitchingAction.setChecked(true);
                    } else if (editorDiagram != null && editorDiagram.isIsInShowingMode()) {
                        this.setDefaultAction("switchShowingMode");
                        this.visibilityModeSwitchingAction.setChecked(true);
                    } else {
                        this.setDefaultAction("defaultMode");
                        this.standardModeAction.setChecked(true);
                    }
                }
            }
        } else if (!this.isEmpty() && !visible) {
            this.remove("switchLayoutingMode");
            this.remove("switchShowingMode");
            this.remove("defaultMode");
            this.standardModeAction = null;
            this.layoutingModeSwitchingAction = null;
            this.visibilityModeSwitchingAction = null;
        }
    }

    private static class StandardModeMenuAction
    extends Action {
        StandardModeMenuAction() {
            this.setText(Messages.EditModeAction_Label);
            ImageDescriptor imageDesc = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/defaultMode.png");
            this.setImageDescriptor(imageDesc);
            this.setHoverImageDescriptor(imageDesc);
        }
    }
}

