/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.graphical.figures.OverlayLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientHelper;
import org.eclipse.sirius.ext.draw2d.figure.IRoundedCorner;
import org.eclipse.sirius.ext.draw2d.figure.ViewGradientFigureDesc;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.ViewNodeContainerFigureDesc;
import org.eclipse.swt.graphics.Color;

public class GradientRoundedRectangle
extends RoundedRectangle
implements ViewNodeContainerFigureDesc,
ViewGradientFigureDesc,
IRoundedCorner {
    private static final int GRADIENT_LEFT_TO_RIGHT_LITERAL = 0;
    protected SiriusWrapLabel fLabelFigure;
    protected View view;
    private Color gradientColor;
    private int backgroundStyle;
    private boolean useOverlayLabel;

    public GradientRoundedRectangle(Dimension dimension, int backgroundStyle, View view, boolean useOverlayLabel) {
        this.view = view;
        this.backgroundStyle = backgroundStyle;
        this.useOverlayLabel = useOverlayLabel;
        this.setCornerDimensions(new Dimension(MapModeUtil.getMapMode().DPtoLP(dimension.width), MapModeUtil.getMapMode().DPtoLP(dimension.height)));
        this.createBorder();
        this.createContents();
    }

    public GradientRoundedRectangle(Dimension dimension, int backgroundStyle, View view) {
        this(dimension, backgroundStyle, view, false);
    }

    public GradientRoundedRectangle(View view) {
        this(new Dimension(8, 8), 0, view);
    }

    public void paint(Graphics graphics) {
        if (this.view != null) {
            ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, this.view);
            try {
                super.paint(graphics);
                graphics.restoreState();
            }
            finally {
                graphics.popState();
            }
        } else {
            super.paint(graphics);
        }
    }

    public void setGradientColor(Color color) {
        this.gradientColor = color;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    protected void createContents() {
        this.fLabelFigure = this.useOverlayLabel ? new OverlayLabel(this.view) : new SiriusWrapLabel(){

            public void paint(Graphics graphics) {
                if (GradientRoundedRectangle.this.view != null) {
                    ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, GradientRoundedRectangle.this.view);
                    try {
                        super.paint(graphics);
                        graphics.restoreState();
                    }
                    finally {
                        graphics.popState();
                    }
                } else {
                    super.paint(graphics);
                }
            }
        };
        this.fLabelFigure.setText("  ");
        this.fLabelFigure.setTextWrap(true);
        this.add((IFigure)this.fLabelFigure);
    }

    protected void createBorder() {
        this.setBorder((Border)new MarginBorder(5, 0, 0, 0));
    }

    public SiriusWrapLabel getLabelFigure() {
        return this.fLabelFigure;
    }

    protected void fillShape(Graphics graphics) {
        if (this.getGradientColor() != null) {
            GradientHelper.setColorsGradation(graphics, this);
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        super.fillShape(graphics);
    }

    public int getBackgroundStyle() {
        return this.backgroundStyle;
    }

    public int getCornerHeight() {
        return this.getCornerDimensions().height;
    }

    public int getCornerWidth() {
        return this.getCornerDimensions().width;
    }
}

