/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.ExpandDTreeItemRunnableWithProgress;
import org.eclipse.sirius.ui.tools.internal.editor.ChangeExpandeStateRunnable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TreeItemExpansionManager
implements Listener {
    private Tree tree;
    private Session session;
    private IPermissionAuthority permissionAuthority;

    public TreeItemExpansionManager(Tree tree, Session session) {
        this.tree = tree;
        this.session = session;
        tree.addListener(17, (Listener)this);
        tree.addListener(18, (Listener)this);
        tree.addListener(12, (Listener)this);
        this.permissionAuthority = session.getModelAccessor().getPermissionAuthority();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 18: {
                this.handleTreeCollapse(event);
                break;
            }
            case 17: {
                this.handleTreeExpand(event);
                break;
            }
            case 12: {
                this.handleDispose();
                break;
            }
        }
    }

    private void handleTreeCollapse(Event event) {
        TreeItemExpansionManager.handleTreeCollapse(event, Optional.empty(), this.session, this.permissionAuthority);
    }

    public static void handleTreeCollapse(Event event, Optional<TreeItem> currentTreeItem, Session currentSession, IPermissionAuthority currentPermissionAuthority) {
        Object data;
        TreeItem treeItem = null;
        if (currentTreeItem.isPresent()) {
            treeItem = currentTreeItem.get();
        } else if (event.item instanceof TreeItem) {
            treeItem = (TreeItem)event.item;
        }
        if (treeItem != null && (data = treeItem.getData()) instanceof DTreeItem) {
            DTreeItem dTreeItem = (DTreeItem)data;
            if (TreeItemExpansionManager.isForDTreeItemExpandable(treeItem, currentPermissionAuthority)) {
                TreeItemExpansionManager.treeExpandingCollapsingAction(currentSession, treeItem, dTreeItem, false, Messages.TreeItemExpansionManager_treeCollapsing);
            } else {
                new ChangeExpandeStateRunnable(treeItem, true).run();
            }
        }
        if (!TreeItemExpansionManager.isForDTreeItemExpandable(treeItem, currentPermissionAuthority)) {
            event.type = 0;
            new ChangeExpandeStateRunnable(treeItem, true).run();
        }
    }

    private void handleTreeExpand(Event event) {
        TreeItemExpansionManager.handleTreeExpand(event, Optional.empty(), this.session, this.permissionAuthority);
    }

    public static void handleTreeExpand(Event event, Optional<TreeItem> currentTreeItem, Session currentSession, IPermissionAuthority currentPermissionAuthority) {
        Object data;
        TreeItem treeItem = null;
        if (currentTreeItem.isPresent()) {
            treeItem = currentTreeItem.get();
        } else if (event.item instanceof TreeItem) {
            treeItem = (TreeItem)event.item;
        }
        if (treeItem != null && (data = treeItem.getData()) instanceof DTreeItem) {
            DTreeItem dTreeItem = (DTreeItem)data;
            if (TreeItemExpansionManager.isForDTreeItemExpandable(treeItem, currentPermissionAuthority)) {
                TreeItemExpansionManager.treeExpandingCollapsingAction(currentSession, treeItem, dTreeItem, true, Messages.TreeItemExpansionManager_treeExpanding);
            } else {
                new ChangeExpandeStateRunnable(treeItem, false).run();
            }
        }
    }

    private static boolean isForDTreeItemExpandable(TreeItem treeItem, IPermissionAuthority currentPermissionAuthority) {
        Object data;
        boolean isForDTreeItemExpandable = true;
        if (treeItem != null && (data = treeItem.getData()) instanceof DTreeItem) {
            boolean canEditFeature;
            DTreeItem dTreeItem = (DTreeItem)data;
            isForDTreeItemExpandable = canEditFeature = currentPermissionAuthority != null && currentPermissionAuthority.canEditFeature((EObject)dTreeItem, TreePackage.Literals.DTREE_ITEM__EXPANDED.getName());
        }
        return isForDTreeItemExpandable;
    }

    private static void treeExpandingCollapsingAction(Session currentSession, TreeItem treeItem, DTreeItem dTreeItem, boolean expand, String errorMessage) {
        if (expand && !dTreeItem.isExpanded() || !expand && dTreeItem.isExpanded()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                ps.busyCursorWhile((IRunnableWithProgress)new ExpandDTreeItemRunnableWithProgress(currentSession, dTreeItem, expand));
            }
            catch (InvocationTargetException e) {
                TreeUIPlugin.INSTANCE.log(new Status(4, "org.eclipse.sirius.tree.ui", MessageFormat.format(Messages.TreeItemExpansionManager_expandOrCollaseError, errorMessage), (Throwable)e));
            }
            catch (InterruptedException interruptedException) {
                new ChangeExpandeStateRunnable(treeItem, !expand).run();
            }
        }
    }

    private void handleDispose() {
        if (this.tree != null) {
            this.tree.removeListener(12, (Listener)this);
            this.tree.removeListener(18, (Listener)this);
            this.tree.removeListener(17, (Listener)this);
        }
        this.tree = null;
        this.session = null;
        this.permissionAuthority = null;
    }
}

