/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gmf.runtime.draw2d.ui.figures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoutingAnimator;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ConnectionLayerEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.DelegatingLayout;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class SiriusPolylineConnectionEx
extends PolylineConnectionEx
implements IPolygonAnchorableFigure {
    public static boolean DISABLE_PARTIAL_JUMP_LINKS = false;
    private RotatableDecoration startDecoration;
    private RotatableDecoration endDecoration;
    private static Rectangle LINEBOUNDS = Rectangle.SINGLETON;
    private static int TOLERANCE = 3;
    private static Rectangle EMPTY_BOUNDS = new Rectangle(0, 0, 0, 0);
    public static final int SMOOTH_NONE = 0;
    public static final int SMOOTH_LESS = 16;
    public static final int SMOOTH_NORMAL = 32;
    public static final int SMOOTH_MORE = 64;
    public static final int JUMPLINK_FLAG_BELOW = 16384;
    public static final int JUMPLINK_FLAG_ABOVE = 32768;
    public static final int JUMPLINK_FLAG_ALL = 49152;
    private static final int SMOOTH_FACTOR_LESS = 15;
    private static final int SMOOTH_FACTOR_NORMAL = 30;
    private static final int SMOOTH_FACTOR_MORE = 50;
    private static final int ROUTE_AVOID_OBSTACLE = 256;
    private static final int ROUTE_CLOSEST_ROUTE = 512;
    private static final int ROUTE_JUMP_LINKS = 1024;
    private static final int JUMPLINK_FLAG_SMOOTH = 2048;
    private static final int JUMPLINK_FLAG_ANGLEIN = 4096;
    private static final int JUMPLINK_FLAG_ONBOTTOM = 8192;
    private static final int JUMPLINK_FLAG_HAS_TUNNEL_EFFECT = 65536;
    private static final int JUMPLINK_DEFAULT_SMOOTHNESS = 30;
    private int roundedBendpointsRadius = 0;
    private int origRoundedBendpointsRad = 0;
    private long siriusStyleBits = 22528L;
    private JumpLinkSet jumpLinkSet;
    private Hashtable connectionAnchors;
    private Hashtable<Integer, Integer> rForBendpointArc;
    private boolean isPartialJumpLinksDisabled = DISABLE_PARTIAL_JUMP_LINKS;
    private static final String szAnchor = "";
    private static final Dimension dimCheck = new Dimension(100, 100);
    private static final int JUMPLINK_DEFAULT_WIDTH = 25;
    private static final int JUMPLINK_DEFAULT_HEIGHT = 10;
    private static final int JUMPLINK_TUNNEL_DEFAULT_WIDTH = 10;
    private static final Cursor NO_COMMAND_SPECIAL_CURSOR = new Cursor((Device)Display.getDefault(), 0);

    private boolean isFeedbackLayer() {
        Dimension copied = dimCheck.getCopy();
        this.translateToRelative((Translatable)copied);
        return dimCheck.equals((Object)copied);
    }

    public SiriusPolylineConnectionEx() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.addRoutingListener((RoutingListener)RoutingAnimator.getDefault());
    }

    public void refreshLine() {
        this.dirtyJumpLinks();
        this.repaint();
    }

    public void addPoint(Point pt) {
        super.addPoint(pt);
        this.refreshLine();
    }

    private int calculateTolerance(boolean isFeedbackLayer) {
        Dimension absTol = new Dimension(TOLERANCE, 0);
        if (!isFeedbackLayer) {
            MapModeUtil.getMapMode((IFigure)this).DPtoLP((Translatable)absTol);
        }
        return absTol.width + this.lineWidth / 2;
    }

    public Rectangle getBounds() {
        return super.getBounds();
    }

    public Rectangle getSimpleBounds() {
        Point s = this.getStart();
        Point e = this.getEnd();
        Point start = new Point(Math.min(s.x, e.x), Math.min(s.y, e.y));
        Dimension d = new Dimension(Math.abs(s.x - e.x), Math.abs(s.y - e.y));
        return new Rectangle(start.x, start.y, d.width, d.height);
    }

    public boolean containsPoint(int x, int y) {
        boolean isFeedbackLayer = this.isFeedbackLayer();
        int calculatedTolerance = this.calculateTolerance(isFeedbackLayer);
        LINEBOUNDS.setBounds(this.getBounds());
        LINEBOUNDS.expand(calculatedTolerance, calculatedTolerance);
        if (!LINEBOUNDS.contains(x, y)) {
            return false;
        }
        int[] ints = this.getSmoothPoints().toIntArray();
        int index = 0;
        while (index < ints.length - 3) {
            if (this.lineContainsPoint(ints[index], ints[index + 1], ints[index + 2], ints[index + 3], x, y, isFeedbackLayer)) {
                return true;
            }
            index += 2;
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((IFigure)children.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean lineContainsPoint(int x1, int y1, int x2, int y2, int px, int py, boolean isFeedbackLayer) {
        LINEBOUNDS.setSize(0, 0);
        LINEBOUNDS.setLocation(x1, y1);
        LINEBOUNDS.union(x2, y2);
        int calculatedTolerance = this.calculateTolerance(isFeedbackLayer);
        LINEBOUNDS.expand(calculatedTolerance, calculatedTolerance);
        if (!LINEBOUNDS.contains(px, py)) {
            return false;
        }
        double result = 0.0;
        if (x1 != x2 && y1 != y2) {
            double v1x = (double)x2 - (double)x1;
            double v1y = (double)y2 - (double)y1;
            double v2x = (double)px - (double)x1;
            double v2y = (double)py - (double)y1;
            double numerator = v2x * v1y - v1x * v2y;
            double denominator = v1x * v1x + v1y * v1y;
            result = numerator * numerator / denominator;
        }
        return result <= (double)(calculatedTolerance * calculatedTolerance);
    }

    public int findLineSegIndexOfPoint(int x, int y) {
        this.calculateTolerance(this.isFeedbackLayer());
        return PointListUtilities.findNearestLineSegIndexOfPoint((PointList)this.getPoints(), (Point)new Point(x, y));
    }

    public PointList getSmoothPoints(boolean calculateAppox) {
        if (this.getSmoothFactor() > 0) {
            return PointListUtilities.calcSmoothPolyline((PointList)this.getPoints(), (int)this.getSmoothFactor(), (int)16);
        }
        if (this.isRoundingBendpoints()) {
            PointList result = this.getRoundedCornersPoints(calculateAppox);
            if (result == null) {
                this.origRoundedBendpointsRad = this.roundedBendpointsRadius;
                this.roundedBendpointsRadius = 0;
                result = PointListUtilities.copyPoints((PointList)this.getPoints());
            }
            return result;
        }
        return PointListUtilities.copyPoints((PointList)this.getPoints());
    }

    public PointList getSmoothPoints() {
        return this.getSmoothPoints(true);
    }

    public void insertPoint(Point pt, int index) {
        super.insertPoint(pt, index);
        this.refreshLine();
    }

    /*
     * WARNING - void declaration
     */
    protected void outlineShape(Graphics g) {
        PointList displayPointsWithoutJumpLinks = this.getSmoothPoints(false);
        List<List> displayPointsWithoutJumpLinksList = new ArrayList<PointList>();
        displayPointsWithoutJumpLinksList.add((List)displayPointsWithoutJumpLinks);
        Hashtable<Point, Integer> originalDisplayPoints = null;
        if (this.isRoundingBendpoints()) {
            void var6_7;
            originalDisplayPoints = new Hashtable<Point, Integer>();
            int index = 0;
            boolean bl = false;
            while (var6_7 < displayPointsWithoutJumpLinksList.size()) {
                int j = 0;
                while (j < ((PointList)displayPointsWithoutJumpLinksList.get((int)var6_7)).size()) {
                    originalDisplayPoints.put(((PointList)displayPointsWithoutJumpLinksList.get((int)var6_7)).getPoint(j), new Integer(index++));
                    ++j;
                }
                ++var6_7;
            }
        }
        int incline = this.calculateJumpLinkIncline(this.isFeedbackLayer(), this.hasSiriusTunnelAspect());
        if (this.shouldSiriusJumpLinks()) {
            this.regenerateJumpLinks();
            JumpLinkSet jumpLinkSet = this.getJumpLinkSet();
            if (jumpLinkSet != null && jumpLinkSet.m_pJumpLinks != null) {
                int nSmoothNess = 0;
                if (this.isSiriusJumpLinksSmooth()) {
                    nSmoothNess = 30;
                }
                boolean bOnBottom = this.isSiriusJumpLinksOnBottom();
                ListIterator linkIter = jumpLinkSet.m_pJumpLinks.listIterator();
                while (linkIter.hasNext()) {
                    List jumpLinkPoints;
                    JumpLink pJumpLink = (JumpLink)linkIter.next();
                    if (this.hasSiriusTunnelAspect()) {
                        jumpLinkPoints = PointListUtilities.routeAroundPoint((PointList)((PointList)displayPointsWithoutJumpLinksList.get(displayPointsWithoutJumpLinksList.size() - 1)), (Point)pJumpLink.m_ptIntersect, (int)pJumpLink.m_nWidth, (int)nSmoothNess);
                        if (jumpLinkPoints == null) continue;
                        if (displayPointsWithoutJumpLinksList.isEmpty()) {
                            displayPointsWithoutJumpLinksList = jumpLinkPoints;
                            continue;
                        }
                        displayPointsWithoutJumpLinksList.remove(displayPointsWithoutJumpLinksList.size() - 1);
                        displayPointsWithoutJumpLinksList.addAll(jumpLinkPoints);
                        continue;
                    }
                    jumpLinkPoints = PointListUtilities.routeAroundPoint((PointList)((PointList)displayPointsWithoutJumpLinksList.get(displayPointsWithoutJumpLinksList.size() - 1)), (Point)pJumpLink.m_ptIntersect, (int)pJumpLink.m_nHeight, (int)pJumpLink.m_nWidth, (int)nSmoothNess, (int)incline, (!bOnBottom ? 1 : 0) != 0);
                    if (jumpLinkPoints == null) continue;
                    displayPointsWithoutJumpLinksList.remove(displayPointsWithoutJumpLinksList.size() - 1);
                    displayPointsWithoutJumpLinksList.add(jumpLinkPoints);
                }
            }
        }
        if (!this.isRoundingBendpoints()) {
            for (PointList pointList : displayPointsWithoutJumpLinksList) {
                g.drawPolyline(pointList);
            }
            if (this.origRoundedBendpointsRad > 0) {
                this.roundedBendpointsRadius = this.origRoundedBendpointsRad;
                this.origRoundedBendpointsRad = 0;
            }
        } else {
            void var6_11;
            boolean bl = false;
            while (var6_11 < displayPointsWithoutJumpLinksList.size()) {
                PointList displayPoints = (PointList)displayPointsWithoutJumpLinksList.get((int)var6_11);
                int j = 1;
                int rDefault = this.getRoundedBendpointsRadius();
                while (j < displayPoints.size() - 1) {
                    int startAngle;
                    int y;
                    int x;
                    int x0 = 0;
                    int y0 = 0;
                    boolean firstPointAssigned = false;
                    if (this.shouldSiriusJumpLinks() && !this.hasSiriusTunnelAspect()) {
                        boolean containsPoint3;
                        boolean containsPoint2;
                        PointList jumpLinkPoints = new PointList();
                        do {
                            Point p;
                            int k;
                            containsPoint2 = true;
                            containsPoint3 = true;
                            if (j < displayPoints.size()) {
                                containsPoint2 = originalDisplayPoints.containsKey(displayPoints.getPoint(j));
                                if (j < displayPoints.size() - 1) {
                                    containsPoint3 = originalDisplayPoints.containsKey(displayPoints.getPoint(j + 1));
                                }
                            }
                            if (containsPoint2 && containsPoint3) continue;
                            jumpLinkPoints.addPoint(displayPoints.getPoint(j - 1));
                            if (!containsPoint2) {
                                k = j;
                                p = displayPoints.getPoint(j);
                            } else {
                                k = j + 1;
                                p = displayPoints.getPoint(j + 1);
                                jumpLinkPoints.addPoint(displayPoints.getPoint(j));
                            }
                            do {
                                jumpLinkPoints.addPoint(p);
                            } while (!originalDisplayPoints.containsKey(p = displayPoints.getPoint(++k)) && k < displayPoints.size() - 1);
                            int origIndex = (Integer)originalDisplayPoints.get(p);
                            firstPointAssigned = false;
                            if (origIndex % 2 == 0) {
                                jumpLinkPoints.addPoint(p);
                                j = k + 1;
                            } else {
                                x0 = jumpLinkPoints.getLastPoint().x;
                                y0 = jumpLinkPoints.getLastPoint().y;
                                j = k;
                                firstPointAssigned = true;
                            }
                            while (j < displayPoints.size() - 1 && displayPoints.getPoint(j).equals((Object)displayPoints.getPoint(j + 1))) {
                                ++j;
                            }
                        } while (!containsPoint2 || !containsPoint3);
                        if (jumpLinkPoints != null) {
                            g.drawPolyline(jumpLinkPoints);
                        }
                    }
                    if (j >= displayPoints.size() - 1) continue;
                    if (!firstPointAssigned) {
                        x0 = displayPoints.getPoint((int)(j - 1)).x;
                        y0 = displayPoints.getPoint((int)(j - 1)).y;
                    }
                    while (j < displayPoints.size() - 1 && x0 == displayPoints.getPoint((int)j).x && y0 == displayPoints.getPoint((int)j).y) {
                        ++j;
                    }
                    if (j >= displayPoints.size() - 1) break;
                    int x1 = displayPoints.getPoint((int)j).x;
                    int y1 = displayPoints.getPoint((int)j).y;
                    while (j + 1 < displayPoints.size() - 1 && x1 == displayPoints.getPoint((int)(j + 1)).x && y1 == displayPoints.getPoint((int)(j + 1)).y) {
                        ++j;
                    }
                    if (j >= displayPoints.size() - 1) break;
                    int x2 = displayPoints.getPoint((int)(j + 1)).x;
                    int y2 = displayPoints.getPoint((int)(j + 1)).y;
                    g.drawLine(x0, y0, x1, y1);
                    int r = rDefault;
                    Point p = displayPoints.getPoint(j);
                    int origIndex = (Integer)originalDisplayPoints.get(p);
                    Integer o = this.rForBendpointArc.get(new Integer((origIndex + 1) / 2));
                    if (o != null) {
                        r = o;
                    }
                    if (x0 == x1 && x1 < x2) {
                        x = x1;
                        y = y1 - r;
                        startAngle = y1 > y2 ? 90 : 180;
                    } else if (x0 > x1 && x1 > x2) {
                        x = x2;
                        y = y2 - r;
                        startAngle = y1 > y2 ? 180 : 90;
                    } else if (x0 == x1 && x1 > x2) {
                        if (y1 > y2) {
                            x = x2 - r;
                            y = y2;
                            startAngle = 0;
                        } else {
                            x = x1 - 2 * r;
                            y = y1 - r;
                            startAngle = 270;
                        }
                    } else if (y1 > y2) {
                        x = x2 - 2 * r;
                        y = y2 - r;
                        startAngle = 270;
                    } else {
                        x = x1 - r;
                        y = y1;
                        startAngle = 0;
                    }
                    g.drawArc(x, y, 2 * r, 2 * r, startAngle, 90);
                    j += 2;
                }
                ++var6_11;
                g.drawLine(displayPoints.getPoint(displayPoints.size() - 2), displayPoints.getLastPoint());
            }
        }
    }

    public void setLineWidth(int w) {
        this.bounds = null;
        super.setLineWidth(w);
    }

    public void setPoints(PointList points) {
        super.setPoints(points);
        this.dirtyAllJumpLinks();
        this.refreshLine();
    }

    private Dimension calculateJumpLinkSize(boolean isFeedbackLayer, boolean hasTunnelAspect) {
        Dimension jumpDim = hasTunnelAspect ? new Dimension(10, 0) : new Dimension(25, 10);
        if (!isFeedbackLayer) {
            MapModeUtil.getMapMode((IFigure)this).DPtoLP((Translatable)jumpDim);
        }
        return jumpDim;
    }

    private int calculateJumpLinkIncline(boolean isFeedbackLayer, boolean hasTunnelAspect) {
        if (this.isSiriusJumpLinksAngledIn()) {
            return this.calculateJumpLinkSize((boolean)isFeedbackLayer, (boolean)hasTunnelAspect).width / 5;
        }
        return 0;
    }

    public void dirtyAllJumpLinks() {
        IFigure pParent = this.getParent();
        if (pParent instanceof ConnectionLayerEx) {
            ((ConnectionLayerEx)pParent).dirtyJumpLinks(this.getBounds());
        }
    }

    private final int getSmoothFactor() {
        int smoothStyle = this.getSiriusSmoothness();
        if (smoothStyle == 16) {
            return 15;
        }
        if (smoothStyle == 32) {
            return 30;
        }
        if (smoothStyle == 64) {
            return 50;
        }
        return 0;
    }

    protected boolean hasCommonSourceOrEnd(Point point, PointList firstLine, PointList secondLine, int jumpLinkDelta) {
        boolean result = false;
        Point startPointOnFirstLine = new Point();
        Point startPointOnSecondLine = new Point();
        PointListUtilities.pointOn((PointList)firstLine, (Point)point, (long)jumpLinkDelta, (Point)startPointOnFirstLine);
        PointListUtilities.pointOn((PointList)secondLine, (Point)point, (long)jumpLinkDelta, (Point)startPointOnSecondLine);
        if (startPointOnFirstLine.getDistance(startPointOnSecondLine) <= 1.0) {
            result = true;
        } else {
            Point endPointOnFirstLine = new Point();
            Point endPointOnSecondLine = new Point();
            PointListUtilities.pointOn((PointList)firstLine, (Point)point, (long)(-jumpLinkDelta), (Point)endPointOnFirstLine);
            PointListUtilities.pointOn((PointList)secondLine, (Point)point, (long)(-jumpLinkDelta), (Point)endPointOnSecondLine);
            if (endPointOnFirstLine.getDistance(endPointOnSecondLine) <= 1.0 || endPointOnFirstLine.getDistance(startPointOnSecondLine) <= 1.0 || startPointOnFirstLine.getDistance(endPointOnSecondLine) <= 1.0) {
                result = true;
            }
        }
        return result;
    }

    public final void setSiriusSmoothness(int smooth) {
        this.siriusStyleBits &= 0xFFFFFFFFFFFFFF8FL;
        if (smooth == 16 || smooth == 32 || smooth == 64) {
            this.siriusStyleBits |= (long)smooth;
        }
    }

    public final int getSiriusSmoothness() {
        if ((this.siriusStyleBits & 0x10L) != 0L) {
            return 16;
        }
        if ((this.siriusStyleBits & 0x20L) != 0L) {
            return 32;
        }
        if ((this.siriusStyleBits & 0x40L) != 0L) {
            return 64;
        }
        return 0;
    }

    public final boolean isSiriusClosestDistanceRouting() {
        return (this.siriusStyleBits & 0x200L) != 0L;
    }

    public final boolean isSiriusAvoidObstacleRouting() {
        return (this.siriusStyleBits & 0x100L) != 0L;
    }

    public final boolean hasSiriusTunnelAspect() {
        return (this.siriusStyleBits & 0x10000L) != 0L;
    }

    public void setRoutingStyles(boolean closestDistance, boolean avoidObstacles) {
        super.setRoutingStyles(closestDistance, avoidObstacles);
        this.siriusStyleBits = closestDistance ? (this.siriusStyleBits |= 0x200L) : (this.siriusStyleBits &= 0xFFFFFFFFFFFFFDFFL);
        if (avoidObstacles) {
            if (!closestDistance) {
                this.siriusStyleBits |= 0x200L;
            }
            this.siriusStyleBits |= 0x100L;
        } else {
            this.siriusStyleBits &= 0xFFFFFFFFFFFFFEFFL;
        }
    }

    public boolean isRoundingBendpoints() {
        if (this.roundedBendpointsRadius > 0 && this.getSmoothFactor() == 0) {
            return this.getConnectionRouter() instanceof OrthogonalRouter;
        }
        return false;
    }

    public void setRoundedBendpointsRadius(int radius) {
        this.roundedBendpointsRadius = radius;
        if (this.origRoundedBendpointsRad > 0) {
            this.origRoundedBendpointsRad = radius;
        }
    }

    public int getRoundedBendpointsRadius() {
        return MapModeUtil.getMapMode((IFigure)this).DPtoLP(this.roundedBendpointsRadius);
    }

    public final boolean shouldSiriusJumpLinks() {
        if ((this.siriusStyleBits & 0x400L) != 0L) {
            IFigure pParent = this.getParent();
            if (pParent instanceof ConnectionLayerEx) {
                return ConnectionLayerEx.shouldJumpLinks();
            }
            return true;
        }
        return false;
    }

    public void setJumpLinks(boolean on) {
        super.setJumpLinks(on);
        this.siriusStyleBits = on ? (this.siriusStyleBits |= 0x400L) : (this.siriusStyleBits &= 0xFFFFFFFFFFFFFBFFL);
    }

    public boolean isPartialJumpLinksDisabled() {
        return this.isPartialJumpLinksDisabled;
    }

    public void disablePartialJumpLinks(boolean disablePartialJumpLinks) {
        this.isPartialJumpLinksDisabled = disablePartialJumpLinks;
    }

    public void setJumpLinksStyles(int jumpType, boolean curved, boolean angleIn, boolean onBottom) {
        this.setJumpLinksStyles(jumpType, curved, angleIn, onBottom, false);
    }

    public void setJumpLinksStyles(int jumpType, boolean curved, boolean angleIn, boolean onBottom, boolean hasTunnelAspect) {
        super.setJumpLinksStyles(jumpType, curved, angleIn, onBottom, hasTunnelAspect);
        this.siriusStyleBits &= 0xFFFFFFFFFFFF3FFFL;
        this.siriusStyleBits |= (long)jumpType;
        this.siriusStyleBits = curved ? (this.siriusStyleBits |= 0x800L) : (this.siriusStyleBits &= 0xFFFFFFFFFFFFF7FFL);
        this.siriusStyleBits = angleIn ? (this.siriusStyleBits |= 0x1000L) : (this.siriusStyleBits &= 0xFFFFFFFFFFFFEFFFL);
        this.siriusStyleBits = onBottom ? (this.siriusStyleBits |= 0x2000L) : (this.siriusStyleBits &= 0xFFFFFFFFFFFFDFFFL);
        this.siriusStyleBits = hasTunnelAspect ? (this.siriusStyleBits |= 0x10000L) : (this.siriusStyleBits &= 0xFFFFFFFFFFFEFFFFL);
        this.dirtyJumpLinks();
    }

    public final boolean isSiriusJumpLinksSmooth() {
        return (this.siriusStyleBits & 0x800L) != 0L;
    }

    public final boolean isSiriusJumpLinksAngledIn() {
        return (this.siriusStyleBits & 0x1000L) != 0L;
    }

    public final boolean isSiriusJumpLinksOnBottom() {
        return (this.siriusStyleBits & 0x2000L) != 0L;
    }

    void dirtyJumpLinks() {
        JumpLinkSet pJumpLinkSet = this.getJumpLinkSet();
        if (pJumpLinkSet != null) {
            pJumpLinkSet.dirtyJumpLinks();
        }
    }

    private boolean regenerateJumpLinks() {
        JumpLinkSet pJumpLinkSet = this.getJumpLinkSet();
        if (pJumpLinkSet != null) {
            return pJumpLinkSet.regenerateJumpLinks((Connection)this);
        }
        return false;
    }

    private JumpLinkSet getJumpLinkSet() {
        if (this.shouldJumpLinks()) {
            if (this.jumpLinkSet == null) {
                this.jumpLinkSet = new JumpLinkSet();
            }
        } else {
            this.jumpLinkSet = null;
        }
        return this.jumpLinkSet;
    }

    public PointList getPolygonPoints() {
        return this.getSmoothPoints();
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        ConnectionAnchor connectAnchor = (ConnectionAnchor)this.getConnectionAnchors().get(terminal);
        if (connectAnchor == null) {
            if (terminal.equals(szAnchor)) {
                connectAnchor = this.createDefaultAnchor();
                this.getConnectionAnchors().put(terminal, connectAnchor);
            } else {
                connectAnchor = this.createAnchor(BaseSlidableAnchor.parseTerminalString((String)terminal));
            }
        }
        return connectAnchor;
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        if (c instanceof BaseSlidableAnchor) {
            return ((BaseSlidableAnchor)c).getTerminal();
        }
        if (this.getConnectionAnchors().containsValue(c)) {
            for (String key : this.getConnectionAnchors().keySet()) {
                if (!this.getConnectionAnchors().get(key).equals(c)) continue;
                return key;
            }
        }
        this.getConnectionAnchor(szAnchor);
        return szAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        return new BaseSlidableAnchor((IFigure)this);
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (p == null) {
            return this.createDefaultAnchor();
        }
        return new BaseSlidableAnchor((IFigure)this, p);
    }

    protected ConnectionAnchor createConnectionAnchor(Point p) {
        if (p == null) {
            return this.getConnectionAnchor(szAnchor);
        }
        Point temp = p.getCopy();
        this.translateToRelative((Translatable)temp);
        PrecisionPoint pt = BaseSlidableAnchor.getAnchorRelativeLocation((Point)temp, (Rectangle)this.getBounds());
        return this.createAnchor(pt);
    }

    protected boolean isDefaultAnchorArea(PrecisionPoint p) {
        return p.preciseX >= this.getSlidableAnchorArea() / 2.0 && p.preciseX <= 1.0 - this.getSlidableAnchorArea() / 2.0 && p.preciseY >= this.getSlidableAnchorArea() / 2.0 && p.preciseY <= 1.0 - this.getSlidableAnchorArea() / 2.0;
    }

    protected Hashtable getConnectionAnchors() {
        if (this.connectionAnchors == null) {
            this.connectionAnchors = new Hashtable(1);
        }
        return this.connectionAnchors;
    }

    protected double getSlidableAnchorArea() {
        return 0.25;
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (this.getTargetDecoration() != null) {
            this.getTargetDecoration().setForegroundColor(fg);
        }
        if (this.getSourceDecoration() != null) {
            this.getSourceDecoration().setForegroundColor(fg);
        }
    }

    public void setSourceDecoration(RotatableDecoration dec, ConnectionLocator locator) {
        if (this.getSourceDecoration() != null) {
            this.remove((IFigure)this.getSourceDecoration());
        }
        this.startDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, locator);
        }
    }

    public void setTargetDecoration(RotatableDecoration dec, ConnectionLocator locator) {
        if (this.getTargetDecoration() != null) {
            this.remove((IFigure)this.getTargetDecoration());
        }
        this.endDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, locator);
        }
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endDecoration;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startDecoration;
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.getTargetDecoration() != null) {
            this.remove((IFigure)this.getTargetDecoration());
        }
        this.endDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator((Connection)this, 3));
        }
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.getSourceDecoration() != null) {
            this.remove((IFigure)this.getSourceDecoration());
        }
        this.startDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator((Connection)this, 2));
        }
    }

    public void setLineDash(int[] dashes) {
        float[] floatDashes = new float[dashes.length];
        int i = 0;
        while (i < dashes.length) {
            floatDashes[i] = dashes[i];
            ++i;
        }
        this.setLineDash(floatDashes);
    }

    public Cursor getCursor() {
        if (this.isSiriusAvoidObstacleRouting()) {
            return NO_COMMAND_SPECIAL_CURSOR;
        }
        return super.getCursor();
    }

    public PointList getRoundedCornersPoints(boolean calculateAppoxPoints) {
        if (this.rForBendpointArc != null) {
            this.rForBendpointArc.clear();
        } else {
            this.rForBendpointArc = new Hashtable();
        }
        return PointListUtilities.calcRoundedCornersPolyline((PointList)this.getPoints(), (int)this.getRoundedBendpointsRadius(), this.rForBendpointArc, (boolean)calculateAppoxPoints);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible && this.getParent() instanceof ConnectionLayerEx) {
            ((ConnectionLayerEx)this.getParent()).dirtyJumpLinks(this.getBounds());
        }
    }

    protected class JumpLink {
        public Point m_ptIntersect;
        public int m_nWidth;
        public int m_nHeight;
        public int m_nDistance;

        protected JumpLink() {
        }
    }

    protected class JumpLinkSet {
        private boolean m_bDirty = true;
        private List m_pJumpLinks = null;

        public boolean isDirty() {
            return this.m_bDirty;
        }

        protected void cleanJumpLinks(Connection connect) {
            this.m_bDirty = false;
            IFigure pParent = connect.getParent();
            if (pParent instanceof ConnectionLayerEx) {
                ((ConnectionLayerEx)pParent).cleanJumpLinks();
            }
        }

        public void dirtyJumpLinks() {
            this.m_bDirty = true;
        }

        public boolean regenerateJumpLinks(Connection connect) {
            if (this.isDirty()) {
                this.calculateIntersections(connect);
                this.cleanJumpLinks(connect);
                return true;
            }
            return false;
        }

        private void sortByDistance() {
            Object[] jumpArray = this.m_pJumpLinks.toArray();
            Arrays.sort(jumpArray, new CompareDistance());
            int i = 0;
            while (i < this.m_pJumpLinks.size()) {
                this.m_pJumpLinks.set(i, jumpArray[i]);
                ++i;
            }
        }

        private void calculateIntersections(Connection connect) {
            IFigure pParent = connect.getParent();
            if (this.m_pJumpLinks != null) {
                this.m_pJumpLinks = null;
            }
            PointList tmpLine = SiriusPolylineConnectionEx.this.getSmoothPoints();
            long jumpType = SiriusPolylineConnectionEx.this.siriusStyleBits & 0xC000L;
            List children = pParent.getChildren();
            int nIndex = children.indexOf(connect);
            ListIterator childIter = children.listIterator();
            boolean bForwards = true;
            if (jumpType != 49152L) {
                childIter = children.listIterator(nIndex);
                if (jumpType == 16384L) {
                    bForwards = false;
                }
            }
            boolean isFeedbackLayer = SiriusPolylineConnectionEx.this.isFeedbackLayer();
            Dimension jumpLinkSize = SiriusPolylineConnectionEx.this.calculateJumpLinkSize(isFeedbackLayer, SiriusPolylineConnectionEx.this.hasSiriusTunnelAspect());
            while (!(bForwards ? !childIter.hasNext() : !childIter.hasPrevious())) {
                IFigure figure = (IFigure)(bForwards ? childIter.next() : childIter.previous());
                PointList checkLine = null;
                if (figure == connect || !figure.isVisible()) continue;
                if (figure instanceof SiriusPolylineConnectionEx) {
                    checkLine = ((SiriusPolylineConnectionEx)figure).getSmoothPoints();
                } else if (figure instanceof Connection) {
                    checkLine = PointListUtilities.copyPoints((PointList)((Connection)figure).getPoints());
                }
                if (checkLine == null) continue;
                PointList intersections = new PointList();
                PointList distances = new PointList();
                if (this.m_pJumpLinks == null) {
                    this.m_pJumpLinks = new ArrayList(intersections.size());
                }
                if (!PointListUtilities.findIntersections((PointList)tmpLine, (PointList)checkLine, (PointList)intersections, (PointList)distances)) continue;
                int i = 0;
                while (i < intersections.size()) {
                    double dist1 = intersections.getPoint(i).getDistance(tmpLine.getFirstPoint());
                    double dist2 = intersections.getPoint(i).getDistance(tmpLine.getLastPoint());
                    double dist3 = intersections.getPoint(i).getDistance(checkLine.getFirstPoint());
                    double dist4 = intersections.getPoint(i).getDistance(checkLine.getLastPoint());
                    double minDist = Math.min(Math.min(dist1, dist2), Math.min(dist3, dist4));
                    if (!(!(minDist > (double)(jumpLinkSize.width / 2)) || SiriusPolylineConnectionEx.this.isPartialJumpLinksDisabled() && SiriusPolylineConnectionEx.this.hasCommonSourceOrEnd(intersections.getPoint(i), tmpLine, checkLine, jumpLinkSize.width / 2))) {
                        this.addJumpLink(intersections.getPoint(i), distances.getPoint((int)i).x, isFeedbackLayer, SiriusPolylineConnectionEx.this.hasSiriusTunnelAspect());
                    }
                    ++i;
                }
            }
            this.combineCloseLinks(tmpLine);
        }

        private void addJumpLink(Point ptIntersect, int nDistance, boolean isFeedbackLayer, boolean hasTunnelAspect) {
            JumpLink pNewJumpLink = new JumpLink();
            pNewJumpLink.m_ptIntersect = new Point(ptIntersect);
            Dimension jumpLinkSize = SiriusPolylineConnectionEx.this.calculateJumpLinkSize(isFeedbackLayer, hasTunnelAspect);
            pNewJumpLink.m_nWidth = jumpLinkSize.width;
            pNewJumpLink.m_nHeight = jumpLinkSize.height;
            pNewJumpLink.m_nDistance = nDistance;
            this.m_pJumpLinks.add(pNewJumpLink);
        }

        private void combineCloseLinks(PointList tmpLine) {
            if (this.m_pJumpLinks == null || this.m_pJumpLinks.size() < 2) {
                return;
            }
            Dimension jumpLinkSize = SiriusPolylineConnectionEx.this.calculateJumpLinkSize(SiriusPolylineConnectionEx.this.isFeedbackLayer(), SiriusPolylineConnectionEx.this.hasSiriusTunnelAspect());
            int nCurrentWidth = jumpLinkSize.width;
            ArrayList jumpLinks = new ArrayList(this.m_pJumpLinks.size());
            this.sortByDistance();
            jumpLinks.addAll(this.m_pJumpLinks);
            this.m_pJumpLinks.clear();
            ListIterator linkIter = jumpLinks.listIterator();
            JumpLink pLastJumpLink = (JumpLink)linkIter.next();
            JumpLink pPrevJumpLink = null;
            int nDeltaMin = jumpLinkSize.width * 4 / 3;
            while (pLastJumpLink != null) {
                JumpLink pJumpLink = null;
                int nDelta = 0;
                if (linkIter.hasNext()) {
                    pJumpLink = (JumpLink)linkIter.next();
                    nDelta = pJumpLink.m_nDistance - pLastJumpLink.m_nDistance;
                }
                if (nDelta > nDeltaMin || pJumpLink == null) {
                    JumpLink pNewJumpLink = new JumpLink();
                    pNewJumpLink.m_nHeight = jumpLinkSize.height;
                    pNewJumpLink.m_nWidth = nCurrentWidth;
                    pNewJumpLink.m_nDistance = 0;
                    pNewJumpLink.m_ptIntersect = new Point(pLastJumpLink.m_ptIntersect);
                    if (pPrevJumpLink != null) {
                        long nNewDistance = pPrevJumpLink.m_nDistance + (pLastJumpLink.m_nDistance - pPrevJumpLink.m_nDistance) / 2;
                        pNewJumpLink.m_ptIntersect = new Point();
                        PointListUtilities.pointOn((PointList)tmpLine, (long)nNewDistance, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)pNewJumpLink.m_ptIntersect);
                    }
                    this.m_pJumpLinks.add(pNewJumpLink);
                    nCurrentWidth = jumpLinkSize.width;
                    pPrevJumpLink = null;
                } else {
                    if (pPrevJumpLink == null) {
                        pPrevJumpLink = pLastJumpLink;
                    }
                    nCurrentWidth += nDelta;
                }
                pLastJumpLink = pJumpLink;
            }
        }

        private class CompareDistance
        implements Comparator {
            private CompareDistance() {
            }

            public int compare(Object obj1, Object obj2) {
                JumpLink j1 = (JumpLink)obj1;
                JumpLink j2 = (JumpLink)obj2;
                if (j1.m_nDistance < j2.m_nDistance) {
                    return -1;
                }
                if (j1.m_nDistance > j2.m_nDistance) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

