/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.overlaps;

import java.util.List;
import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.intermediate.compaction.AbstractRadiusExtensionCompaction;
import org.eclipse.elk.alg.radial.intermediate.overlaps.IOverlapRemoval;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.alg.radial.options.SortingStrategy;
import org.eclipse.elk.alg.radial.sorting.IRadialSorter;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class RadiusExtensionOverlapRemoval
extends AbstractRadiusExtensionCompaction
implements ILayoutProcessor<ElkNode>,
IOverlapRemoval {
    private IRadialSorter sorter;

    @Override
    public void removeOverlaps(ElkNode graph) {
        ElkNode root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
        this.setRoot(root);
        this.sorter = ((SortingStrategy)((Object)graph.getProperty(RadialOptions.SORTER))).create();
        Double spacing = (Double)graph.getProperty(CoreOptions.SPACING_NODE_NODE);
        this.setSpacing(spacing);
        List<ElkNode> successors = RadialUtil.getSuccessors(root);
        this.extend(successors);
    }

    public void extend(List<ElkNode> nodes) {
        if (!nodes.isEmpty()) {
            while (this.overlapLayer(nodes)) {
                this.contractLayer(nodes, false);
            }
            List<ElkNode> nextLevelNodes = RadialUtil.getNextLevelNodes(nodes);
            if (this.sorter != null) {
                this.sorter.sort(nextLevelNodes);
                this.extend(nextLevelNodes);
            }
        }
    }

    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        this.removeOverlaps(graph);
    }
}

