/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.actions.export;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.api.util.FileUtil;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.tools.api.actions.export.IAfterExport;
import org.eclipse.sirius.ui.tools.api.actions.export.IAroundExport;
import org.eclipse.sirius.ui.tools.api.actions.export.IBeforeExport;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExportAction
extends WorkspaceModifyOperation {
    public static final String EXPORT_DIAGRAMS_AS_IMAGES_ACTION_TITLE = Messages.ExportAction_exportDiagramsAsImagesTitle;
    private static final String CR = "\n";
    private static final char POINT = '.';
    private Session session;
    private Collection<DRepresentation> dRepresentationsToExportAsImage;
    private IPath outputPath;
    private ImageFileFormat imageFormat;
    private boolean exportToHtml;
    private boolean exportDecorations;
    private boolean autoScaleDiagram;
    private Integer diagramScaleLevel;

    public ExportAction(Session session, Collection<DRepresentation> dRepresentationsToExportAsImage, IPath outputPath, ImageFileFormat imageFormat, boolean exportToHtml, boolean exportDecorations) {
        this.session = session;
        this.dRepresentationsToExportAsImage = dRepresentationsToExportAsImage;
        this.outputPath = outputPath;
        this.imageFormat = imageFormat;
        this.exportToHtml = exportToHtml;
        this.exportDecorations = exportDecorations;
    }

    @Deprecated
    public void setAutoScaleDiagram(boolean autoScaleDiagram) {
        this.autoScaleDiagram = autoScaleDiagram;
    }

    public void setDiagramScaleLevel(Integer theDiagramScaleLevel) {
        if (theDiagramScaleLevel == null || theDiagramScaleLevel < 0 || theDiagramScaleLevel > 100) {
            throw new IllegalArgumentException(Messages.ExportAction_invalidLevel);
        }
        this.diagramScaleLevel = theDiagramScaleLevel;
        this.autoScaleDiagram = this.diagramScaleLevel != 0;
    }

    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(EXPORT_DIAGRAMS_AS_IMAGES_ACTION_TITLE, this.dRepresentationsToExportAsImage.size());
            try {
                this.createImageFiles(monitor);
            }
            catch (OutOfMemoryError | CoreException e) {
                throw new InvocationTargetException(e, e.getLocalizedMessage());
            }
        }
        finally {
            monitor.done();
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.ExportAction_exportDiagramsAsImagesCancelled);
            }
        }
    }

    protected void createImageFiles(IProgressMonitor monitor) throws CoreException {
        List beforeContributors = EclipseUtil.getExtensionPlugins(IBeforeExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
        List aroundContributors = EclipseUtil.getExtensionPlugins(IAroundExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
        List afterContributors = EclipseUtil.getExtensionPlugins(IAfterExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
        ExportFormat.ScalingPolicy scalingPolicy = this.autoScaleDiagram ? ExportFormat.ScalingPolicy.AUTO_SCALING : ExportFormat.ScalingPolicy.NO_SCALING;
        ExportFormat exportFormat = new ExportFormat(this.exportToHtml ? ExportFormat.ExportDocumentFormat.HTML : ExportFormat.ExportDocumentFormat.NONE, this.imageFormat, scalingPolicy, this.diagramScaleLevel);
        String imageFileExtension = exportFormat.getImageFormat().getName().toLowerCase();
        boolean traceability = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.ui", SiriusUIPreferencesKeys.PREF_EXPORT_SEMANTIC_TRACEABILITY.name(), false, null);
        exportFormat.setSemanticTraceabilityEnabled(traceability);
        for (IBeforeExport iBeforeExport : beforeContributors) {
            iBeforeExport.beforeExportAction(this.dRepresentationsToExportAsImage, this.outputPath, imageFileExtension);
        }
        if (!aroundContributors.isEmpty()) {
            for (IAroundExport iAroundExport : aroundContributors) {
                iAroundExport.aroundExportAction(this.dRepresentationsToExportAsImage, this.outputPath, imageFileExtension);
            }
        } else {
            ArrayList<DRepresentation> representationWithSizeTooLargeException = new ArrayList<DRepresentation>();
            ArrayList<DRepresentation> representationWithOtherException = new ArrayList<DRepresentation>();
            ArrayList<DRepresentation> representationWithImageFileCreationError = new ArrayList<DRepresentation>();
            try {
                for (DRepresentation representation : this.dRepresentationsToExportAsImage) {
                    IPath filePath;
                    String representationName = representation.getName();
                    if (this.outputPath.toFile().isDirectory()) {
                        filePath = this.getFilePath(this.outputPath, representationName, imageFileExtension);
                    } else if (this.outputPath.getFileExtension() != null) {
                        String imageFileExtensionLowerCase = this.outputPath.getFileExtension().toLowerCase();
                        filePath = this.outputPath.removeFileExtension().addFileExtension(imageFileExtensionLowerCase);
                    } else {
                        filePath = this.outputPath;
                    }
                    for (Object contributor : beforeContributors) {
                        contributor.beforeExportRepresentationAsImage((EObject)representation, filePath);
                    }
                    if (DialectUIManager.INSTANCE.canHandle(representation)) {
                        try {
                            monitor.subTask("Export as image: " + representationName);
                            DialectUIManager.INSTANCE.export(representation, this.session, filePath, exportFormat, monitor, this.exportDecorations);
                            monitor.worked(1);
                        }
                        catch (CoreException exception) {
                            if (exception instanceof SizeTooLargeException) {
                                representationWithSizeTooLargeException.add(representation);
                            }
                        }
                        catch (WrappedException exception) {
                            if (exception.getCause() instanceof FileNotFoundException) {
                                representationWithImageFileCreationError.add(representation);
                            }
                            representationWithOtherException.add(representation);
                        }
                    }
                    for (Object contributor : afterContributors) {
                        contributor.afterExportRepresentationAsImage((EObject)representation, filePath);
                    }
                }
            }
            finally {
                if (!(representationWithSizeTooLargeException.isEmpty() && representationWithOtherException.isEmpty() && representationWithImageFileCreationError.isEmpty())) {
                    this.handleErrors(representationWithSizeTooLargeException, representationWithOtherException, representationWithImageFileCreationError);
                }
            }
        }
        for (IAfterExport iAfterExport : afterContributors) {
            iAfterExport.afterExportAction();
        }
    }

    private void handleErrors(List<DRepresentation> representationWithSizeTooLargeException, List<DRepresentation> representationWithOtherException, List<DRepresentation> representationWithImageFileCreationError) throws CoreException {
        StringBuffer messageExceptionForDialog = new StringBuffer();
        messageExceptionForDialog.append(Messages.ExportAction_exportErrorReport);
        if (!representationWithSizeTooLargeException.isEmpty()) {
            messageExceptionForDialog.append(CR);
            messageExceptionForDialog.append(Messages.ExportAction_imagesTooLargeMessage);
        }
        for (DRepresentation rep : representationWithSizeTooLargeException) {
            this.addRepresentationInformation(messageExceptionForDialog, rep);
        }
        if (!representationWithOtherException.isEmpty()) {
            messageExceptionForDialog.append(CR);
            messageExceptionForDialog.append(Messages.ExportAction_exportOtherError);
        }
        for (DRepresentation rep : representationWithOtherException) {
            this.addRepresentationInformation(messageExceptionForDialog, rep);
        }
        if (!representationWithImageFileCreationError.isEmpty()) {
            messageExceptionForDialog.append(CR);
            messageExceptionForDialog.append(Messages.ExportAction_exportedDiagramImageCreationError);
        }
        for (DRepresentation rep : representationWithImageFileCreationError) {
            this.addRepresentationInformation(messageExceptionForDialog, rep);
        }
        Status status = new Status(4, "org.eclipse.sirius", messageExceptionForDialog.toString());
        SiriusEditPlugin.getPlugin().getLog().log((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    private void addRepresentationInformation(StringBuffer messageExceptionForDialog, DRepresentation rep) {
        messageExceptionForDialog.append(CR);
        messageExceptionForDialog.append(" - ");
        Object description = ReflectionHelper.invokeMethodWithoutExceptionWithReturn((Object)rep, (String)"getDescription", (Class[])new Class[0], (Object[])new Object[0]);
        String descriptionName = null;
        if (description instanceof RepresentationDescription) {
            descriptionName = ((RepresentationDescription)description).getName();
        }
        String semanticTargetName = null;
        if (rep instanceof DSemanticDecorator) {
            semanticTargetName = new EditingDomainServices().getLabelProviderText(((DSemanticDecorator)rep).getTarget());
        }
        messageExceptionForDialog.append(MessageFormat.format(Messages.ExportAction_representationInformation, rep.getName(), descriptionName, semanticTargetName));
    }

    private IPath getFilePath(IPath destinationFolder, String providedFilename, String extension) {
        IPath filePath;
        String filename = null;
        filename = providedFilename.length() == 0 ? Messages.ExportAction_defaultDiagramName : providedFilename;
        StringBuffer file = new StringBuffer(filename).append('.').append(extension);
        String filenameWithExtension = this.validFilename(file.toString());
        if (destinationFolder.append(filenameWithExtension).toFile().exists()) {
            int version = 1;
            do {
                String newFileName = this.validFilename(new StringBuffer(filename).append('_').append(String.valueOf(version)).append('.').append(extension).toString());
                filePath = destinationFolder.append(newFileName);
                ++version;
            } while (filePath.toFile().exists());
        } else {
            filePath = destinationFolder.append(filenameWithExtension);
        }
        return filePath;
    }

    private String validFilename(String filename) {
        FileUtil util = new FileUtil(filename);
        if (util.isValid()) {
            return filename;
        }
        return util.getValidFilename();
    }
}

