/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.compaction;

import java.util.List;
import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.intermediate.compaction.AbstractRadiusExtensionCompaction;
import org.eclipse.elk.alg.radial.intermediate.compaction.IRadialCompactor;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.alg.radial.options.SortingStrategy;
import org.eclipse.elk.alg.radial.sorting.IRadialSorter;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkNode;

public class RadialCompaction
extends AbstractRadiusExtensionCompaction
implements IRadialCompactor {
    private IRadialSorter sorter;
    private double lastRadius = 0.0;

    @Override
    public void compact(ElkNode graph) {
        ElkNode root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
        this.setRoot(root);
        this.sorter = ((SortingStrategy)((Object)graph.getProperty(RadialOptions.SORTER))).create();
        Integer stepSize = (Integer)graph.getProperty(RadialOptions.COMPACTION_STEP_SIZE);
        if (stepSize != null) {
            this.setCompactionStep(stepSize);
        }
        Double spacing = (Double)graph.getProperty(CoreOptions.SPACING_NODE_NODE);
        this.setSpacing(spacing);
        List<ElkNode> firstLevelNodes = RadialUtil.getSuccessors(root);
        if (this.sorter != null) {
            this.sorter.sort(firstLevelNodes);
        }
        this.contract(firstLevelNodes);
    }

    public void contract(List<ElkNode> nodes) {
        if (!nodes.isEmpty()) {
            boolean isOverlapping = this.overlapping(nodes);
            boolean wasContracted = false;
            while (!isOverlapping) {
                this.contractLayer(nodes, true);
                wasContracted = true;
                isOverlapping = this.overlapping(nodes);
            }
            if (wasContracted) {
                this.contractLayer(nodes, false);
            }
            List<ElkNode> nextLevelNodes = RadialUtil.getNextLevelNodes(nodes);
            if (this.sorter != null) {
                this.sorter.sort(nextLevelNodes);
            }
            this.lastRadius = this.calculateRadius(nodes.get(0));
            this.contract(nextLevelNodes);
        }
    }

    private double calculateRadius(ElkNode node) {
        double xPos = node.getX();
        double yPos = node.getY();
        ElkNode root = this.getRoot();
        double rootX = root.getX();
        double rootY = root.getY();
        double vectorX = xPos - rootX;
        double vectorY = yPos - rootY;
        double radius = Math.sqrt(vectorX * vectorX + vectorY * vectorY);
        return radius;
    }

    private boolean overlapping(List<ElkNode> nodes) {
        if (this.overlapLayer(nodes)) {
            return true;
        }
        for (ElkNode node : nodes) {
            ElkNode parent;
            if (this.overlap(node, parent = RadialUtil.getTreeParent(node))) {
                return true;
            }
            if (!(this.calculateRadius(node) - this.getSpacing() <= this.lastRadius)) continue;
            return true;
        }
        return false;
    }
}

