/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;

public final class FileEObjectsField {
    private static final String EOBJECTS = "eObjects";
    private static final int EOBJECTS_COMPLEXITY = 1;

    private FileEObjectsField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(EOBJECTS).type((GraphQLOutputType)new GraphQLTypeReference("FileEObjectConnection")).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(FileEObjectsField.getEObjectsDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getEObjectsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> {
            Optional<IFile> optionalFile = Optional.of(environment.getSource()).filter(IFile.class::isInstance).map(IFile.class::cast);
            Optional optionalSession = optionalFile.map(IResource::getProject).flatMap(SiriusServicesCommonOptionalUtils::toSession);
            Optional<EList> optionalResource = optionalFile.flatMap(iFile -> optionalSession.flatMap(session -> SiriusServicesCommonOptionalUtils.toResource((Session)session, (IFile)iFile)));
            return (List)optionalResource.map(Resource::getContents).orElseGet(BasicEList::new);
        }, FileEObjectsField::computeEObjectCursor);
    }

    private static String computeEObjectCursor(EObject eObject) {
        String unEncodedCursor = EcoreUtil.getURI((EObject)eObject).toString();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }
}

