/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.migration;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.tests.support.api.SiriusTestCase;
import org.eclipse.sirius.tree.business.internal.migration.description.InitializeCreationToolElementsToSelectExpressionParticipant;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.osgi.framework.Version;

public class InitializeElementsToSelectExpressionForTreeMigrationTest
extends SiriusTestCase {
    private static final String PATH = "/data/unit/tools/selection/";
    private static final String MODELER_FILE_NAME = "VSMForSelection.odesign";

    protected IDiagramCommandFactory getCommandFactory() {
        return null;
    }

    public void testMigrationIsNeededOnData() {
        Version loadedVersion = this.checkVsmFileMigrationStatus(URI.createPlatformPluginURI((String)"org.eclipse.sirius.tests.junit/data/unit/tools/selection/VSMForSelection.odesign", (boolean)true), true);
        Version migration = InitializeCreationToolElementsToSelectExpressionParticipant.MIGRATION_VERSION;
        InitializeElementsToSelectExpressionForTreeMigrationTest.assertTrue((String)"The migration must be required on test data.", (loadedVersion == null || migration.compareTo(loadedVersion) > 0 ? 1 : 0) != 0);
    }

    public void testElementsToSelectExpressionMigration() throws Exception {
        this.copyFilesToTestProject("org.eclipse.sirius.tests.junit", PATH, new String[]{MODELER_FILE_NAME});
        ResourceSetImpl set = new ResourceSetImpl();
        Group vsmRoot = null;
        vsmRoot = (Group)ModelUtils.load((URI)URI.createPlatformResourceURI((String)"DesignerTestProject/VSMForSelection.odesign", (boolean)true), (ResourceSet)set);
        AbstractToolDescription tool = this.getTool((EObject)vsmRoot, "Tree_CreateItem");
        InitializeElementsToSelectExpressionForTreeMigrationTest.assertEquals((String)"Bad ElementsToSelect expression", (String)tool.getElementsToSelect(), (String)"service:stdEmptyCollection");
        tool = this.getTool((EObject)vsmRoot, "Initialized_Tree_CreateItem");
        InitializeElementsToSelectExpressionForTreeMigrationTest.assertEquals((String)"Bad ElementsToSelect expression", (String)tool.getElementsToSelect(), (String)"[instance/]");
        try {
            vsmRoot.eResource().save(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String version = vsmRoot.getVersion();
        InitializeElementsToSelectExpressionForTreeMigrationTest.assertFalse((String)"The version tag should now be set telling that the migration was done.", (boolean)VSMMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)version)));
    }

    private AbstractToolDescription getTool(EObject root, String name) {
        TreeIterator allContents = root.eAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof AbstractToolDescription) || !((AbstractToolDescription)eObject).getName().equals(name)) continue;
            return (AbstractToolDescription)eObject;
        }
        return null;
    }
}

