/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.user;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;

public final class UserProjectsField {
    private static final String PROJECTS_FIELD = "projects";
    private static final int COMPLEXITY = 1;

    private UserProjectsField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(PROJECTS_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("UserProjectConnection")).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(UserProjectsField.getProjectsDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getProjectsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()), UserProjectsField::computeProjectCursor);
    }

    private static String computeProjectCursor(IProject project) {
        String unEncodedCursor = project.getName();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }
}

