/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.internal;

import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.rap.e4.internal.RAPEventBroker;
import org.eclipse.rap.e4.internal.RAPEventObjectSupplier;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RAPUIEventObjectSupplier
extends RAPEventObjectSupplier {
    @Inject
    protected UISynchronize uiSync;
    @Inject
    @Optional
    protected Logger logger;

    @Override
    protected EventHandler makeHandler(String topic, IRequestor requestor) {
        return new UIEventHandler(topic, requestor);
    }

    @Override
    protected String getTopic(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        UIEventTopic qualifier = (UIEventTopic)descriptor.getQualifier(UIEventTopic.class);
        return RAPEventBroker.rapifyTopic(this.instanceId, qualifier.value());
    }

    class UIEventHandler
    implements EventHandler {
        protected final IRequestor requestor;
        private final String topic;

        public UIEventHandler(String topic, IRequestor requestor) {
            this.topic = topic;
            this.requestor = requestor;
        }

        public void handleEvent(Event event) {
            if (!this.requestor.isValid()) {
                RAPUIEventObjectSupplier.this.unsubscribe(this.requestor);
                return;
            }
            RAPUIEventObjectSupplier.this.addCurrentEvent(this.topic, event);
            this.requestor.resolveArguments(false);
            RAPUIEventObjectSupplier.this.removeCurrentEvent(this.topic);
            if (RAPUIEventObjectSupplier.this.uiSync == null) {
                if (RAPUIEventObjectSupplier.this.logger != null) {
                    RAPUIEventObjectSupplier.this.logger.log(Level.WARNING, "No realm found to process UI event " + event);
                }
                return;
            }
            if (RAPEventBroker.isAsyncEvent(event)) {
                RAPUIEventObjectSupplier.this.uiSync.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UIEventHandler.this.requestor.execute();
                    }
                });
            } else {
                RAPUIEventObjectSupplier.this.uiSync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UIEventHandler.this.requestor.execute();
                    }
                });
            }
        }
    }
}

