/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.corba.ServerRequestImpl;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.protocol.RequestCanceledException;
import com.sun.corba.ee.impl.protocol.SpecialMethod;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.oa.NullServant;
import com.sun.corba.ee.spi.oa.OADestroyed;
import com.sun.corba.ee.spi.oa.OAInvocationInfo;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.orb.ObjectKeyCacheEntry;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.protocol.ServerRequestDispatcher;
import com.sun.corba.ee.spi.servicecontext.CodeSetServiceContext;
import com.sun.corba.ee.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.ee.spi.trace.Subcontract;
import com.sun.corba.ee.spi.transport.Connection;
import org.glassfish.pfl.basic.logex.OperationTracer;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;

@Subcontract
public class ServerRequestDispatcherImpl
implements ServerRequestDispatcher {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final POASystemException poaWrapper = POASystemException.self;
    protected ORB orb;

    public ServerRequestDispatcherImpl(ORB orb) {
        this.orb = orb;
    }

    @Override
    @Subcontract
    public IOR locate(ObjectKey okey) {
        ObjectKeyTemplate oktemp = okey.getTemplate();
        try {
            this.checkServerId(okey);
        }
        catch (ForwardException fex) {
            return fex.getIOR();
        }
        this.findObjectAdapter(oktemp);
        return null;
    }

    @InfoMethod
    private void generalMessage(String msg) {
    }

    @InfoMethod
    private void exceptionMessage(String msg, Throwable thr) {
    }

    @Override
    @Subcontract
    public void dispatch(MessageMediator request) {
        this.consumeServiceContexts(request);
        request.getInputObject().performORBVersionSpecificInit();
        ObjectKeyCacheEntry entry = request.getObjectKeyCacheEntry();
        ObjectKey okey = entry.getObjectKey();
        try {
            this.checkServerId(okey);
        }
        catch (ForwardException fex) {
            this.operationAndId(request.getOperationName(), request.getRequestId());
            request.getProtocolHandler().createLocationForward(request, fex.getIOR(), null);
            return;
        }
        String operation = request.getOperationName();
        ObjectAdapter objectAdapter = entry.getObjectAdapter();
        try {
            byte[] objectId = okey.getId().getId();
            ObjectKeyTemplate oktemp = okey.getTemplate();
            if (objectAdapter == null) {
                objectAdapter = this.findObjectAdapter(oktemp);
                entry.setObjectAdapter(objectAdapter);
            }
            Object servant = this.getServantWithPI(request, objectAdapter, objectId, oktemp, operation);
            this.dispatchToServant(servant, request, objectId, objectAdapter);
        }
        catch (ForwardException ex) {
            this.generalMessage("Caught ForwardException");
            request.getProtocolHandler().createLocationForward(request, ex.getIOR(), null);
        }
        catch (OADestroyed ex) {
            this.generalMessage("Caught OADestroyed");
            entry.clearObjectAdapter();
            this.dispatch(request);
        }
        catch (RequestCanceledException ex) {
            this.generalMessage("Caught RequestCanceledException");
            throw ex;
        }
        catch (UnknownException ex) {
            this.generalMessage("Caught UnknownException");
            if (ex.originalEx instanceof RequestCanceledException) {
                throw (RequestCanceledException)ex.originalEx;
            }
            ServiceContexts contexts = ServiceContextDefaults.makeServiceContexts(this.orb);
            UEInfoServiceContext usc = ServiceContextDefaults.makeUEInfoServiceContext(ex.originalEx);
            contexts.put(usc);
            UNKNOWN sysex = wrapper.unknownExceptionInDispatch((Exception)((Object)ex));
            request.getProtocolHandler().createSystemExceptionResponse(request, (SystemException)sysex, contexts);
        }
        catch (Throwable ex) {
            this.generalMessage("Caught other exception");
            request.getProtocolHandler().handleThrowableDuringServerDispatch(request, ex, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    @Subcontract
    private void releaseServant(ObjectAdapter objectAdapter) {
        if (objectAdapter == null) {
            this.generalMessage("Null object adapter");
            return;
        }
        try {
            objectAdapter.returnServant();
        }
        finally {
            objectAdapter.exit();
            this.orb.popInvocationInfo();
        }
    }

    @Subcontract
    private Object getServant(ObjectAdapter objectAdapter, byte[] objectId, String operation) throws OADestroyed {
        OAInvocationInfo info = objectAdapter.makeInvocationInfo(objectId);
        info.setOperation(operation);
        this.orb.pushInvocationInfo(info);
        objectAdapter.getInvocationServant(info);
        return info.getServantContainer();
    }

    @Subcontract
    protected Object getServantWithPI(MessageMediator request, ObjectAdapter objectAdapter, byte[] objectId, ObjectKeyTemplate oktemp, String operation) throws OADestroyed {
        this.orb.getPIHandler().initializeServerPIInfo(request, objectAdapter, objectId, oktemp);
        this.orb.getPIHandler().invokeServerPIStartingPoint();
        objectAdapter.enter();
        if (request != null) {
            request.setExecuteReturnServantInResponseConstructor(true);
        }
        Object servant = this.getServant(objectAdapter, objectId, operation);
        String mdi = "unknown";
        if (servant instanceof NullServant) {
            this.handleNullServant(operation, (NullServant)servant);
        } else {
            mdi = objectAdapter.getInterfaces(servant, objectId)[0];
        }
        this.orb.getPIHandler().setServerPIInfo(servant, mdi);
        if (servant != null && !(servant instanceof DynamicImplementation) && !(servant instanceof org.omg.PortableServer.DynamicImplementation) || SpecialMethod.getSpecialMethod(operation) != null) {
            this.orb.getPIHandler().invokeServerPIIntermediatePoint();
        }
        return servant;
    }

    @Subcontract
    protected void checkServerId(ObjectKey okey) {
        ObjectKeyTemplate oktemp = okey.getTemplate();
        int sId = oktemp.getServerId();
        int scid = oktemp.getSubcontractId();
        if (!this.orb.isLocalServerId(scid, sId)) {
            this.generalMessage("bad server ID");
            this.orb.handleBadServerId(okey);
        }
    }

    @Subcontract
    private ObjectAdapter findObjectAdapter(ObjectKeyTemplate oktemp) {
        int scid;
        RequestDispatcherRegistry scr = this.orb.getRequestDispatcherRegistry();
        ObjectAdapterFactory oaf = scr.getObjectAdapterFactory(scid = oktemp.getSubcontractId());
        if (oaf == null) {
            throw wrapper.noObjectAdapterFactory();
        }
        ObjectAdapterId oaid = oktemp.getObjectAdapterId();
        ObjectAdapter oa = oaf.find(oaid);
        if (oa == null) {
            throw wrapper.badAdapterId();
        }
        return oa;
    }

    @Subcontract
    protected void handleNullServant(String operation, NullServant nserv) {
        SpecialMethod specialMethod = SpecialMethod.getSpecialMethod(operation);
        if (specialMethod == null || !specialMethod.isNonExistentMethod()) {
            throw nserv.getException();
        }
    }

    @InfoMethod
    private void objectInfo(String msg, Object obj) {
    }

    @Subcontract
    protected void consumeServiceContexts(MessageMediator request) {
        this.operationAndId(request.getOperationName(), request.getRequestId());
        ServiceContexts ctxts = request.getRequestServiceContexts();
        GIOPVersion giopVersion = request.getGIOPVersion();
        boolean hasCodeSetContext = this.processCodeSetContext(request, ctxts);
        this.objectInfo("GIOP version", giopVersion);
        this.objectInfo("Has code set context?", hasCodeSetContext);
        ServiceContext sc = ctxts.get(6);
        if (sc != null) {
            SendingContextServiceContext scsc = (SendingContextServiceContext)sc;
            IOR ior = scsc.getIOR();
            try {
                request.getConnection().setCodeBaseIOR(ior);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                throw wrapper.badStringifiedIor(t);
            }
        }
        boolean isForeignORB = false;
        if (giopVersion.equals(GIOPVersion.V1_0) && hasCodeSetContext) {
            this.generalMessage("Old Sun ORB");
            this.orb.setORBVersion(ORBVersionFactory.getOLD());
        } else {
            isForeignORB = true;
        }
        sc = ctxts.get(1313165056);
        if (sc != null) {
            ORBVersionServiceContext ovsc = (ORBVersionServiceContext)sc;
            ORBVersion version = ovsc.getVersion();
            this.orb.setORBVersion(version);
            isForeignORB = false;
        }
        if (isForeignORB) {
            this.generalMessage("Foreign ORB");
            this.orb.setORBVersion(ORBVersionFactory.getFOREIGN());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subcontract
    protected MessageMediator dispatchToServant(Object servant, MessageMediator req, byte[] objectId, ObjectAdapter objectAdapter) {
        try {
            DynamicImplementation dynimpl;
            if (this.orb.operationTraceDebugFlag) {
                OperationTracer.enable();
            }
            OperationTracer.begin((String)"Dispatch to servant");
            this.operationAndId(req.getOperationName(), req.getRequestId());
            this.objectInfo("Servant info", servant);
            MessageMediator response = null;
            String operation = req.getOperationName();
            SpecialMethod method = SpecialMethod.getSpecialMethod(operation);
            if (method != null) {
                this.objectInfo("Handling special method", method.getName());
                MessageMediator messageMediator = response = method.invoke(servant, req, objectId, objectAdapter);
                return messageMediator;
            }
            if (servant instanceof DynamicImplementation) {
                this.generalMessage("Handling old style DSI type servant");
                dynimpl = (DynamicImplementation)servant;
                ServerRequestImpl sreq = new ServerRequestImpl(req, this.orb);
                dynimpl.invoke((ServerRequest)sreq);
                response = this.handleDynamicResult(sreq, req);
            } else if (servant instanceof org.omg.PortableServer.DynamicImplementation) {
                this.generalMessage("Handling POA DSI type servant");
                dynimpl = (org.omg.PortableServer.DynamicImplementation)servant;
                ServerRequestImpl sreq = new ServerRequestImpl(req, this.orb);
                dynimpl.invoke((ServerRequest)sreq);
                response = this.handleDynamicResult(sreq, req);
            } else {
                this.generalMessage("Handling invoke handler type servant");
                InvokeHandler invhandle = (InvokeHandler)servant;
                OutputStream stream = null;
                try {
                    stream = invhandle._invoke(operation, (InputStream)req.getInputObject(), (ResponseHandler)req);
                }
                catch (BAD_OPERATION e) {
                    wrapper.badOperationFromInvoke((Exception)((Object)e), operation);
                    throw e;
                }
                response = ((CDROutputObject)stream).getMessageMediator();
            }
            MessageMediator messageMediator = response;
            return messageMediator;
        }
        finally {
            OperationTracer.disable();
            OperationTracer.finish();
        }
    }

    @Subcontract
    protected MessageMediator handleDynamicResult(ServerRequestImpl sreq, MessageMediator req) {
        MessageMediator response = null;
        Any excany = sreq.checkResultCalled();
        if (excany == null) {
            this.generalMessage("Handling normal result");
            response = this.sendingReply(req);
            CDROutputObject os = response.getOutputObject();
            sreq.marshalReplyParams((OutputStream)os);
        } else {
            this.generalMessage("Handling error");
            response = this.sendingReply(req, excany);
        }
        return response;
    }

    @Subcontract
    protected MessageMediator sendingReply(MessageMediator req) {
        ServiceContexts scs = ServiceContextDefaults.makeServiceContexts(this.orb);
        return req.getProtocolHandler().createResponse(req, scs);
    }

    @Subcontract
    protected MessageMediator sendingReply(MessageMediator req, Any excany) {
        MessageMediator resp;
        ServiceContexts scs = ServiceContextDefaults.makeServiceContexts(this.orb);
        this.operationAndId(req.getOperationName(), req.getRequestId());
        String repId = null;
        try {
            repId = excany.type().id();
        }
        catch (BadKind e) {
            throw wrapper.problemWithExceptionTypecode((Exception)((Object)e));
        }
        if (ORBUtility.isSystemException(repId)) {
            this.generalMessage("Handling system exception");
            InputStream in = excany.create_input_stream();
            SystemException ex = ORBUtility.readSystemException(in);
            resp = req.getProtocolHandler().createSystemExceptionResponse(req, ex, scs);
        } else {
            this.generalMessage("Handling user exception");
            resp = req.getProtocolHandler().createUserExceptionResponse(req, scs);
            CDROutputObject os = resp.getOutputObject();
            excany.write_value((OutputStream)os);
        }
        return resp;
    }

    @InfoMethod
    private void codeSetServiceContextInfo(CodeSetServiceContext csctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subcontract
    protected boolean processCodeSetContext(MessageMediator request, ServiceContexts contexts) {
        ServiceContext sc = contexts.get(1);
        if (sc != null) {
            Connection connection;
            if (request.getConnection() == null) {
                return true;
            }
            if (request.getGIOPVersion().equals(GIOPVersion.V1_0)) {
                return true;
            }
            CodeSetServiceContext cssc = (CodeSetServiceContext)sc;
            CodeSetComponentInfo.CodeSetContext csctx = cssc.getCodeSetContext();
            Connection connection2 = connection = request.getConnection();
            synchronized (connection2) {
                if (connection.getCodeSetContext() == null) {
                    this.operationAndId(request.getOperationName(), request.getRequestId());
                    this.codeSetServiceContextInfo(cssc);
                    connection.setCodeSetContext(csctx);
                    if (csctx.getCharCodeSet() != OSFCodeSetRegistry.ISO_8859_1.getNumber()) {
                        request.getInputObject().resetCodeSetConverters();
                    }
                }
            }
        }
        return sc != null;
    }

    @InfoMethod
    private void operationAndId(String operation, int rid) {
    }
}

