/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseTypeBase;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class ObjectType
extends CompositeDatabaseTypeBase
implements CompositeDatabaseType {
    protected String schema;
    protected List<FieldType> fields = new ArrayList<FieldType>();

    public ObjectType(String typeName) {
        super(typeName);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public DatabaseType getEnclosedType() {
        return null;
    }

    @Override
    public void setEnclosedType(DatabaseType enclosedType) {
    }

    public List<FieldType> getFields() {
        return this.fields;
    }

    public void addField(FieldType field) {
        this.fields.add(field);
    }

    @Override
    public boolean isResolved() {
        for (FieldType fType : this.fields) {
            if (fType.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isObjectType() {
        return true;
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String shortName() {
        return this.typeName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" (");
        Iterator<FieldType> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            FieldType f = iterator.next();
            sb.append("\n\t");
            sb.append(f.toString());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("\n)");
        return sb.toString();
    }
}

