/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.weaving.ClassDetails;
import org.eclipse.persistence.internal.jpa.weaving.ClassWeaver;
import org.eclipse.persistence.internal.jpa.weaving.ComputeClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.commons.SerialVersionUIDAdder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    protected Session session;
    protected Map classDetailsMap;

    public PersistenceWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.session = null;
        this.classDetailsMap = null;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        Session session;
        boolean shouldLogFinest;
        block20: {
            shouldLogFinest = ((AbstractSession)this.session).shouldLog(1, "weaver");
            Map classDetailsMap = this.classDetailsMap;
            session = this.session;
            if (classDetailsMap == null || session == null) {
                return null;
            }
            try {
                ClassDetails classDetails = (ClassDetails)classDetailsMap.get(Helper.toSlashedClassName((String)className));
                if (classDetails != null) {
                    void var11_15;
                    if (shouldLogFinest) {
                        ((AbstractSession)session).log(1, "weaver", "begin_weaving_class", (Object)className);
                    }
                    ClassReader classReader = new ClassReader(classfileBuffer);
                    Object var11_12 = null;
                    String introspectForHierarchy = System.getProperty("eclipselink.weaving.reflective-introspection", null);
                    if (introspectForHierarchy != null) {
                        ClassWriter classWriter = new ClassWriter(2);
                    } else {
                        ComputeClassWriter computeClassWriter = new ComputeClassWriter(loader, 2);
                    }
                    ClassWeaver classWeaver = new ClassWeaver((ClassVisitor)var11_15, classDetails);
                    SerialVersionUIDAdder sv = new SerialVersionUIDAdder((ClassVisitor)classWeaver);
                    classReader.accept((ClassVisitor)sv, 0);
                    if (classWeaver.alreadyWeaved) {
                        if (shouldLogFinest) {
                            ((AbstractSession)session).log(1, "weaver", "end_weaving_class", (Object)className);
                        }
                        return null;
                    }
                    if (classWeaver.weaved) {
                        byte[] bytes = var11_15.toByteArray();
                        String outputPath = System.getProperty("eclipselink.weaving.output.path", "");
                        if (!outputPath.equals("")) {
                            Helper.outputClassFile((String)className, (byte[])bytes, (String)outputPath);
                        }
                        if (shouldLogFinest) {
                            if (classWeaver.weavedPersistenceEntity) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_persistenceentity", (Object)className);
                            }
                            if (classWeaver.weavedChangeTracker) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_changetracker", (Object)className);
                            }
                            if (classWeaver.weavedLazy) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_lazy", (Object)className);
                            }
                            if (classWeaver.weavedFetchGroups) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_fetchgroups", (Object)className);
                            }
                            if (classWeaver.weavedRest) {
                                ((AbstractSession)session).log(1, "weaver", "weaved_rest", (Object)className);
                            }
                            ((AbstractSession)session).log(1, "weaver", "end_weaving_class", (Object)className);
                        }
                        return bytes;
                    }
                    if (shouldLogFinest) {
                        ((AbstractSession)session).log(1, "weaver", "end_weaving_class", (Object)className);
                    }
                    break block20;
                }
                if (shouldLogFinest) {
                    ((AbstractSession)session).log(1, "weaver", "transform_missing_class_details", (Object)className);
                }
            }
            catch (Throwable exception) {
                ((AbstractSession)session).log(6, "weaver", "exception_while_weaving", new Object[]{className, exception.getLocalizedMessage()});
                if (!shouldLogFinest) break block20;
                ((AbstractSession)session).logThrowable(1, "weaver", exception);
            }
        }
        if (shouldLogFinest) {
            ((AbstractSession)session).log(1, "weaver", "transform_existing_class_bytes", (Object)className);
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

