/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class SessionManager {
    protected static boolean shouldUseSchemaValidation = true;
    protected static volatile SessionManager manager;
    protected AbstractSession defaultSession;
    protected ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>(5);
    protected static boolean shouldPerformDTDValidation;
    private static volatile ConcurrentMap<String, SessionManager> managers;
    private static volatile ServerPlatform detectedPlatform;
    private static volatile boolean supportPartitions;
    private String context;
    private static final Object[] lock;
    private static final SessionLog LOG;

    static {
        lock = new Object[0];
        LOG = AbstractSessionLog.getLog();
        SessionManager.init();
    }

    private static void init() {
        String platformClass = ServerPlatformUtils.detectServerPlatform(null);
        try {
            detectedPlatform = ServerPlatformUtils.createServerPlatform(null, platformClass, SessionManager.class.getClassLoader());
        }
        catch (NullPointerException npe) {
            detectedPlatform = null;
            LOG.logThrowable(6, "connection", npe);
        }
        boolean bl = supportPartitions = detectedPlatform != null && detectedPlatform.usesPartitions();
        if (supportPartitions) {
            SessionManager sm;
            managers = new ConcurrentHashMap<String, SessionManager>(4, 0.9f, 1);
            manager = sm = SessionManager.initializeManager();
            managers.put(sm.context, sm);
        } else {
            manager = SessionManager.initializeManager();
        }
    }

    public static boolean shouldUseSchemaValidation() {
        return shouldUseSchemaValidation;
    }

    public static void setShouldUseSchemaValidation(boolean useSchemaValidation) {
        shouldUseSchemaValidation = useSchemaValidation;
    }

    public SessionManager() {
        if (supportPartitions) {
            this.context = SessionManager.getPartitionID();
        }
    }

    public void addSession(Session session) {
        this.getSessions().put(session.getName(), session);
    }

    public void addSession(String sessionName, Session session) {
        session.setName(sessionName);
        this.getSessions().put(sessionName, session);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.getSession("default");
        }
        return this.defaultSession;
    }

    public void destroy() {
        if (supportPartitions && managers.remove(SessionManager.getPartitionID()) == null) {
            LOG.log(6, "session_manager_no_partition", new Object[0]);
        }
    }

    public void destroySession(String sessionName) {
        Session session = (Session)this.getSessions().get(sessionName);
        if (session != null) {
            this.destroy(session);
        } else {
            this.logAndThrowException(6, ValidationException.noSessionRegisteredForName(sessionName));
        }
    }

    private void destroy(Session session) {
        try {
            if (session.isConnected()) {
                ((DatabaseSession)session).logout();
            }
        }
        catch (Throwable ignore) {
            LOG.logThrowable(6, "connection", ignore);
        }
        this.sessions.remove(session.getName());
        session = null;
    }

    public void destroyAllSessions() {
        Iterator toRemoveSessions = new ArrayList(this.getSessions().values()).iterator();
        while (toRemoveSessions.hasNext()) {
            this.destroy((Session)toRemoveSessions.next());
        }
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String resourceName, ClassLoader objectClassLoader) {
        return this.getInternalMWConfigObjects(resourceName, objectClassLoader, true);
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String resourceName, ClassLoader objectClassLoader, boolean validate) {
        return new XMLSessionConfigLoader(resourceName).loadConfigsForMappingWorkbench(objectClassLoader, validate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SessionManager getManager() {
        if (!supportPartitions) {
            if (manager != null) return manager;
            Object[] objectArray = lock;
            // MONITORENTER : lock
            if (manager == null) {
                manager = SessionManager.initializeManager();
            }
            // MONITOREXIT : objectArray
            return manager;
        }
        SessionManager current = manager;
        String currentCtx = SessionManager.getPartitionID();
        if (current != null && currentCtx.equals(current.context)) {
            if (!LOG.shouldLog(2)) return current;
            LOG.log(2, "returning cached session manager for " + current.context);
            return current;
        }
        current = (SessionManager)managers.get(currentCtx);
        if (current == null) {
            Object[] objectArray = lock;
            // MONITORENTER : lock
            if (current == null) {
                current = SessionManager.initializeManager();
                current.context = currentCtx;
                managers.put(current.context, current);
                manager = current;
                if (LOG.shouldLog(2)) {
                    LOG.log(2, "created session manager for " + current.context);
                }
            }
            // MONITOREXIT : objectArray
        }
        if (!LOG.shouldLog(2)) return current;
        LOG.log(2, "returning session manager for " + current.context);
        return current;
    }

    public static Collection<SessionManager> getAllManagers() {
        return supportPartitions ? managers.values() : Collections.singleton(SessionManager.getManager());
    }

    protected static SessionManager initializeManager() {
        if (LOG.shouldLog(2)) {
            LOG.log(2, "initializing session manager");
        }
        return new SessionManager();
    }

    public AbstractSession getSession(String sessionName) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setShouldLogin(shouldLoginSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession, boolean shouldRefreshSession) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, Object objectBean) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        ClassLoader classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classLoader = AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(objectBean.getClass()));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            classLoader = PrivilegedAccessHelper.getClassLoaderForClass(objectBean.getClass());
        }
        loader.setClassLoader(classLoader);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, String filename) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setResourceName(filename);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, String filename, ClassLoader classLoader) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setResourceName(filename);
        loader.setClassLoader(classLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, ClassLoader objectClassLoader) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader, boolean shouldLoginSession, boolean shouldRefreshSession) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader, boolean shouldLoginSession, boolean shouldRefreshSession, boolean shouldCheckClassLoader) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        loader.setShouldCheckClassLoader(shouldCheckClassLoader);
        return this.getSession(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSession getSession(XMLSessionConfigLoader loader) {
        SessionManager sessionManager;
        AbstractSession session = (AbstractSession)this.getSessions().get(loader.getSessionName());
        boolean shouldRefreshSession = loader.shouldRefresh();
        if (loader.shouldCheckClassLoader() && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(loader.getClassLoader())) {
            shouldRefreshSession = true;
        }
        if (session == null || shouldRefreshSession) {
            sessionManager = this;
            synchronized (sessionManager) {
                session = (AbstractSession)this.getSessions().get(loader.getSessionName());
                if (loader.shouldCheckClassLoader() && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(loader.getClassLoader())) {
                    shouldRefreshSession = true;
                }
                if (session == null || shouldRefreshSession) {
                    if (session != null) {
                        if (session.isDatabaseSession() && session.isConnected()) {
                            try {
                                ((DatabaseSession)((Object)session)).logout();
                            }
                            catch (Throwable ignore) {
                                LOG.logThrowable(6, "connection", ignore);
                            }
                        }
                        this.getSessions().remove(loader.getSessionName());
                    }
                    if (loader.load(this, loader.getClassLoader())) {
                        session = (AbstractSession)this.getSessions().get(loader.getSessionName());
                    }
                }
            }
        }
        if (session == null) {
            this.logAndThrowException(6, ValidationException.noSessionFound(loader.getSessionName(), loader.getResourcePath()));
        } else if (loader.shouldLogin() && !session.isConnected()) {
            sessionManager = this;
            synchronized (sessionManager) {
                if (loader.shouldLogin() && !session.isConnected()) {
                    ((DatabaseSession)((Object)session)).login();
                }
            }
        }
        return session;
    }

    private void logAndThrowException(int level, RuntimeException exception) throws RuntimeException {
        LOG.logThrowable(level, "connection", exception);
        throw exception;
    }

    public void setSessions(ConcurrentMap sessions) {
        this.sessions = sessions;
    }

    public ConcurrentMap<String, Session> getSessions() {
        return this.sessions;
    }

    public void setDefaultSession(Session defaultSession) {
        this.defaultSession = (AbstractSession)defaultSession;
        this.addSession("default", defaultSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setManager(SessionManager theManager) {
        if (!supportPartitions) {
            manager = theManager;
        } else if (theManager.context == null) {
            Object[] objectArray = lock;
            synchronized (lock) {
                if (theManager.context == null) {
                    theManager.context = SessionManager.getPartitionID();
                }
                managers.put(theManager.context, theManager);
                if (LOG.shouldLog(2)) {
                    LOG.log(2, "registered session manager w/o partitionId for " + theManager.context);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            managers.put(theManager.context, theManager);
            if (LOG.shouldLog(2)) {
                LOG.log(2, "registered session manager w/ partitionId for " + theManager.context);
            }
        }
    }

    private static String getPartitionID() {
        return detectedPlatform.getPartitionID();
    }
}

