/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.PrecisionType;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.test.AllTests;
import org.eclipse.persistence.tools.oracleddl.test.TestHelper;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConstraintsTableDDLTestSuite {
    static final String CONSTRAINTS_TABLE = "CONSTRAINT_TABLE";
    static final String CONSTRAINTS_TABLE_FIELD1 = "EMPLOYEE_ID";
    static final String CONSTRAINTS_TABLE_FIELD2 = "SALARY";
    static final String CONSTRAINTS_TABLE_FIELD3 = "EMAIL";
    static final String CREATE_CONSTRAINTS_TABLE = "CREATE TABLE CONSTRAINT_TABLE (\nEMPLOYEE_ID NUMBER(6) NOT NULL,\nSALARY NUMBER(8,2),\nEMAIL VARCHAR2(25) CONSTRAINT \"EMP_EMAIL_NN\" NOT NULL ENABLE,\nCONSTRAINT \"EMP_EMP_ID_PK\" PRIMARY KEY (EMPLOYEE_ID) ENABLE,\nCONSTRAINT \"EMP_EMAIL_UK\" UNIQUE (EMAIL) ENABLE,\nCONSTRAINT \"EMP_SALARY_MIN\" CHECK (SALARY > 0) ENABLE)";
    static final String DROP_CONSTRAINTS_TABLE = "DROP TABLE CONSTRAINT_TABLE";
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Connection conn = AllTests.conn;
    static TableType tableType = null;
    static List<String> expectedFieldNames = new ArrayList<String>();
    static List<String> expectedPKFieldNames = new ArrayList<String>();
    static boolean ddlCreate = false;
    static boolean ddlDrop = false;
    static boolean ddlDebug = false;

    @BeforeClass
    public static void setUp() throws SQLException, ClassNotFoundException {
        String ddlDebugProp;
        String ddlDropProp;
        conn = TestHelper.buildConnection();
        dtBuilder = new DatabaseTypeBuilder();
        String ddlCreateProp = System.getProperty("db.ddl.create", "false");
        if ("true".equalsIgnoreCase(ddlCreateProp)) {
            ddlCreate = true;
        }
        if ("true".equalsIgnoreCase(ddlDropProp = System.getProperty("db.ddl.drop", "false"))) {
            ddlDrop = true;
        }
        if ("true".equalsIgnoreCase(ddlDebugProp = System.getProperty("db.ddl.debug", "false"))) {
            ddlDebug = true;
        }
        if (ddlCreate) {
            TestHelper.runDdl(conn, CREATE_CONSTRAINTS_TABLE, ddlDebug);
        }
        boolean worked = true;
        String msg = null;
        try {
            tableType = dtBuilder.buildTables(conn, "", CONSTRAINTS_TABLE).get(0);
        }
        catch (Exception e) {
            worked = false;
            msg = e.getMessage();
        }
        if (!worked) {
            Assert.fail((String)msg);
        }
        expectedPKFieldNames.add(CONSTRAINTS_TABLE_FIELD1);
        expectedFieldNames.add(CONSTRAINTS_TABLE_FIELD1);
        expectedFieldNames.add(CONSTRAINTS_TABLE_FIELD2);
        expectedFieldNames.add(CONSTRAINTS_TABLE_FIELD3);
    }

    @AfterClass
    public static void tearDown() {
        if (ddlDrop) {
            TestHelper.runDdl(conn, DROP_CONSTRAINTS_TABLE, ddlDebug);
        }
    }

    @Test
    public void testTableName() {
        Assert.assertEquals((String)"incorrect table name", (Object)CONSTRAINTS_TABLE, (Object)tableType.getTableName());
    }

    @Test
    public void testNumberOfColumns() {
        List<FieldType> columns = tableType.getColumns();
        Assert.assertTrue((String)"incorrect number of columns", (columns.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testPrimaryKeys() {
        List<FieldType> columns = tableType.getColumns();
        ArrayList<String> pkFieldNames = new ArrayList<String>();
        for (FieldType field : columns) {
            if (!field.pk()) continue;
            pkFieldNames.add(field.getFieldName());
        }
        Assert.assertEquals((String)"incorrect PK column names", expectedPKFieldNames, pkFieldNames);
    }

    @Test
    public void testColumnNames() {
        List<FieldType> columns = tableType.getColumns();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldType field : columns) {
            fieldNames.add(field.getFieldName());
        }
        Assert.assertEquals((String)"incorrect column names", expectedFieldNames, fieldNames);
    }

    @Test
    public void testColumnTypes() {
        List<FieldType> columns = tableType.getColumns();
        FieldType field1 = columns.get(0);
        DatabaseType col1Type = field1.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [EMPLOYEE_ID]", (Object)new NumericType().getTypeName(), (Object)col1Type.getTypeName());
        Assert.assertTrue((String)"incorrect NULL constraint for column [EMPLOYEE_ID]", (boolean)field1.notNull());
        FieldType field2 = columns.get(1);
        DatabaseType col2Type = field2.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [SALARY]", (Object)new NumericType().getTypeName(), (Object)col2Type.getTypeName());
        Assert.assertFalse((String)"incorrect NULL constraint for column [SALARY]", (boolean)field2.notNull());
        Assert.assertTrue((String)"incorrect precision for column [SALARY]", (((PrecisionType)col2Type).getPrecision() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((String)"incorrect scale for column [SALARY]", (((PrecisionType)col2Type).getScale() == 2L ? 1 : 0) != 0);
        FieldType field3 = columns.get(2);
        DatabaseType col3Type = field3.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [EMAIL]", (Object)new VarChar2Type().getTypeName(), (Object)col3Type.getTypeName());
        Assert.assertTrue((String)"incorrect size for column [EMAIL]", (((SizedType)col3Type).getSize() == 25L ? 1 : 0) != 0);
    }
}

