/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionRegistry {
    private Map<String, ExpressionFactory> expressionFactories;
    private Map<String, IdentifierRole> identifiers;
    private Map<String, JPAVersion> identifierVersions;
    private Map<String, JPQLQueryBNF> queryBNFs;

    public ExpressionRegistry() {
        this.initialize();
    }

    public void addChildBNF(String queryBNFId, String childQueryBNFId) {
        JPQLQueryBNF queryBNF = this.queryBNFs.get(queryBNFId);
        Assert.isNotNull(queryBNF, "The JPQLQueryBNF identified with '" + queryBNFId + "' does not exist.");
        queryBNF.registerChild(childQueryBNFId);
    }

    public void addChildFactory(String queryBNFId, String childExpressionFactoryId) {
        JPQLQueryBNF queryBNF = this.queryBNFs.get(queryBNFId);
        Assert.isNotNull(queryBNF, "The JPQLQueryBNF identified with '" + queryBNFId + "' does not exist.");
        queryBNF.registerExpressionFactory(childExpressionFactoryId);
    }

    public void addIdentifier(String expressionFactoryId, String identifier) {
        this.getExpressionFactory(expressionFactoryId).addIdentifier(identifier);
    }

    public void addIdentifiers(String expressionFactoryId, String ... identifiers) {
        this.getExpressionFactory(expressionFactoryId).addIdentifiers(identifiers);
    }

    public ExpressionFactory expressionFactoryForIdentifier(String identifier) {
        if ("SELECT".equalsIgnoreCase(identifier = identifier.toUpperCase())) {
            return this.getExpressionFactory("simple-select");
        }
        for (ExpressionFactory expressionFactory : this.expressionFactories.values()) {
            boolean found;
            boolean bl = found = Arrays.binarySearch(expressionFactory.identifiers(), identifier) > -1;
            if (!found) continue;
            return expressionFactory;
        }
        return null;
    }

    public ExpressionFactory getExpressionFactory(String expressionFactoryId) {
        return this.expressionFactories.get(expressionFactoryId);
    }

    public IdentifierRole getIdentifierRole(String identifier) {
        return this.identifiers.get(identifier.toUpperCase());
    }

    public Set<String> getIdentifiers() {
        return Collections.unmodifiableSet(this.identifiers.keySet());
    }

    public Set<String> getIdentifiers(String queryBNFId) {
        return this.getQueryBNF(queryBNFId).getIdentifiers();
    }

    public JPAVersion getIdentifierVersion(String identifier) {
        JPAVersion version = this.identifierVersions.get(identifier.toUpperCase());
        return version != null ? version : JPAVersion.VERSION_1_0;
    }

    public JPQLQueryBNF getQueryBNF(String queryBNFId) {
        return this.queryBNFs.get(queryBNFId);
    }

    protected void initialize() {
        this.queryBNFs = new HashMap<String, JPQLQueryBNF>();
        this.identifiers = new HashMap<String, IdentifierRole>();
        this.expressionFactories = new HashMap<String, ExpressionFactory>();
        this.identifierVersions = new HashMap<String, JPAVersion>();
    }

    public boolean isIdentifier(String text) {
        return this.identifiers.containsKey(text.toUpperCase());
    }

    public void registerBNF(JPQLQueryBNF queryBNF) {
        Assert.isNotNull(queryBNF, "The JPQLQueryBNF cannot be null");
        this.queryBNFs.put(queryBNF.getId(), queryBNF);
        queryBNF.setExpressionRegistry(this);
    }

    public void registerFactory(ExpressionFactory expressionFactory) {
        Assert.isNotNull(expressionFactory, "The ExpressionFactory cannot be null");
        this.expressionFactories.put(expressionFactory.getId(), expressionFactory);
        expressionFactory.setExpressionRegistry(this);
    }

    public void registerIdentifierRole(String identifier, IdentifierRole role) {
        Assert.isNotNull(identifier, "The JPQL identifier cannot be null");
        Assert.isNotNull((Object)role, "The IdentifierRole cannot be null");
        this.identifiers.put(identifier, role);
    }

    public void registerIdentifierVersion(String identifier, JPAVersion version) {
        Assert.isNotNull(identifier, "The JPQL identifier cannot be null");
        Assert.isNotNull((Object)version, "The JPAVersion cannot be null");
        this.identifierVersions.put(identifier, version);
    }

    public void setFallbackBNFId(String queryBNFId, String fallbackBNFId) {
        JPQLQueryBNF queryBNF = this.queryBNFs.get(queryBNFId);
        Assert.isNotNull(queryBNF, "The JPQLQueryBNF identified with '" + queryBNFId + "' does not exist.");
        queryBNF.setFallbackBNFId(queryBNFId);
    }

    public void setHandleSubExpression(String queryBNFId, boolean handleSubExpression) {
        JPQLQueryBNF queryBNF = this.queryBNFs.get(queryBNFId);
        Assert.isNotNull(queryBNF, "The JPQLQueryBNF identified with '" + queryBNFId + "' does not exist.");
        queryBNF.setHandleSubExpression(handleSubExpression);
    }

    public void setFallbackExpressionFactoryId(String queryBNFId, String fallbackExpressionFactoryId) {
        JPQLQueryBNF queryBNF = this.queryBNFs.get(queryBNFId);
        Assert.isNotNull(queryBNF, "The JPQLQueryBNF identified with '" + queryBNFId + "' does not exist.");
        queryBNF.setFallbackExpressionFactoryId(fallbackExpressionFactoryId);
    }

    void unregisterBNF(JPQLQueryBNF queryBNF) {
        Assert.isNotNull(queryBNF, "The JPQLQueryBNF cannot be null");
        this.queryBNFs.remove(queryBNF.getId());
        queryBNF.setExpressionRegistry(null);
    }
}

