/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.types.BSONTimestamp;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class JSONCallback
extends BasicBSONCallback {
    private boolean _lastArray = false;

    public BSONObject create() {
        return new BasicDBObject();
    }

    protected BSONObject createList() {
        return new BasicDBList();
    }

    public void objectStart(boolean array, String name) {
        this._lastArray = array;
        super.objectStart(array, name);
    }

    public Object objectDone() {
        String name = this.curName();
        Object o = super.objectDone();
        BSONObject b = (BSONObject)o;
        if (!this._lastArray) {
            if (b.containsField("$oid")) {
                o = new ObjectId((String)b.get("$oid"));
                if (!this.isStackEmpty()) {
                    this.gotObjectId(name, (ObjectId)o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$date")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                GregorianCalendar calendar = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
                format.setCalendar(calendar);
                String txtdate = (String)b.get("$date");
                o = format.parse(txtdate, new ParsePosition(0));
                if (o == null) {
                    format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    format.setCalendar(calendar);
                    o = format.parse(txtdate, new ParsePosition(0));
                }
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$regex")) {
                o = Pattern.compile((String)b.get("$regex"), BSON.regexFlags((String)b.get("$options")));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$ts")) {
                Long ts = ((Number)b.get("$ts")).longValue();
                Long inc = ((Number)b.get("$inc")).longValue();
                o = new BSONTimestamp(ts.intValue(), inc.intValue());
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$code")) {
                o = b.containsField("$scope") ? new CodeWScope((String)b.get("$code"), (DBObject)b.get("$scope")) : new Code((String)b.get("$code"));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$ref")) {
                o = new DBRef(null, (String)b.get("$ref"), b.get("$id"));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$minKey")) {
                o = new MinKey();
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$maxKey")) {
                o = new MaxKey();
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$uuid")) {
                o = UUID.fromString((String)b.get("$uuid"));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            }
        }
        return o;
    }
}

