/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class OracleHelper {
    public static List<DbStoredProcedure> buildStoredProcedure(Connection connection, String username, DatabasePlatform platform, ProcedureOperationModel procedureModel) {
        ArrayList<DbStoredProcedure> dbStoredProcedures = null;
        String originalCatalogPattern = procedureModel.getCatalogPattern();
        String originalSchemaPattern = procedureModel.getSchemaPattern();
        String originalProcedurePattern = procedureModel.getProcedurePattern();
        String packageName = Util.escapePunctuation(originalCatalogPattern, true);
        String schemaPattern = Util.escapePunctuation(originalSchemaPattern, true);
        final String procedurePattern = Util.escapePunctuation(originalProcedurePattern, true);
        if (schemaPattern == null || schemaPattern.length() == 0) {
            schemaPattern = username;
        }
        SqlTypeWithMethods typ = null;
        if (procedureModel.getJPubType() == null) {
            SqlReflector sqlReflector = new SqlReflector(connection, username);
            int whatItIs = 4;
            if ("TOPLEVEL".equalsIgnoreCase(packageName)) {
                whatItIs = 12;
                packageName = "";
            }
            try {
                typ = (SqlTypeWithMethods)sqlReflector.addSqlUserType(schemaPattern, packageName, whatItIs, true, 0, 0, new MethodFilter(){

                    @Override
                    public boolean acceptMethod(ProcedureMethod method, boolean preApprove) {
                        String methodName = method.getName();
                        return Util.sqlMatch(procedurePattern, methodName);
                    }
                });
                procedureModel.setJPubType(typ);
            }
            catch (Exception e) {}
        } else {
            typ = procedureModel.getJPubType();
        }
        List<ProcedureMethod> methods = null;
        try {
            methods = typ.getDeclaredMethods();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (methods.size() > 0) {
            boolean overloaded = methods.size() > 1;
            dbStoredProcedures = new ArrayList<DbStoredProcedure>();
            for (int j = 0; j < methods.size(); ++j) {
                ProcedureMethod m = methods.get(j);
                DbStoredProcedure dbStoredProcedure = null;
                TypeClass returnType = m.getReturnType();
                if (returnType == null) {
                    dbStoredProcedure = new DbStoredProcedure(m.getName());
                } else {
                    dbStoredProcedure = new DbStoredFunction(m.getName());
                    DbStoredArgument dbStoredArgument = new DbStoredArgument(returnType.getName());
                    dbStoredArgument.setInOut(Util.InOut.RETURN);
                    dbStoredArgument.setSeq(0);
                    dbStoredArgument.setJdbcType(returnType.getJdbcTypecode());
                    Name n = returnType.getNameObject();
                    String typeName = n instanceof SqlName ? ((SqlName)n).getTypeName() : n.getSimpleName();
                    dbStoredArgument.setJdbcTypeName(typeName);
                    ((DbStoredFunction)dbStoredProcedure).setReturnArg(dbStoredArgument);
                }
                if (overloaded) {
                    dbStoredProcedure.setOverload(j + 1);
                }
                dbStoredProcedure.setCatalog(packageName);
                dbStoredProcedure.setSchema(originalSchemaPattern);
                int l = m.getParamNames().length;
                for (int i = 0; i < l; ++i) {
                    String argName = m.getParamNames()[i];
                    TypeClass parameterType = m.getParamTypes()[i];
                    boolean isJDBCType = parameterType.isPrimitive() || parameterType.isObject() || parameterType.isTable() || parameterType.isArray();
                    DbStoredArgument dbStoredArgument = null;
                    dbStoredArgument = isJDBCType ? new DbStoredArgument(argName) : new PLSQLStoredArgument(argName);
                    int mode = m.getParamModes()[i];
                    Util.InOut inOut = Util.InOut.IN;
                    if (mode == 2) {
                        inOut = Util.InOut.OUT;
                    } else if (mode == 3) {
                        inOut = Util.InOut.INOUT;
                    }
                    dbStoredArgument.setInOut(inOut);
                    dbStoredArgument.setSeq(i);
                    dbStoredArgument.setJdbcType(parameterType.getJdbcTypecode());
                    Name n = parameterType.getNameObject();
                    String typeName = n instanceof SqlName ? ((SqlName)n).getTypeName() : n.getSimpleName();
                    if (isJDBCType) {
                        dbStoredArgument.setJdbcTypeName(typeName);
                    } else {
                        PLSQLStoredArgument plSqlArg = (PLSQLStoredArgument)dbStoredArgument;
                        plSqlArg.setPlSqlTypeName(typeName);
                        plSqlArg.setJdbcTypeName(n.getSimpleName());
                    }
                    dbStoredProcedure.getArguments().add(dbStoredArgument);
                }
                dbStoredProcedures.add(dbStoredProcedure);
            }
        }
        if (dbStoredProcedures != null && dbStoredProcedures.size() > 0) {
            procedureModel.setDbStoredProcedures((List<DbStoredProcedure>)dbStoredProcedures);
        }
        return dbStoredProcedures;
    }

    public static QName getXMLTypeFromJDBCType(DbStoredArgument arg, String targetNamespace) {
        QName fromJDBCType = null;
        if (2003 == arg.getJdbcType() || 2002 == arg.getJdbcType()) {
            fromJDBCType = new QName(targetNamespace, arg.getJdbcTypeName());
        } else {
            int typ = arg.getJdbcType();
            if (arg.isPLSQLArgument()) {
                PLSQLStoredArgument plsqlArg = (PLSQLStoredArgument)arg;
                String plsqlTypeName = plsqlArg.getPlSqlTypeName();
                typ = "BOOLEAN".equals(plsqlTypeName) ? OraclePLSQLTypes.PLSQLBoolean.getConversionCode() : OraclePLSQLTypes.BinaryInteger.getConversionCode();
            }
            fromJDBCType = "LONG".equals(arg.getJdbcTypeName()) ? XMLConstants.BASE_64_BINARY_QNAME : Util.getXMLTypeFromJDBCType(typ);
        }
        return fromJDBCType;
    }
}

