/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarshalRecord
extends XMLRecord {
    private ArrayList<XPathNode> groupingElements;
    private HashMap positionalNodes;
    protected static final String COLON_W_SCHEMA_NIL_ATTRIBUTE = ":nil";
    protected static final String TRUE = "true";

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    @Override
    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    @Override
    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    @Override
    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    @Override
    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public void addGroupingElement(XPathNode xPathNode) {
        if (null == this.groupingElements) {
            this.groupingElements = new ArrayList();
        }
        this.groupingElements.add(xPathNode);
    }

    public void removeGroupingElement(XPathNode xPathNode) {
        if (null != this.groupingElements) {
            this.groupingElements.remove(xPathNode);
        }
    }

    @Override
    public String transformToXML() {
        return null;
    }

    @Override
    public void add(DatabaseField key, Object value) {
        if (null == value) {
            return;
        }
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        XMLConversionManager xcm = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
        if (lastFragment.nameIsText()) {
            String stringValue = (String)xcm.convertObject(value, String.class);
            this.characters(stringValue);
        } else if (lastFragment.isAttribute()) {
            String stringValue = (String)xcm.convertObject(value, String.class);
            this.attribute(lastFragment, xmlField.getNamespaceResolver(), stringValue);
        } else {
            this.element(lastFragment);
        }
    }

    @Override
    public Object put(DatabaseField key, Object value) {
        this.add(key, value);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (null != namespaceURI) {
            this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", namespaceURI);
        }
        if (namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                String namespacePrefix = entry.getKey();
                this.attribute("http://www.w3.org/2000/xmlns/", namespacePrefix, "xmlns:" + namespacePrefix, entry.getValue());
            }
        }
    }

    public abstract void startDocument(String var1, String var2);

    public abstract void endDocument();

    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null && namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.startPrefixMapping(entry.getKey(), entry.getValue());
            }
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(XPathFragment var1);

    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    public abstract void attribute(String var1, String var2, String var3, String var4);

    public abstract void closeStartElement();

    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    public abstract void characters(String var1);

    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA) {
        if (mimeType != null) {
            value = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.characters(convertedValue);
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue);
            }
        }
    }

    protected String getStringForQName(QName qName) {
        if (null == qName) {
            return null;
        }
        String namespaceURI = qName.getNamespaceURI();
        if (null == namespaceURI || 0 == namespaceURI.length()) {
            if (this.getNamespaceResolver() != null && this.getNamespaceResolver().getDefaultNamespaceURI() != null) {
                this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", namespaceURI);
            }
            return qName.getLocalPart();
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        if (namespaceURI.equals(namespaceResolver.getDefaultNamespaceURI())) {
            return qName.getLocalPart();
        }
        String prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (null == prefix) {
            prefix = namespaceResolver.generatePrefix();
            this.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceURI);
        }
        return prefix + ':' + qName.getLocalPart();
    }

    public abstract void cdata(String var1);

    public abstract void node(Node var1, NamespaceResolver var2);

    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (null == this.groupingElements) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int groupingElementsSize = this.groupingElements.size();
        for (int x = 0; x < groupingElementsSize; ++x) {
            XPathNode xPathNode = this.groupingElements.get(x);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            this.predicateAttribute(xPathFragment, namespaceResolver);
            if (x == groupingElementsSize - 1) continue;
            this.closeStartElement();
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        if (null != groupingFragment) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            String shortName = xPathFragment.getShortName();
            Integer index = (Integer)this.getPositionalNodes().get(shortName);
            int start = null == index ? 1 : index;
            for (int x = start; x < xPathFragment.getIndexValue(); ++x) {
                this.element(xPathFragment);
            }
            this.getPositionalNodes().put(shortName, xPathFragment.getIndexValue() + 1);
        }
    }

    public void beforeContainmentMarshal(Object child) {
        XMLMarshalListener marshalListener;
        if (null != this.marshaller && null != (marshalListener = this.marshaller.getMarshalListener())) {
            marshalListener.beforeMarshal(child);
        }
        this.setOwningObject(child);
    }

    public void afterContainmentMarshal(Object parent, Object child) {
        XMLMarshalListener marshalListener;
        if (null != this.marshaller && null != (marshalListener = this.marshaller.getMarshalListener())) {
            marshalListener.afterMarshal(child);
        }
        this.setOwningObject(parent);
    }

    public ArrayList<XPathNode> getGroupingElements() {
        return this.groupingElements;
    }

    public void setGroupingElement(ArrayList<XPathNode> elements) {
        this.groupingElements = elements;
    }

    public void predicateAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment predicateXPathFragment;
        XPathPredicate predicate;
        if (null != xPathFragment && null != (predicate = xPathFragment.getPredicate()) && (predicateXPathFragment = predicate.getXPathFragment()).isAttribute()) {
            this.attribute(predicateXPathFragment, namespaceResolver, predicate.getValue());
        }
    }

    protected String getNameForFragment(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortName();
        }
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI().length() > 0 && (prefix = this.getPrefixForFragment(xPathFragment)) != null && prefix.length() > 0) {
            return prefix + ":" + xPathFragment.getLocalName();
        }
        return xPathFragment.getLocalName();
    }

    protected byte[] getNameForFragmentBytes(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortNameBytes();
        }
        String name = xPathFragment.getLocalName();
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI().length() > 0 && (prefix = this.getPrefixForFragment(xPathFragment)) != null && prefix.length() > 0) {
            name = prefix + ":" + xPathFragment.getLocalName();
        }
        byte[] bytes = null;
        try {
            bytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        return bytes;
    }

    protected String getPrefixForFragment(XPathFragment xPathFragment) {
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getPrefix();
        }
        String uri = xPathFragment.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return "";
        }
        String defaultNamespace = this.getNamespaceResolver().getDefaultNamespaceURI();
        if (defaultNamespace != null && defaultNamespace.equals(uri)) {
            return "";
        }
        String prefix = this.getNamespaceResolver().resolveNamespaceURI(uri);
        if (prefix != null) {
            return prefix;
        }
        for (Object next : this.getNamespaceResolver().getNamespaces()) {
            Namespace ns = (Namespace)next;
            uri = ns.getNamespaceURI();
            prefix = ns.getPrefix();
        }
        return xPathFragment.getPrefix();
    }

    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        StringBuilder qName = new StringBuilder(XMLConstants.ATTRIBUTE.charValue());
        qName.append(xsiPrefix).append(COLON_W_SCHEMA_NIL_ATTRIBUTE);
        XPathFragment nilFragment = new XPathFragment(qName.toString());
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartGroupingElements(groupingFragment);
    }

    protected String processNamespaceResolverForXSIPrefix(NamespaceResolver namespaceResolver) {
        String xsiPrefix;
        if (null == namespaceResolver) {
            xsiPrefix = "xsi";
            namespaceResolver = new NamespaceResolver();
            namespaceResolver.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            this.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (null == xsiPrefix) {
                xsiPrefix = namespaceResolver.generatePrefix("xsi");
                this.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        return xsiPrefix;
    }
}

