/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.FragmentContentHandler;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.PrefixMapperNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.FormattedOutputStreamRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.OutputStreamRecord;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLMarshaller
implements Cloneable {
    private static final String DEFAULT_XML_VERSION = "1.0";
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private XMLTransformer transformer;
    private XMLContext xmlContext;
    private XMLMarshalListener marshalListener;
    private XMLAttachmentMarshaller attachmentMarshaller;
    private ErrorHandler errorHandler;
    private Properties marshalProperties;
    private Schema schema;
    private NamespacePrefixMapper mapper;
    private String indentString;
    private CharacterEscapeHandler charEscapeHandler;
    private static final String STAX_RESULT_CLASS_NAME = "javax.xml.transform.stax.StAXResult";
    private static final String GET_XML_STREAM_WRITER_METHOD_NAME = "getXMLStreamWriter";
    private static final String GET_XML_EVENT_WRITER_METHOD_NAME = "getXMLEventWriter";
    private static final String XML_STREAM_WRITER_RECORD_CLASS_NAME = "org.eclipse.persistence.oxm.record.XMLStreamWriterRecord";
    private static final String XML_EVENT_WRITER_RECORD_CLASS_NAME = "org.eclipse.persistence.oxm.record.XMLEventWriterRecord";
    private static final String XML_STREAM_WRITER_CLASS_NAME = "javax.xml.stream.XMLStreamWriter";
    private static final String XML_EVENT_WRITER_CLASS_NAME = "javax.xml.stream.XMLEventWriter";
    private static final String DOM_TO_STREAM_WRITER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.DomToXMLStreamWriter";
    private static final String DOM_TO_EVENT_WRITER_CLASS_NAME = "org.eclipse.persistence.internal.oxm.record.DomToXMLEventWriter";
    private static final String WRITE_TO_STREAM_METHOD_NAME = "writeToStream";
    private static final String WRITE_TO_EVENT_WRITER_METHOD_NAME = "writeToEventWriter";
    private static Class staxResultClass;
    private static Method staxResultGetStreamWriterMethod;
    private static Method staxResultGetEventWriterMethod;
    private static Constructor xmlStreamWriterRecordConstructor;
    private static Constructor xmlEventWriterRecordConstructor;
    private static Method writeToStreamMethod;
    private static Method writeToEventWriterMethod;
    private static Class domToStreamWriterClass;
    private static Class domToEventWriterClass;

    public XMLMarshaller(XMLContext xmlContext) {
        this.setXMLContext(xmlContext);
        this.initialize();
    }

    private void initialize() {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.transformer = xmlPlatform.newXMLTransformer();
        this.setEncoding("UTF-8");
        this.setFormattedOutput(true);
        this.marshalProperties = new Properties();
        this.indentString = "   ";
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void setXMLContext(XMLContext value) {
        this.xmlContext = value;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isFormattedOutput() {
        return this.transformer.isFormattedOutput();
    }

    public void setFormattedOutput(boolean shouldFormat) {
        this.transformer.setFormattedOutput(shouldFormat);
    }

    public String getEncoding() {
        return this.transformer.getEncoding();
    }

    public void setEncoding(String newEncoding) {
        this.transformer.setEncoding(newEncoding);
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String newSchemaLocation) {
        this.schemaLocation = newSchemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public Properties getProperties() {
        return this.marshalProperties;
    }

    public Object getProperty(Object key) {
        return this.marshalProperties.get(key);
    }

    public void setNoNamespaceSchemaLocation(String newNoNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = newNoNamespaceSchemaLocation;
    }

    public void setXMLMarshalHandler(XMLMarshalListener marshalListener) {
        this.marshalListener = marshalListener;
    }

    public XMLMarshalListener getMarshalListener() {
        return this.marshalListener;
    }

    public void setMarshalListener(XMLMarshalListener listener) {
        this.marshalListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void marshal(Object object, Result result) throws XMLMarshalException {
        if (object == null || result == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean isXMLRoot = object instanceof XMLRoot;
        XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        AbstractSession session = this.xmlContext.getSession(xmlDescriptor);
        if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
            if (result instanceof DOMResult) {
                DOMResult domResult = (DOMResult)result;
                if (domResult.getNode() == null) {
                    domResult.setNode(this.objectToXML(object));
                    return;
                } else {
                    this.marshal(object, domResult.getNode());
                }
                return;
            }
            if (result instanceof SAXResult) {
                SAXResult saxResult = (SAXResult)result;
                this.marshal(object, saxResult.getHandler());
                return;
            }
            if (result instanceof StreamResult) {
                StreamResult streamResult = (StreamResult)result;
                Writer writer = streamResult.getWriter();
                if (writer != null) {
                    this.marshal(object, writer);
                    return;
                }
                if (streamResult.getOutputStream() != null) {
                    this.marshal(object, streamResult.getOutputStream());
                    return;
                }
                try {
                    File f;
                    try {
                        f = new File(new URL(streamResult.getSystemId()).toURI());
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            f = new File(streamResult.getSystemId());
                        }
                        catch (Exception e) {
                            throw malformedURLException;
                        }
                    }
                    writer = new FileWriter(f);
                    try {
                        this.marshal(object, writer);
                        Object var12_29 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_30 = null;
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                    return;
                }
                catch (Exception e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            if (result.getClass().equals(staxResultClass)) {
                try {
                    Object xmlStreamWriter = PrivilegedAccessHelper.invokeMethod(staxResultGetStreamWriterMethod, result);
                    if (xmlStreamWriter != null) {
                        MarshalRecord record = (MarshalRecord)PrivilegedAccessHelper.invokeConstructor(xmlStreamWriterRecordConstructor, new Object[]{xmlStreamWriter});
                        record.setMarshaller(this);
                        this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                        return;
                    }
                    Object xmlEventWriter = PrivilegedAccessHelper.invokeMethod(staxResultGetEventWriterMethod, result);
                    if (xmlEventWriter != null) {
                        MarshalRecord record = (MarshalRecord)PrivilegedAccessHelper.invokeConstructor(xmlEventWriterRecordConstructor, new Object[]{xmlEventWriter});
                        record.setMarshaller(this);
                        this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                        return;
                    }
                }
                catch (Exception e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            StringWriter writer = new StringWriter();
            this.marshal(object, writer);
            StreamSource source = new StreamSource(new StringReader(writer.toString()));
            this.transformer.transform(source, result);
            return;
        }
        try {
            Document document = null;
            document = isXMLRoot && session == null ? ((Node)((XMLRoot)object).getObject()).getOwnerDocument() : this.objectToXML(object, xmlDescriptor, isXMLRoot);
            if (result instanceof SAXResult && this.isFragment()) {
                FragmentContentHandler fragmentHandler = new FragmentContentHandler(((SAXResult)result).getHandler());
                if (isXMLRoot) {
                    String oldEncoding = this.transformer.getEncoding();
                    String oldVersion = this.transformer.getVersion();
                    if (((XMLRoot)object).getEncoding() != null) {
                        this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                    }
                    if (((XMLRoot)object).getXMLVersion() != null) {
                        this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                    }
                    this.transformer.transform((Node)document, fragmentHandler);
                    this.transformer.setEncoding(oldEncoding);
                    this.transformer.setVersion(oldVersion);
                    return;
                } else {
                    this.transformer.transform((Node)document, fragmentHandler);
                }
                return;
            }
            if (result.getClass().equals(staxResultClass)) {
                try {
                    Object xmlStreamWriter = PrivilegedAccessHelper.invokeMethod(staxResultGetStreamWriterMethod, result);
                    if (xmlStreamWriter != null) {
                        Object domtostax = PrivilegedAccessHelper.newInstanceFromClass(domToStreamWriterClass);
                        PrivilegedAccessHelper.invokeMethod(writeToStreamMethod, domtostax, new Object[]{document, xmlStreamWriter});
                        return;
                    }
                    Object xmlEventWriter = PrivilegedAccessHelper.invokeMethod(staxResultGetEventWriterMethod, result);
                    if (xmlEventWriter != null) {
                        Object domToEventWriter = PrivilegedAccessHelper.newInstanceFromClass(domToEventWriterClass);
                        PrivilegedAccessHelper.invokeMethod(writeToEventWriterMethod, domToEventWriter, new Object[]{document, xmlEventWriter});
                        return;
                    }
                }
                catch (Exception e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            if (isXMLRoot) {
                String oldEncoding = this.transformer.getEncoding();
                String oldVersion = this.transformer.getVersion();
                if (((XMLRoot)object).getEncoding() != null) {
                    this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                }
                if (((XMLRoot)object).getXMLVersion() != null) {
                    this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                }
                this.transformer.transform((Node)document, result);
                this.transformer.setEncoding(oldEncoding);
                this.transformer.setVersion(oldVersion);
                return;
            } else {
                this.transformer.transform((Node)document, result);
            }
            return;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, OutputStream outputStream) throws XMLMarshalException {
        block16: {
            if (object == null || outputStream == null) {
                throw XMLMarshalException.nullArgumentException();
            }
            try {
                isXMLRoot = false;
                version = "1.0";
                encoding = this.getEncoding();
                if (object instanceof XMLRoot) {
                    isXMLRoot = true;
                    xroot = (XMLRoot)object;
                    version = xroot.getXMLVersion() != null ? xroot.getXMLVersion() : version;
                    v0 = encoding = xroot.getEncoding() != null ? xroot.getEncoding() : encoding;
                }
                if (encoding.equals("UTF-8")) {
                    session = null;
                    xmlDescriptor = null;
                    if (isXMLRoot) {
                        try {
                            session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                            if (session == null) ** GOTO lbl26
                            xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
                        }
                        catch (XMLMarshalException marshalException) {
                            if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl26
                            throw marshalException;
                        }
                    } else {
                        session = this.xmlContext.getSession(object.getClass());
                        xmlDescriptor = this.getDescriptor(object.getClass(), session);
                    }
lbl26:
                    // 4 sources

                    record = this.isFormattedOutput() != false ? new FormattedOutputStreamRecord() : new OutputStreamRecord();
                    record.setMarshaller(this);
                    record.setOutputStream(outputStream);
                    if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
                        this.marshal(object, record, session, xmlDescriptor, isXMLRoot);
                    } else {
                        try {
                            xmlDocument = null;
                            xmlDocument = isXMLRoot != false && session == null ? (Node)((XMLRoot)object).getObject() : this.objectToXMLNode(object, session, xmlDescriptor, isXMLRoot);
                            record.setSession(session);
                            if (this.isFragment()) {
                                record.node(xmlDocument, xmlDescriptor.getNamespaceResolver());
                            } else {
                                record.startDocument(encoding, version);
                                record.node(xmlDocument, record.getNamespaceResolver());
                                record.endDocument();
                            }
                        }
                        catch (XMLPlatformException e) {
                            throw XMLMarshalException.marshalException(e);
                        }
                    }
                    record.flush();
                    break block16;
                }
                writer = new OutputStreamWriter(outputStream, encoding);
                this.marshal(object, writer);
                writer.flush();
            }
            catch (UnsupportedEncodingException exception) {
                throw XMLMarshalException.marshalException(exception);
            }
            catch (Exception ex) {
                throw XMLMarshalException.marshalException(ex);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, Writer writer) throws XMLMarshalException {
        if (object == null || writer == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        isXMLRoot = false;
        version = "1.0";
        encoding = this.getEncoding();
        if (object instanceof XMLRoot) {
            isXMLRoot = true;
            xroot = (XMLRoot)object;
            version = xroot.getXMLVersion() != null ? xroot.getXMLVersion() : version;
            encoding = xroot.getEncoding() != null ? xroot.getEncoding() : encoding;
        }
        session = null;
        xmlDescriptor = null;
        if (isXMLRoot) {
            try {
                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                if (session == null) ** GOTO lbl24
                xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl24
                throw marshalException;
            }
        } else {
            session = this.xmlContext.getSession(object.getClass());
            xmlDescriptor = this.getDescriptor(object.getClass(), session);
        }
lbl24:
        // 4 sources

        writerRecord = this.isFormattedOutput() != false ? new FormattedWriterRecord() : new WriterRecord();
        writerRecord.setMarshaller(this);
        writer = new BufferedWriter(writer);
        writerRecord.setWriter(writer);
        if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
            this.marshal(object, writerRecord, session, xmlDescriptor, isXMLRoot);
        } else {
            try {
                xmlDocument = null;
                xmlDocument = isXMLRoot != false && session == null ? (Node)((XMLRoot)object).getObject() : this.objectToXMLNode(object, session, xmlDescriptor, isXMLRoot);
                writerRecord.setSession(session);
                if (this.isFragment()) {
                    writerRecord.node(xmlDocument, xmlDescriptor.getNamespaceResolver());
                } else {
                    writerRecord.startDocument(encoding, version);
                    writerRecord.node(xmlDocument, writerRecord.getNamespaceResolver());
                    writerRecord.endDocument();
                }
            }
            catch (XMLPlatformException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws XMLMarshalException {
        this.marshal(object, contentHandler, null);
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XMLMarshalException {
        if (object == null || contentHandler == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        isXMLRoot = object instanceof XMLRoot;
        session = null;
        xmlDescriptor = null;
        if (isXMLRoot) {
            try {
                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                if (session == null) ** GOTO lbl17
                xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl17
                throw marshalException;
            }
        } else {
            session = this.xmlContext.getSession(object.getClass());
            xmlDescriptor = this.getDescriptor(object.getClass(), session);
        }
lbl17:
        // 4 sources

        if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
            contentHandlerRecord = new ContentHandlerRecord();
            contentHandlerRecord.setMarshaller(this);
            contentHandlerRecord.setContentHandler(contentHandler);
            contentHandlerRecord.setLexicalHandler(lexicalHandler);
            this.marshal(object, contentHandlerRecord, session, xmlDescriptor, isXMLRoot);
            return;
        }
        try {
            xmlDocument = null;
            xmlDocument = session == null ? (Node)((XMLRoot)object).getObject() : this.objectToXML(object, xmlDescriptor, isXMLRoot);
            reader = new DOMReader();
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            if (this.isFragment()) {
                fragmentHandler = new FragmentContentHandler(contentHandler);
                reader.setContentHandler(fragmentHandler);
            } else {
                reader.setContentHandler(contentHandler);
            }
            reader.parse(xmlDocument);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.marshalException(e);
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
        }
        catch (SAXException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, Node node) throws XMLMarshalException {
        if (object == null || node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            isXMLRoot = object instanceof XMLRoot;
            session = null;
            xmlDescriptor = null;
            if (isXMLRoot) {
                try {
                    session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                    if (session == null) ** GOTO lbl18
                    xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
                }
                catch (XMLMarshalException marshalException) {
                    if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl18
                    throw marshalException;
                }
            } else {
                session = this.xmlContext.getSession(object.getClass());
                xmlDescriptor = this.getDescriptor(object.getClass(), session);
            }
lbl18:
            // 4 sources

            if (!(isXMLRoot && ((XMLRoot)object).getObject() instanceof Node || session != null && this.xmlContext.getDocumentPreservationPolicy(session).shouldPreserveDocument())) {
                nodeRecord = new NodeRecord(node);
                nodeRecord.setMarshaller(this);
                if (!isXMLRoot && null == xmlDescriptor.getDefaultRootElement() && node.getNodeType() == 1 && xmlDescriptor.getSchemaReference() != null && xmlDescriptor.getSchemaReference().getType() == 1) {
                    typeAttr = ((Element)node).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (typeAttr == null) {
                        namespaceResolver = xmlDescriptor.getNamespaceResolver();
                        xsiPrefix = null;
                        if (null == namespaceResolver) {
                            namespaceResolver = new NamespaceResolver();
                            xmlDescriptor.setNamespaceResolver(namespaceResolver);
                        } else {
                            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                        }
                        if (null == xsiPrefix) {
                            xsiPrefix = namespaceResolver.generatePrefix("xsi");
                        }
                        value = xmlDescriptor.getSchemaReference().getSchemaContext();
                        ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
                        ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", xsiPrefix + ':' + "type", value);
                    } else {
                        value = xmlDescriptor.getSchemaReference().getSchemaContext();
                        typeAttr.setValue(value);
                    }
                }
                this.marshal(object, nodeRecord, session, xmlDescriptor, isXMLRoot);
                return;
            }
            doc = null;
            doc = isXMLRoot != false && session == null ? (Node)((XMLRoot)object).getObject() : this.objectToXMLNode(object, node, session, xmlDescriptor, isXMLRoot);
            result = new DOMResult(node);
            if (isXMLRoot) {
                oldEncoding = this.transformer.getEncoding();
                oldVersion = this.transformer.getVersion();
                if (((XMLRoot)object).getEncoding() != null) {
                    this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                }
                if (((XMLRoot)object).getXMLVersion() != null) {
                    this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                }
                this.transformer.transform(doc, (Result)result);
                if (oldEncoding != null) {
                    this.transformer.setEncoding(oldEncoding);
                }
                if (oldVersion != null) {
                    this.transformer.setVersion(oldVersion);
                }
            } else {
                this.transformer.transform(doc, (Result)result);
            }
        }
        catch (Exception exception) {
            if (exception instanceof XMLMarshalException) {
                throw (XMLMarshalException)exception;
            }
            throw XMLMarshalException.marshalException(exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void marshal(Object object, MarshalRecord marshalRecord) {
        isXMLRoot = object instanceof XMLRoot;
        session = null;
        xmlDescriptor = null;
        if (isXMLRoot) {
            try {
                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                if (session == null) ** GOTO lbl15
                xmlDescriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl15
                throw marshalException;
            }
        } else {
            session = this.xmlContext.getSession(object);
            xmlDescriptor = this.getDescriptor(object, session);
        }
lbl15:
        // 4 sources

        this.marshal(object, marshalRecord, session, xmlDescriptor, isXMLRoot);
    }

    protected void marshal(Object object, AbstractSession session, MarshalRecord marshalRecord) {
        boolean isXMLRoot = object instanceof XMLRoot;
        this.marshal(object, marshalRecord, session, this.getDescriptor(object, isXMLRoot), isXMLRoot);
    }

    private void marshal(Object object, MarshalRecord marshalRecord, AbstractSession session, XMLDescriptor descriptor, boolean isXMLRoot) {
        if (null != this.schema) {
            marshalRecord = new ValidatingMarshalRecord(marshalRecord, this);
        }
        if (this.getAttachmentMarshaller() != null) {
            marshalRecord.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
        }
        marshalRecord.setMarshaller(this);
        if (this.mapper == null) {
            this.addDescriptorNamespacesToXMLRecord(descriptor, marshalRecord);
        } else if (this.mapper != null) {
            if (descriptor == null) {
                marshalRecord.setNamespaceResolver(new PrefixMapperNamespaceResolver(this.mapper, null));
            } else {
                marshalRecord.setNamespaceResolver(new PrefixMapperNamespaceResolver(this.mapper, descriptor.getNamespaceResolver()));
            }
            marshalRecord.setCustomNamespaceMapper(true);
        }
        NamespaceResolver nr = marshalRecord.getNamespaceResolver();
        XMLRoot root = null;
        if (isXMLRoot) {
            root = (XMLRoot)object;
        }
        marshalRecord.beforeContainmentMarshal(object);
        if (!this.isFragment()) {
            String encoding = this.getEncoding();
            String version = DEFAULT_XML_VERSION;
            if (!isXMLRoot && descriptor != null) {
                marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
            } else {
                if (root.getEncoding() != null) {
                    encoding = root.getEncoding();
                }
                if (root.getXMLVersion() != null) {
                    version = root.getXMLVersion();
                }
            }
            marshalRecord.startDocument(encoding, version);
        }
        if (isXMLRoot && root.getObject() instanceof Node) {
            marshalRecord.node((Node)root.getObject(), new NamespaceResolver());
            marshalRecord.endDocument();
            return;
        }
        XPathFragment rootFragment = this.buildRootFragment(object, descriptor, isXMLRoot, marshalRecord);
        String schemaLocation = this.getSchemaLocation();
        String noNsSchemaLocation = this.getNoNamespaceSchemaLocation();
        boolean isNil = false;
        if (isXMLRoot) {
            object = root.getObject();
            if (root.getSchemaLocation() != null) {
                schemaLocation = root.getSchemaLocation();
            }
            if (root.getNoNamespaceSchemaLocation() != null) {
                noNsSchemaLocation = root.getNoNamespaceSchemaLocation();
            }
            marshalRecord.setLeafElementType(root.getSchemaType());
            isNil = root.isNil();
        }
        String xsiPrefix = null;
        if ((null != this.getSchemaLocation() || null != this.getNoNamespaceSchemaLocation() || isNil) && null == (xsiPrefix = nr.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance"))) {
            xsiPrefix = "xsi";
            nr.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        TreeObjectBuilder treeObjectBuilder = null;
        if (descriptor != null) {
            treeObjectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
        }
        if (session == null) {
            session = (AbstractSession)((Object)this.xmlContext.getSession(0));
        }
        marshalRecord.setSession(session);
        if (null != rootFragment) {
            marshalRecord.startPrefixMappings(nr);
            if (!isXMLRoot && descriptor != null && descriptor.getNamespaceResolver() == null && rootFragment.hasNamespace()) {
                throw XMLMarshalException.namespaceResolverNotSpecified(rootFragment.getShortName());
            }
            marshalRecord.openStartElement(rootFragment, nr);
            if (null != schemaLocation) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", xsiPrefix + ':' + "schemaLocation", schemaLocation);
            }
            if (null != noNsSchemaLocation) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", xsiPrefix + ':' + "noNamespaceSchemaLocation", noNsSchemaLocation);
            }
            if (isNil) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", xsiPrefix + ':' + "nil", "true");
            }
            marshalRecord.namespaceDeclarations(nr);
            if (descriptor != null && !isNil) {
                treeObjectBuilder.addXsiTypeAndClassIndicatorIfRequired(marshalRecord, descriptor, null, descriptor.getDefaultRootElementField(), root, object, isXMLRoot, true);
                treeObjectBuilder.marshalAttributes(marshalRecord, object, session);
            }
            marshalRecord.closeStartElement();
        }
        if (treeObjectBuilder != null && !isNil) {
            treeObjectBuilder.buildRow(marshalRecord, object, session, this, rootFragment, DatabaseMapping.WriteType.UNDEFINED);
        } else if (isXMLRoot && object != null && !isNil) {
            QName type;
            if (root.getDeclaredType() != null && root.getObject() != null && root.getDeclaredType() != root.getObject().getClass() && (type = (QName)XMLConversionManager.getDefaultJavaTypes().get(object.getClass())) != null) {
                xsiPrefix = nr.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                if (null == xsiPrefix) {
                    xsiPrefix = "xsi";
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
                }
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "xsd", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ":" + "type", "xsd:" + type.getLocalPart());
            }
            String value = (String)XMLConversionManager.getDefaultXMLManager().convertObject(object, String.class, root.getSchemaType());
            marshalRecord.characters(value);
        }
        if (null != rootFragment) {
            marshalRecord.endElement(rootFragment, nr);
            marshalRecord.endPrefixMappings(nr);
        }
        if (!this.isFragment()) {
            marshalRecord.endDocument();
        }
        marshalRecord.afterContainmentMarshal(null, object);
    }

    private XPathFragment buildRootFragment(Object object, XMLDescriptor descriptor, boolean isXMLRoot, MarshalRecord marshalRecord) {
        XPathFragment rootFragment = null;
        if (isXMLRoot) {
            String xmlRootUri = ((XMLRoot)object).getNamespaceURI();
            String xmlRootLocalName = ((XMLRoot)object).getLocalName();
            rootFragment = new XPathFragment();
            rootFragment.setLocalName(xmlRootLocalName);
            rootFragment.setNamespaceURI(xmlRootUri);
            if (xmlRootUri != null) {
                if (descriptor != null) {
                    String xmlRootPrefix = marshalRecord.getNamespaceResolver().resolveNamespaceURI(xmlRootUri);
                    if (xmlRootPrefix == null && !xmlRootUri.equals(marshalRecord.getNamespaceResolver().getDefaultNamespaceURI())) {
                        xmlRootPrefix = marshalRecord.getNamespaceResolver().generatePrefix();
                        marshalRecord.getNamespaceResolver().put(xmlRootPrefix, xmlRootUri);
                    }
                    if (xmlRootPrefix == null) {
                        rootFragment.setXPath(xmlRootLocalName);
                    } else {
                        rootFragment.setPrefix(xmlRootPrefix);
                    }
                } else {
                    String xmlRootPrefix = "ns0";
                    marshalRecord.getNamespaceResolver().put(xmlRootPrefix, xmlRootUri);
                    rootFragment.setXPath(xmlRootPrefix + ':' + xmlRootLocalName);
                }
            }
        } else {
            XMLField defaultRootField = descriptor.getDefaultRootElementField();
            if (defaultRootField != null) {
                rootFragment = defaultRootField.getXPathFragment();
            }
        }
        return rootFragment;
    }

    private boolean isSimpleXMLRoot(XMLRoot xmlRoot) {
        Class<?> xmlRootObjectClass = xmlRoot.getObject().getClass();
        if (XMLConversionManager.getDefaultJavaTypes().get(xmlRootObjectClass) != null || ClassConstants.List_Class.isAssignableFrom(xmlRootObjectClass) || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(xmlRootObjectClass) || ClassConstants.DURATION.isAssignableFrom(xmlRootObjectClass)) {
            return true;
        }
        return xmlRoot.getObject() instanceof Node;
    }

    public Document objectToXML(Object object) throws XMLMarshalException {
        boolean isXMLRoot = object instanceof XMLRoot;
        XMLDescriptor xmlDescriptor = this.getDescriptor(object, isXMLRoot);
        return this.objectToXML(object, xmlDescriptor, isXMLRoot);
    }

    protected Document objectToXML(Object object, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        AbstractSession session = this.xmlContext.getSession(descriptor);
        DocumentPreservationPolicy docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            XMLRecord xmlRow = null;
            if (!isXMLRoot) {
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(session));
                xmlRow.setMarshaller(this);
                if (this.getAttachmentMarshaller() != null) {
                    xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
                }
                this.addDescriptorNamespacesToXMLRecord(descriptor, xmlRow);
            }
            return this.objectToXML(object, descriptor, xmlRow, isXMLRoot, docPresPolicy);
        }
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    protected Node objectToXMLNode(Object object, AbstractSession session, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        return this.objectToXMLNode(object, null, session, descriptor, isXMLRoot);
    }

    protected Node objectToXMLNode(Object object, Node rootNode, AbstractSession session, XMLDescriptor descriptor, boolean isXMLRoot) throws XMLMarshalException {
        DocumentPreservationPolicy docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            XMLRecord xmlRow = null;
            if (!isXMLRoot) {
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(session));
                xmlRow.setMarshaller(this);
                if (this.getAttachmentMarshaller() != null) {
                    xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
                }
                if (xmlRow.getDOM().getNodeType() == 1) {
                    this.addDescriptorNamespacesToXMLRecord(descriptor, xmlRow);
                }
            }
            Document doc = this.objectToXML(object, rootNode, descriptor, xmlRow, isXMLRoot, docPresPolicy);
            if (xmlRow != null && xmlRow.getDOM().getNodeType() == 11) {
                return xmlRow.getDOM();
            }
            return doc;
        }
        NodeRecord marshalRecord = new NodeRecord();
        marshalRecord.setMarshaller(this);
        marshalRecord.getNamespaceResolver().setDOM(rootNode);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return ((MarshalRecord)marshalRecord).getDocument();
    }

    private void addDescriptorNamespacesToXMLRecord(XMLDescriptor xmlDescriptor, XMLRecord record) {
        if (null == xmlDescriptor) {
            return;
        }
        this.copyNamespaces(xmlDescriptor.getNamespaceResolver(), record.getNamespaceResolver());
    }

    private void copyNamespaces(NamespaceResolver source, NamespaceResolver target) {
        if (null != source && null != target) {
            if (source.hasPrefixesToNamespaces()) {
                target.getPrefixesToNamespaces().putAll(source.getPrefixesToNamespaces());
            }
            target.setDefaultNamespaceURI(source.getDefaultNamespaceURI());
        }
    }

    public Document objectToXML(Object object, Node parent) throws XMLMarshalException {
        return this.objectToXML(object, parent, null);
    }

    /*
     * Unable to fully structure code
     */
    public Document objectToXML(Object object, Node parent, DocumentPreservationPolicy docPresPolicy) {
        isXMLRoot = object instanceof XMLRoot;
        session = null;
        descriptor = null;
        if (isXMLRoot) {
            try {
                session = this.xmlContext.getSession(((XMLRoot)object).getObject());
                if (session == null) ** GOTO lbl15
                descriptor = this.getDescriptor(((XMLRoot)object).getObject(), session);
            }
            catch (XMLMarshalException marshalException) {
                if (this.isSimpleXMLRoot((XMLRoot)object)) ** GOTO lbl15
                throw marshalException;
            }
        } else {
            session = this.xmlContext.getSession(object);
            descriptor = this.getDescriptor(object, session);
        }
lbl15:
        // 4 sources

        localRootName = descriptor.getDefaultRootElement();
        if (null == localRootName) {
            throw XMLMarshalException.defaultRootElementNotSpecified(descriptor);
        }
        if (docPresPolicy == null) {
            docPresPolicy = this.xmlContext.getDocumentPreservationPolicy(session);
        }
        if (docPresPolicy != null && docPresPolicy.shouldPreserveDocument()) {
            xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecord(localRootName, parent, session);
            xmlRow.setMarshaller(this);
            if (this.getAttachmentMarshaller() != null) {
                xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
            }
            return this.objectToXML(object, descriptor, xmlRow, isXMLRoot, docPresPolicy);
        }
        marshalRecord = new NodeRecord(localRootName, parent);
        marshalRecord.setMarshaller(this);
        this.marshal(object, marshalRecord, session, descriptor, isXMLRoot);
        return marshalRecord.getDocument();
    }

    public Document objectToXML(Object object, XMLDescriptor descriptor, XMLRecord xmlRow, boolean isXMLRoot, DocumentPreservationPolicy docPresPolicy) {
        return this.objectToXML(object, null, descriptor, xmlRow, isXMLRoot, docPresPolicy);
    }

    public Document objectToXML(Object object, Node rootNode, XMLDescriptor descriptor, XMLRecord xmlRow, boolean isXMLRoot, DocumentPreservationPolicy docPresPolicy) {
        short rootNodeType;
        if (null != rootNode && (rootNodeType = rootNode.getNodeType()) != 9 && rootNodeType != 1 && rootNodeType != 11) {
            throw XMLMarshalException.marshalException(null);
        }
        Document document = null;
        NamespaceResolver resolver = new NamespaceResolver();
        resolver.setDOM(rootNode);
        this.copyNamespaces(descriptor.getNamespaceResolver(), resolver);
        boolean shouldCallSetAttributeNS = false;
        boolean isRootDocumentFragment = false;
        AbstractSession session = this.xmlContext.getSession(descriptor);
        if (xmlRow != null) {
            isRootDocumentFragment = xmlRow.getDOM().getNodeType() == 11;
        }
        Object originalObject = object;
        if (isXMLRoot) {
            String xmlRootUri = ((XMLRoot)object).getNamespaceURI();
            String xmlRootPrefix = null;
            if (xmlRow == null) {
                String recordName = ((XMLRoot)object).getLocalName();
                if (xmlRootUri != null) {
                    xmlRootPrefix = resolver.resolveNamespaceURI(xmlRootUri);
                    if (xmlRootPrefix == null && !xmlRootUri.equals(resolver.getDefaultNamespaceURI())) {
                        xmlRootPrefix = resolver.generatePrefix();
                        resolver.put(xmlRootPrefix, xmlRootUri);
                        shouldCallSetAttributeNS = true;
                    }
                    if (xmlRootPrefix != null) {
                        recordName = xmlRootPrefix + ':' + recordName;
                    }
                }
                xmlRow = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecordFor(((XMLRoot)object).getObject(), docPresPolicy, recordName, xmlRootUri);
                xmlRow.setMarshaller(this);
                if (this.getAttachmentMarshaller() != null) {
                    xmlRow.setXOPPackage(this.getAttachmentMarshaller().isXOPPackage());
                }
                if (!isRootDocumentFragment && shouldCallSetAttributeNS) {
                    if (xmlRootPrefix != null) {
                        ((Element)xmlRow.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + xmlRootPrefix, xmlRootUri);
                    }
                    shouldCallSetAttributeNS = false;
                }
            }
            this.copyNamespaces(resolver, xmlRow.getNamespaceResolver());
            document = xmlRow.getDocument();
            Element docElement = document.getDocumentElement();
            object = ((XMLRoot)object).getObject();
        }
        XMLObjectBuilder bldr = (XMLObjectBuilder)descriptor.getObjectBuilder();
        AbstractSession objectSession = this.xmlContext.getSession(object);
        xmlRow.setSession(objectSession);
        bldr.addXsiTypeAndClassIndicatorIfRequired(xmlRow, descriptor, null, null, originalObject, object, isXMLRoot, true);
        xmlRow = (XMLRecord)bldr.buildRow((AbstractRecord)xmlRow, object, objectSession, isXMLRoot);
        xmlRow.setMarshaller(this);
        if (shouldCallSetAttributeNS && !isRootDocumentFragment) {
            ((Element)xmlRow.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        document = xmlRow.getDocument();
        this.addSchemaLocations(document, session);
        return document;
    }

    private void addSchemaLocations(Document document, AbstractSession session) {
        XMLField field;
        Element docElement = document.getDocumentElement();
        NamespaceResolver resolver = new NamespaceResolver();
        resolver.put("xmlns", "http://www.w3.org/2000/xmlns/");
        resolver.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.getSchemaLocation() != null || this.getNoNamespaceSchemaLocation() != null) {
            field = new XMLField("@xmlns:xsi");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, "http://www.w3.org/2001/XMLSchema-instance", session);
        }
        if (this.getSchemaLocation() != null) {
            field = new XMLField("@xsi:schemaLocation");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, this.getSchemaLocation(), session);
        }
        if (this.getNoNamespaceSchemaLocation() != null) {
            field = new XMLField("@xsi:noNamespaceSchemaLocation");
            field.setNamespaceResolver(resolver);
            XPathEngine.getInstance().create(field, docElement, this.getNoNamespaceSchemaLocation(), session);
        }
    }

    protected XMLDescriptor getDescriptor(Object object) throws XMLMarshalException {
        XMLDescriptor descriptor = (XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    protected XMLDescriptor getDescriptor(Object object, AbstractSession session) throws XMLMarshalException {
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(object);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    private XMLDescriptor getDescriptor(Class clazz, AbstractSession session) throws XMLMarshalException {
        XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(clazz);
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }
        return descriptor;
    }

    protected XMLDescriptor getDescriptor(Object object, boolean isXMLRoot) {
        if (isXMLRoot) {
            return this.getDescriptor((XMLRoot)object);
        }
        return this.getDescriptor(object);
    }

    protected XMLDescriptor getDescriptor(Object object, AbstractSession session, boolean isXMLRoot) {
        if (isXMLRoot) {
            return this.getDescriptor((XMLRoot)object, session);
        }
        return this.getDescriptor(object, session);
    }

    protected XMLDescriptor getDescriptor(XMLRoot object) throws XMLMarshalException {
        XMLDescriptor descriptor = null;
        try {
            AbstractSession session = this.xmlContext.getSession(object.getObject());
            if (null == session) {
                return null;
            }
            descriptor = (XMLDescriptor)session.getDescriptor(object.getObject());
        }
        catch (XMLMarshalException marshalException) {
            if (descriptor == null && this.isSimpleXMLRoot(object)) {
                return null;
            }
            throw marshalException;
        }
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    protected XMLDescriptor getDescriptor(XMLRoot object, AbstractSession session) throws XMLMarshalException {
        XMLDescriptor descriptor = null;
        try {
            if (null == session) {
                return null;
            }
            descriptor = (XMLDescriptor)session.getDescriptor(object.getObject());
        }
        catch (XMLMarshalException marshalException) {
            if (descriptor == null && this.isSimpleXMLRoot(object)) {
                return null;
            }
            throw marshalException;
        }
        if (descriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return descriptor;
    }

    public void setFragment(boolean fragment) {
        this.transformer.setFragment(fragment);
    }

    public boolean isFragment() {
        return this.transformer.isFragment();
    }

    public void setAttachmentMarshaller(XMLAttachmentMarshaller atm) {
        this.attachmentMarshaller = atm;
    }

    public XMLAttachmentMarshaller getAttachmentMarshaller() {
        return this.attachmentMarshaller;
    }

    public XMLTransformer getTransformer() {
        return this.transformer;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public XMLMarshaller clone() {
        XMLMarshaller clone = new XMLMarshaller(this.xmlContext);
        clone.setAttachmentMarshaller(this.attachmentMarshaller);
        clone.setEncoding(this.getEncoding());
        clone.setFormattedOutput(this.isFormattedOutput());
        clone.setFragment(this.isFragment());
        clone.setMarshalListener(this.marshalListener);
        clone.setNoNamespaceSchemaLocation(this.noNamespaceSchemaLocation);
        for (Map.Entry<Object, Object> entry : this.marshalProperties.entrySet()) {
            clone.getProperties().put(entry.getKey(), entry.getValue());
        }
        if (null != this.schema) {
            clone.setSchema(this.schema);
        }
        clone.setSchemaLocation(this.schemaLocation);
        return clone;
    }

    public void setNamespacePrefixMapper(NamespacePrefixMapper mapper) {
        this.mapper = mapper;
    }

    public NamespacePrefixMapper getNamespacePrefixMapper() {
        return this.mapper;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String s) {
        this.indentString = s;
    }

    public CharacterEscapeHandler getCharacterEscapeHandler() {
        return this.charEscapeHandler;
    }

    public void setCharacterEscapeHandler(CharacterEscapeHandler c) {
        this.charEscapeHandler = c;
    }

    static {
        try {
            staxResultClass = PrivilegedAccessHelper.getClassForName(STAX_RESULT_CLASS_NAME);
            if (staxResultClass != null) {
                staxResultGetStreamWriterMethod = PrivilegedAccessHelper.getDeclaredMethod(staxResultClass, GET_XML_STREAM_WRITER_METHOD_NAME, new Class[0]);
                staxResultGetEventWriterMethod = PrivilegedAccessHelper.getDeclaredMethod(staxResultClass, GET_XML_EVENT_WRITER_METHOD_NAME, new Class[0]);
            }
            Class streamWriterRecordClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_WRITER_RECORD_CLASS_NAME);
            Class streamWriterClass = PrivilegedAccessHelper.getClassForName(XML_STREAM_WRITER_CLASS_NAME);
            xmlStreamWriterRecordConstructor = PrivilegedAccessHelper.getConstructorFor(streamWriterRecordClass, new Class[]{streamWriterClass}, true);
            Class eventWriterRecordClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_WRITER_RECORD_CLASS_NAME);
            Class eventWriterClass = PrivilegedAccessHelper.getClassForName(XML_EVENT_WRITER_CLASS_NAME);
            xmlEventWriterRecordConstructor = PrivilegedAccessHelper.getConstructorFor(eventWriterRecordClass, new Class[]{eventWriterClass}, true);
            domToStreamWriterClass = PrivilegedAccessHelper.getClassForName(DOM_TO_STREAM_WRITER_CLASS_NAME);
            writeToStreamMethod = PrivilegedAccessHelper.getMethod(domToStreamWriterClass, WRITE_TO_STREAM_METHOD_NAME, new Class[]{ClassConstants.NODE, streamWriterClass}, true);
            domToEventWriterClass = PrivilegedAccessHelper.getClassForName(DOM_TO_EVENT_WRITER_CLASS_NAME);
            writeToEventWriterMethod = PrivilegedAccessHelper.getMethod(domToEventWriterClass, WRITE_TO_EVENT_WRITER_METHOD_NAME, new Class[]{ClassConstants.NODE, eventWriterClass}, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

