/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasLeftParenthesis;
    private boolean hasNot;
    private boolean hasRightParenthesis;
    private AbstractExpression inItems;

    InExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent, "IN");
        if (expression != null) {
            this.expression = expression;
            this.expression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
        this.getInItems().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
        children.add(this.getInItems());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.expression != null) {
            children.add(this.expression);
        }
        if (this.hasNot) {
            children.add(this.buildStringExpression(' '));
            children.add(this.buildStringExpression("NOT"));
        } else if (this.hasExpression()) {
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression("IN"));
        if (this.hasLeftParenthesis) {
            children.add(this.buildStringExpression('('));
        } else if (this.hasInItems()) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.inItems != null) {
            children.add(this.inItems);
        }
        if (this.hasRightParenthesis) {
            children.add(this.buildStringExpression(')'));
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(AbstractExpression expression) {
        if (this.expression == expression) {
            return InExpression.queryBNF("in_expression_expression");
        }
        if (this.inItems.isAncestor(expression)) {
            return InExpression.queryBNF("in_item");
        }
        return super.findQueryBNF(expression);
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getIdentifier() {
        return this.hasNot ? "NOT IN" : "IN";
    }

    public Expression getInItems() {
        if (this.inItems == null) {
            this.inItems = this.buildNullExpression();
        }
        return this.inItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return InExpression.queryBNF("in_expression");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasInItems() {
        return this.inItems != null && !this.inItems.isNull();
    }

    public boolean hasLeftParenthesis() {
        return this.hasLeftParenthesis;
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    public boolean hasRightParenthesis() {
        return this.hasRightParenthesis;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        this.hasNot = wordParser.startsWithIgnoreCase('N');
        if (this.hasNot) {
            wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        wordParser.moveForward("IN");
        int count = wordParser.skipLeadingWhitespace();
        this.hasLeftParenthesis = wordParser.startsWith('(');
        if (this.hasLeftParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
        }
        this.inItems = this.parse(wordParser, (JPQLQueryBNF)InExpression.queryBNF("in_item"), tolerant);
        if (this.hasInItems()) {
            count = wordParser.skipLeadingWhitespace();
        }
        this.hasRightParenthesis = wordParser.startsWith(')');
        if (this.hasRightParenthesis) {
            wordParser.moveForward(1);
        } else {
            wordParser.moveBackward(count);
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.hasExpression()) {
            this.expression.toParsedText(writer, includeVirtual);
        }
        if (this.hasExpression()) {
            writer.append(' ');
        }
        if (this.hasNot) {
            writer.append("NOT");
            writer.append(' ');
        }
        writer.append("IN");
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasInItems()) {
            writer.append(' ');
        }
        if (this.hasInItems()) {
            this.inItems.toParsedText(writer, includeVirtual);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
    }
}

