/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.osgi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.jpa.osgi.EMFBuilderServiceProxyHandler;
import org.eclipse.persistence.jpa.osgi.EMFServiceProxyHandler;
import org.eclipse.persistence.jpa.osgi.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
SynchronousBundleListener {
    public static final String MANIFEST_PU_LABEL = "JPA-PersistenceUnits";
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    public static final String ECLIPSELINK_OSGI_PROVIDER = "org.eclipse.persistence.jpa.osgi.PersistenceProviderOSGi";
    protected static BundleContext context;
    protected static PersistenceProvider osgiProvider;

    public static BundleContext getContext() {
        return context;
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                this.registerBundle(event.getBundle());
                break;
            }
            case 256: {
                this.deregisterBundle(event.getBundle());
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        String initializer = null;
        ServiceReference packageAdminRef = context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(packageAdminRef);
        Bundle[] fragments = packageAdmin.getFragments(context.getBundle());
        if (fragments != null) {
            for (int i = 0; i < fragments.length; ++i) {
                Bundle fragment = fragments[i];
                initializer = (String)fragment.getHeaders().get("JPA-Initializer");
                if (initializer == null) continue;
                AbstractSessionLog.getLog().log(4, LoggingLocalization.buildMessage((String)"osgi_initializer", (Object[])new Object[]{initializer}));
                break;
            }
        }
        osgiProvider = new PersistenceProvider(initializer);
        this.registerBundleListener();
    }

    private void registerBundleListener() {
        Activator.getContext().addBundleListener((BundleListener)this);
        Bundle[] bundles = Activator.getContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            this.registerBundle(bundle);
        }
    }

    private void registerBundle(Bundle bundle) {
        if ((bundle.getState() & 0x2C) != 0) {
            AbstractSessionLog.getLog().finest("EclipseLink OSGi - examining bundle: " + bundle.getSymbolicName() + "_" + bundle.getBundleId());
            if (!PersistenceProvider.includesBundle(bundle)) {
                try {
                    String[] persistenceUnitNames = this.getPersistenceUnitNames(bundle);
                    if (persistenceUnitNames != null) {
                        PersistenceProvider.addBundle(bundle, persistenceUnitNames);
                        this.registerEMFServices(persistenceUnitNames);
                    }
                }
                catch (Exception e) {
                    AbstractSessionLog.getLog().logThrowable(6, (Throwable)e);
                }
            }
        }
    }

    protected void registerEMFServices(String[] persistenceUnitNames) {
        for (String puName : persistenceUnitNames) {
            AbstractSessionLog.getLog().finest("EclipseLink OSGi - registering services for PU '" + puName + "'");
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("osgi.unit.name", puName);
            ((Dictionary)props).put("osgi.unit.provider", PersistenceProvider.class.getName());
            EMFServiceProxyHandler emfServiceProxyHandler = this.registerEMFService(puName, props);
            this.registerEMFBuilderService(emfServiceProxyHandler, puName, props);
        }
    }

    protected EMFServiceProxyHandler registerEMFService(String puName, Dictionary<String, String> props) {
        EMFServiceProxyHandler emfServiceProxyHandler = new EMFServiceProxyHandler((javax.persistence.spi.PersistenceProvider)osgiProvider, puName);
        Object emfServiceProxy = null;
        try {
            emfServiceProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManagerFactory.class}, (InvocationHandler)emfServiceProxyHandler);
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().finest("EclipseLink OSGi - Failed to create proxy for EMF service: " + e);
        }
        try {
            String[] serviceInterfaces = new String[]{EntityManagerFactory.class.getName()};
            context.registerService(serviceInterfaces, emfServiceProxy, props);
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().finest("EclipseLink OSGi could not register EMF service for " + puName + e);
        }
        AbstractSessionLog.getLog().finer("EclipseLink OSGi registered EMF service for " + puName);
        return emfServiceProxyHandler;
    }

    protected EMFBuilderServiceProxyHandler registerEMFBuilderService(EMFServiceProxyHandler emfServiceProxyHandler, String puName, Dictionary<String, String> props) {
        EMFBuilderServiceProxyHandler emfBuilderProxyHandler = new EMFBuilderServiceProxyHandler(osgiProvider, puName, emfServiceProxyHandler);
        Object emfBuilderServiceProxy = null;
        try {
            emfBuilderServiceProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManagerFactoryBuilder.class}, (InvocationHandler)emfBuilderProxyHandler);
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().finest("EclipseLink OSGi - Failed to create proxy for EMF builder service: " + e);
        }
        try {
            String[] serviceInterfaces = new String[]{EntityManagerFactoryBuilder.class.getName()};
            context.registerService(serviceInterfaces, emfBuilderServiceProxy, props);
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().finest("EclipseLink OSGi could not register EMF Builder service for " + puName + e);
        }
        AbstractSessionLog.getLog().finer("EclipseLink OSGi registered EMF Builder service for " + puName);
        return emfBuilderProxyHandler;
    }

    private String[] getPersistenceUnitNames(Bundle bundle) {
        String names = (String)bundle.getHeaders().get(MANIFEST_PU_LABEL);
        if (names != null) {
            String[] values = names.split(",");
            for (int index = 0; index < values.length; ++index) {
                values[index] = values[index].trim();
            }
            return values;
        }
        return null;
    }

    private void deregisterBundle(Bundle bundle) {
        PersistenceProvider.removeBundle(bundle);
    }

    public void stop(BundleContext context) throws Exception {
        Activator.getContext().removeBundleListener((BundleListener)this);
    }
}

