/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SubqueryNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.queries.ReportQuery;

public class ExistsNode
extends Node {
    private boolean notIndicated = false;

    public void validate(ParseTreeContext context) {
        if (this.left != null) {
            SubqueryNode subqueryNode = (SubqueryNode)this.getLeft();
            subqueryNode.validate(context);
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(typeHelper.getBooleanType());
        }
    }

    public Expression generateExpression(GenerationContext context) {
        SubqueryNode subqueryNode = (SubqueryNode)this.getLeft();
        ReportQuery reportQuery = subqueryNode.getReportQuery(context);
        List<ReportItem> items = reportQuery.getItems();
        for (ReportItem item : items) {
            Expression expr = item.getAttributeExpression();
            reportQuery.addNonFetchJoinedAttribute(expr);
        }
        reportQuery.clearItems();
        ConstantExpression one = new ConstantExpression(1, new ExpressionBuilder());
        reportQuery.addItem("one", one);
        reportQuery.dontUseDistinct();
        Expression expr = context.getBaseExpression();
        return this.notIndicated() ? expr.notExists(reportQuery) : expr.exists(reportQuery);
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }
}

