/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLChoiceFieldToClassAssociation;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLRootConverter;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceObjectMapping
extends DatabaseMapping
implements XMLMapping {
    private Map<XMLField, Class> fieldToClassMappings = new HashMap<XMLField, Class>();
    private Map<Class, XMLField> classToFieldMappings;
    private Map<XMLField, String> fieldToClassNameMappings = new HashMap<XMLField, String>();
    private Map<XMLField, XMLMapping> choiceElementMappings;
    private Map<XMLField, Converter> fieldsToConverters;

    public XMLChoiceObjectMapping() {
        this.classToFieldMappings = new HashMap<Class, XMLField>();
        this.choiceElementMappings = new HashMap<XMLField, XMLMapping>();
        this.fieldsToConverters = new HashMap<XMLField, Converter>();
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        return null;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) throws DescriptorException {
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector<DatabaseField> getFields() {
        return this.collectFields();
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(this.getFieldToClassMappings().keySet());
        return fields;
    }

    public void addChoiceElement(String xpath, Class elementType) {
        XMLField field = new XMLField(xpath);
        this.addChoiceElement(field, elementType);
    }

    public void addChoiceElement(String xpath, String elementTypeName, boolean xmlRoot) {
        XMLField field = new XMLField(xpath);
        this.fieldToClassNameMappings.put(field, elementTypeName);
        if (xmlRoot) {
            this.fieldsToConverters.put(field, new XMLRootConverter(field));
        }
    }

    public void addChoiceElement(String xpath, String elementTypeName) {
        this.addChoiceElement(xpath, elementTypeName, false);
    }

    public void addChoiceElement(XMLField xmlField, Class elementType) {
        this.getFieldToClassMappings().put(xmlField, elementType);
        this.fieldToClassNameMappings.put(xmlField, elementType.getName());
        if (this.classToFieldMappings.get(elementType) == null) {
            this.classToFieldMappings.put(elementType, xmlField);
        }
    }

    public void addChoiceElement(XMLField field, String elementTypeName) {
        this.fieldToClassNameMappings.put(field, elementTypeName);
    }

    public Map<XMLField, Class> getFieldToClassMappings() {
        return this.fieldToClassMappings;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.fieldToClassMappings.size() == 0) {
            this.convertClassNamesToClasses(((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).getLoader());
        }
        for (XMLField next : this.getFieldToClassMappings().keySet()) {
            DatabaseMapping xmlMapping;
            Converter converter = null;
            if (this.fieldsToConverters != null) {
                converter = this.fieldsToConverters.get(next);
            }
            if (next.getLastXPathFragment().nameIsText()) {
                xmlMapping = new XMLDirectMapping();
                xmlMapping.setAttributeName(this.getAttributeName());
                xmlMapping.setAttributeAccessor(this.getAttributeAccessor());
                ((AbstractDirectMapping)xmlMapping).setAttributeClassification(this.getFieldToClassMappings().get(next));
                XMLConversionManager xmlConversionManager = (XMLConversionManager)session.getDatasourcePlatform().getConversionManager();
                QName schemaType = (QName)xmlConversionManager.getDefaultJavaTypes().get(((AbstractDirectMapping)xmlMapping).getAttributeClassification());
                if (schemaType != null) {
                    next.setSchemaType(schemaType);
                }
                ((AbstractDirectMapping)xmlMapping).setField(next);
                xmlMapping.setDescriptor(this.getDescriptor());
                if (converter != null) {
                    ((AbstractDirectMapping)xmlMapping).setConverter(converter);
                }
                this.choiceElementMappings.put(next, (XMLMapping)((Object)xmlMapping));
                ((XMLDirectMapping)xmlMapping).initialize(session);
                continue;
            }
            xmlMapping = new XMLCompositeObjectMapping();
            xmlMapping.setAttributeName(this.getAttributeName());
            xmlMapping.setAttributeAccessor(this.getAttributeAccessor());
            ((AggregateMapping)xmlMapping).setReferenceClass(this.getFieldToClassMappings().get(next));
            ((AbstractCompositeObjectMapping)xmlMapping).setField(next);
            xmlMapping.setDescriptor(this.getDescriptor());
            if (converter != null) {
                ((AbstractCompositeObjectMapping)xmlMapping).setConverter(converter);
            }
            this.choiceElementMappings.put(next, (XMLMapping)((Object)xmlMapping));
            ((XMLCompositeObjectMapping)xmlMapping).initialize(session);
        }
    }

    public Map<Class, XMLField> getClassToFieldMappings() {
        return this.classToFieldMappings;
    }

    public Map<XMLField, XMLMapping> getChoiceElementMappings() {
        return this.choiceElementMappings;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (XMLField next : this.fieldToClassNameMappings.keySet()) {
            Class elementType;
            block6: {
                String className = this.fieldToClassNameMappings.get(next);
                elementType = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            elementType = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                        }
                    }
                    elementType = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
                }
            }
            this.addChoiceElement(next, elementType);
        }
    }

    public void addConverter(XMLField field, Converter converter) {
        if (this.fieldsToConverters == null) {
            this.fieldsToConverters = new HashMap<XMLField, Converter>();
        }
        this.fieldsToConverters.put(field, converter);
    }

    public ArrayList getChoiceFieldToClassAssociations() {
        ArrayList<XMLChoiceFieldToClassAssociation> associations = new ArrayList<XMLChoiceFieldToClassAssociation>();
        if (this.fieldToClassNameMappings.size() > 0) {
            for (XMLField xmlField : this.fieldToClassNameMappings.keySet()) {
                String className = this.fieldToClassNameMappings.get(xmlField);
                XMLChoiceFieldToClassAssociation association = new XMLChoiceFieldToClassAssociation(xmlField, className);
                associations.add(association);
            }
        }
        return associations;
    }

    public void setChoiceFieldToClassAssociations(ArrayList associations) {
        if (associations.size() > 0) {
            for (Object next : associations) {
                XMLChoiceFieldToClassAssociation association = (XMLChoiceFieldToClassAssociation)next;
                this.addChoiceElement(association.getXmlField(), association.getClassName());
                if (association.getConverter() == null || !(association.getConverter() instanceof Converter)) continue;
                this.addConverter(association.getXmlField(), association.getConverter());
            }
        }
    }
}

