/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

public class ManyToManyAccessor
extends CollectionAccessor {
    public ManyToManyAccessor() {
        super("<many-to-many>");
    }

    public ManyToManyAccessor(Annotation manyToMany, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(manyToMany, accessibleObject, classAccessor);
        this.setMappedBy((String)MetadataHelper.invokeMethod("mappedBy", manyToMany));
    }

    protected String getLoggingContext() {
        return "metadata_default_many_to_many_reference_class";
    }

    public boolean isManyToMany() {
        return true;
    }

    public boolean isPrivateOwned() {
        if (super.isPrivateOwned()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_private_owned", this);
        }
        return false;
    }

    public void process() {
        super.process();
        ManyToManyMapping mapping = new ManyToManyMapping();
        this.process((CollectionMapping)mapping);
        if (this.getMappedBy() == null || this.getMappedBy().equals("")) {
            this.processJoinTable(mapping);
        } else {
            mapping.setIsReadOnly(true);
            ManyToManyMapping ownerMapping = null;
            if (!this.getOwningMapping(this.getMappedBy()).isManyToManyMapping()) {
                throw ValidationException.invalidMapping((Class)this.getJavaClass(), (Class)this.getReferenceClass());
            }
            ownerMapping = (ManyToManyMapping)this.getOwningMapping(this.getMappedBy());
            mapping.setRelationTable(ownerMapping.getRelationTable());
            if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
                Vector<DatabaseField> targetKeyFields = new Vector<DatabaseField>();
                for (DatabaseField targetKeyField : ownerMapping.getTargetKeyFields()) {
                    DatabaseField newTargetKeyField = (DatabaseField)targetKeyField.clone();
                    newTargetKeyField.setTable(this.getDescriptor().getPrimaryTable());
                    targetKeyFields.add(newTargetKeyField);
                }
                mapping.setSourceKeyFields(targetKeyFields);
                Vector<DatabaseField> targetRelationKeyFields = new Vector<DatabaseField>();
                for (DatabaseField targetRelationKeyField : ownerMapping.getTargetRelationKeyFields()) {
                    DatabaseField newTargetRelationKeyField = (DatabaseField)targetRelationKeyField.clone();
                    newTargetRelationKeyField.setTable(this.getDescriptor().getPrimaryTable());
                    targetRelationKeyFields.add(newTargetRelationKeyField);
                }
                mapping.setSourceRelationKeyFields(targetRelationKeyFields);
            } else {
                mapping.setSourceKeyFields(ownerMapping.getTargetKeyFields());
                mapping.setSourceRelationKeyFields(ownerMapping.getTargetRelationKeyFields());
            }
            mapping.setTargetKeyFields(ownerMapping.getSourceKeyFields());
            mapping.setTargetRelationKeyFields(ownerMapping.getSourceRelationKeyFields());
        }
        this.processProperties((DatabaseMapping)mapping);
        this.getDescriptor().addMapping((DatabaseMapping)mapping);
    }
}

