/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public abstract class DatabaseObjectDefinition
implements Cloneable,
Serializable {
    public String name = "";
    public String qualifier = "";

    public abstract Writer buildCreationWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public abstract Writer buildDeletionWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public void createObject(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.createOnDatabase(session);
        } else {
            this.buildCreationWriter(session, schemaWriter);
        }
    }

    public void createOnDatabase(AbstractSession session) throws EclipseLinkException {
        session.executeNonSelectingCall(new SQLCall(this.buildCreationWriter(session, new StringWriter()).toString()));
    }

    public void dropFromDatabase(AbstractSession session) throws EclipseLinkException {
        session.executeNonSelectingCall(new SQLCall(this.buildDeletionWriter(session, new StringWriter()).toString()));
    }

    public void dropObject(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropFromDatabase(session);
        } else {
            this.buildDeletionWriter(session, schemaWriter);
        }
    }

    public String getFullName() {
        if (this.getQualifier().equals("")) {
            return this.getName();
        }
        return this.getQualifier() + "." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getFullName() + ")";
    }
}

