/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.broker;

import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.SessionBrokerIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;

public class SessionBroker
extends DatabaseSessionImpl {
    protected SessionBroker parent;
    protected Map sessionNamesByClass;
    protected Map sessionsByName = new HashMap(2);
    protected Sequencing sequencing;

    public SessionBroker() {
        super(new DatabaseLogin());
        this.sessionNamesByClass = new HashMap(2);
    }

    protected SessionBroker(Map sessionNames) {
        super(new DatabaseLogin());
        this.sessionNamesByClass = sessionNames;
    }

    public SessionBroker acquireClientSessionBroker() {
        this.log(2, "connection", "acquire_client_session_broker");
        SessionBroker clientBroker = this.copySessionBroker();
        clientBroker.parent = this;
        clientBroker.getIdentityMapAccessorInstance().setIdentityMapManager(this.getIdentityMapAccessorInstance().getIdentityMapManager());
        clientBroker.commitManager = this.getCommitManager();
        clientBroker.commandManager = this.getCommandManager();
        clientBroker.externalTransactionController = this.getExternalTransactionController();
        clientBroker.setServerPlatform(this.getServerPlatform());
        for (String sessionName : this.getSessionsByName().keySet()) {
            AbstractSession ssession = this.getSessionForName(sessionName);
            if (ssession instanceof ServerSession) {
                if (ssession.getProject().hasIsolatedClasses()) {
                    throw ValidationException.isolatedDataNotSupportedInSessionBroker(sessionName);
                }
                clientBroker.internalRegisterSession(sessionName, ((ServerSession)ssession).acquireClientSession());
                continue;
            }
            throw ValidationException.cannotAcquireClientSessionFromSession();
        }
        clientBroker.initializeSequencing();
        return clientBroker;
    }

    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        if (this.isServerSessionBroker()) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        SessionBroker historicalBroker = this.copySessionBroker();
        for (String sessionName : this.getSessionsByName().keySet()) {
            AbstractSession session = this.getSessionForName(sessionName);
            historicalBroker.registerSession(sessionName, session.acquireHistoricalSession(clause));
        }
        return historicalBroker;
    }

    public void releaseJTSConnection() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.releaseJTSConnection();
        }
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        if (this.isServerSessionBroker()) {
            return this.acquireClientSessionBroker().acquireUnitOfWork();
        }
        return super.acquireUnitOfWork();
    }

    public void addDescriptor(ClassDescriptor descriptor) {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Vector descriptors) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Project project) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    protected void basicBeginTransaction() throws DatabaseException {
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.beginTransaction();
        }
    }

    protected void basicCommitTransaction() throws DatabaseException {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.commitTransaction();
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        DatabaseException globalException = null;
        for (AbstractSession session : this.getSessionsByName().values()) {
            try {
                session.rollbackTransaction();
            }
            catch (DatabaseException exception) {
                globalException = exception;
            }
        }
        if (globalException != null) {
            throw globalException;
        }
    }

    public boolean containsQuery(String queryName) {
        boolean containsQuery = this.getQueries().containsKey(queryName);
        if (this.isClientSessionBroker() && !containsQuery) {
            String sessionName2 = null;
            AbstractSession ssession = null;
            for (String sessionName2 : this.getSessionsByName().keySet()) {
                ssession = this.getSessionForName(sessionName2);
                if (!(ssession instanceof ClientSession) || !((ClientSession)ssession).getParent().getBroker().containsQuery(queryName)) continue;
                return true;
            }
        }
        return containsQuery;
    }

    protected SessionBroker copySessionBroker() {
        SessionBroker broker = new SessionBroker(this.getSessionNamesByClass());
        broker.accessor = this.getAccessor();
        broker.name = this.getName();
        broker.sessionLog = this.getSessionLog();
        broker.project = this.project;
        broker.eventManager = this.getEventManager().clone(broker);
        broker.shouldPropagateChanges = this.shouldPropagateChanges;
        return broker;
    }

    public Accessor getAccessor(Class domainClass) {
        if (domainClass == null) {
            throw QueryException.unnamedQueryOnSessionBroker(null);
        }
        return this.getSessionForClass(domainClass).getAccessor(domainClass);
    }

    public Accessor getAccessor(String sessionName) {
        return this.getSessionForName(sessionName).getAccessor(sessionName);
    }

    public AsOfClause getAsOfClause() {
        Iterator enumtr = this.getSessionsByName().values().iterator();
        if (enumtr.hasNext()) {
            return ((AbstractSession)enumtr.next()).getAsOfClause();
        }
        return null;
    }

    public SessionBroker getParent() {
        return this.parent;
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        if (query == null) {
            return this;
        }
        return this.getSessionForQuery(query).getParentIdentityMapSession(query, canReturnSelf, terminalOnly);
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        AbstractSession sessionByQuery = this.getSessionForQuery(query);
        return sessionByQuery.getExecutionSession(query);
    }

    public Platform getPlatform(Class domainClass) {
        if (domainClass == null) {
            return super.getDatasourcePlatform();
        }
        return this.getSessionForClass(domainClass).getDatasourcePlatform();
    }

    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (this.isClientSessionBroker() && query == null) {
            String sessionName2 = null;
            AbstractSession ssession = null;
            for (String sessionName2 : this.getSessionsByName().keySet()) {
                ssession = this.getSessionForName(sessionName2);
                if (!(ssession instanceof ClientSession) || (query = ((ClientSession)ssession).getParent().getBroker().getQuery(name)) == null) continue;
                return query;
            }
        }
        return query;
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        DatabaseQuery query = super.getQuery(name, arguments);
        if (this.isClientSessionBroker() && query == null) {
            String sessionName2 = null;
            AbstractSession ssession = null;
            for (String sessionName2 : this.getSessionsByName().keySet()) {
                ssession = this.getSessionForName(sessionName2);
                if (!(ssession instanceof ClientSession) || (query = ((ClientSession)ssession).getParent().getBroker().getQuery(name, arguments)) == null) continue;
                return query;
            }
        }
        return query;
    }

    public AbstractSession getSessionForClass(Class domainClass) throws ValidationException {
        if (domainClass == null) {
            return this;
        }
        String sessionName = (String)this.getSessionNamesByClass().get(domainClass);
        if (sessionName == null) {
            throw ValidationException.noSessionRegisteredForClass(domainClass);
        }
        return (AbstractSession)this.getSessionsByName().get(sessionName);
    }

    public AbstractSession getSessionForName(String name) throws ValidationException {
        AbstractSession sessionByName = (AbstractSession)this.getSessionsByName().get(name);
        if (sessionByName == null) {
            throw ValidationException.noSessionRegisteredForName(name);
        }
        return sessionByName;
    }

    protected AbstractSession getSessionForQuery(DatabaseQuery query) {
        Class queryClass;
        if (query.hasSessionName()) {
            return this.getSessionForName(query.getSessionName());
        }
        if (query.getDescriptor() != null) {
            queryClass = query.getDescriptor().getJavaClass();
        } else {
            queryClass = query.getReferenceClass();
            if (queryClass == null) {
                throw QueryException.unnamedQueryOnSessionBroker(query);
            }
        }
        return this.getSessionForClass(queryClass);
    }

    protected Map getSessionNamesByClass() {
        return this.sessionNamesByClass;
    }

    public Map getSessionsByName() {
        return this.sessionsByName;
    }

    public void initializeDescriptors() {
        if (!this.isClientSessionBroker()) {
            for (DatabaseSessionImpl databaseSession : this.getSessionsByName().values()) {
                databaseSession.initializeSequencing();
            }
            if (this.hasExternalTransactionController()) {
                this.getExternalTransactionController().initializeSequencingListeners();
            }
        }
        super.initializeDescriptors();
        for (DatabaseSessionImpl databaseSession : this.getSessionsByName().values()) {
            if (databaseSession.getProject().hasGenericHistorySupport()) {
                this.getProject().setHasGenericHistorySupport(true);
            }
            if (!databaseSession.getProject().hasIsolatedClasses()) continue;
            this.getProject().setHasIsolatedClasses(true);
        }
        if (this.isServerSessionBroker()) {
            this.sequencing = null;
        }
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new SessionBrokerIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord row) throws DatabaseException, QueryException {
        AbstractSession sessionByQuery = this.getSessionForQuery(query);
        return sessionByQuery.internalExecuteQuery(query, row);
    }

    public boolean isBroker() {
        return true;
    }

    public boolean isClientSessionBroker() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (!session.isClientSession()) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        if (this.getSessionsByName() == null || this.getSessionsByName().isEmpty()) {
            return false;
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean isServerSessionBroker() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (!session.isServerSession()) continue;
            return true;
        }
        return false;
    }

    public boolean isSessionBroker() {
        return true;
    }

    public void login() throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.getEventManager().preLogin(this);
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        for (DatabaseSessionImpl session : this.getSessionsByName().values()) {
            session.getEventManager().preLogin(session);
            if (session.isConnected()) continue;
            session.connect();
        }
        this.initializeDescriptors();
        if (this.getCommandManager() != null) {
            this.getCommandManager().initialize();
        }
        this.isLoggedIn = true;
    }

    public void login(String userName, String password) throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.getEventManager().preLogin(this);
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        for (DatabaseSessionImpl session : this.getSessionsByName().values()) {
            session.getEventManager().preLogin(session);
            session.getDatasourceLogin().setUserName(userName);
            session.getDatasourceLogin().setPassword(password);
            if (session.isConnected()) continue;
            session.connect();
        }
        this.initializeDescriptors();
        this.isLoggedIn = true;
    }

    public void logout() throws DatabaseException {
        for (DatabaseSessionImpl session : this.getSessionsByName().values()) {
            session.logout();
        }
        if (!this.isClientSessionBroker() && this.hasExternalTransactionController()) {
            this.getExternalTransactionController().clearSequencingListeners();
        }
        this.sequencing = null;
        this.isLoggedIn = false;
    }

    public void registerSession(String name, AbstractSession session) {
        session.setIsInBroker(true);
        this.getSessionsByName().put(name, session);
        session.setBroker(this);
        session.setName(name);
        Iterator descriptors = session.getDescriptors().values().iterator();
        Iterator classes = session.getDescriptors().keySet().iterator();
        while (descriptors.hasNext()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptors.next();
            Class descriptorClass = (Class)classes.next();
            this.getSessionNamesByClass().put(descriptorClass, name);
            this.getDescriptors().put(descriptorClass, descriptor);
        }
    }

    public void registerSession(String name, Session session) {
        this.registerSession(name, (AbstractSession)session);
    }

    public void internalRegisterSession(String name, AbstractSession session) {
        session.setIsInBroker(true);
        this.getSessionsByName().put(name, session);
        session.setBroker(this);
        session.setName(name);
    }

    public void release() {
        if (this.isClientSessionBroker()) {
            this.log(2, "connection", "releasing_client_session_broker");
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.release();
        }
        super.release();
    }

    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        super.setIntegrityChecker(integrityChecker);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setIntegrityChecker(integrityChecker);
        }
    }

    public void setSessionLog(SessionLog log) {
        super.setSessionLog(log);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setSessionLog(log);
        }
    }

    public void setLog(Writer log) {
        super.setLog(log);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setLog(log);
        }
    }

    public void setProfiler(SessionProfiler profiler) {
        super.setProfiler(profiler);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setProfiler(profiler);
        }
    }

    protected void setSessionNameByClass(HashMap sessionNameByClass) {
        this.sessionNamesByClass = sessionNameByClass;
    }

    public void setSessionsByName(Map sessionsByName) {
        this.sessionsByName = sessionsByName;
    }

    public void setSynchronized(boolean synched) {
        if (!this.isServerSessionBroker()) {
            super.setSynchronized(synched);
            Iterator itSessions = this.getSessionsByName().values().iterator();
            while (itSessions.hasNext()) {
                ((AbstractSession)itSessions.next()).setSynchronized(synched);
            }
        }
    }

    public void writesCompleted() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.writesCompleted();
        }
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    protected SequencingHome getSequencingHome() {
        return null;
    }

    public Sequencing getSequencing() {
        return this.sequencing;
    }

    public int howManySequencingCallbacks() {
        if (this.isClientSessionBroker()) {
            return this.getParent().howManySequencingCallbacks();
        }
        int nCallbacks = 0;
        Iterator itSessions = this.getSessionsByName().values().iterator();
        while (itSessions.hasNext()) {
            if (!((DatabaseSessionImpl)itSessions.next()).isSequencingCallbackRequired()) continue;
            ++nCallbacks;
        }
        return nCallbacks;
    }

    public boolean isSequencingCallbackRequired() {
        return this.howManySequencingCallbacks() > 0;
    }
}

