/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class UnidirectionalOneToManyMapping
extends OneToManyMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected transient DataModifyQuery preDeleteQuery;
    protected transient boolean hasCustomPreDeleteQuery;
    protected transient DataModifyQuery addTargetQuery = new DataModifyQuery();
    protected transient boolean hasCustomAddTargetQuery;
    protected transient DataModifyQuery removeTargetQuery = new DataModifyQuery();
    protected transient boolean hasCustomRemoveTargetQuery;
    protected transient DataModifyQuery removeAllTargetsQuery = new DataModifyQuery();
    protected transient boolean hasCustomRemoveAllTargetsQuery;
    protected transient boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget = true;
    protected transient boolean shouldIncrementTargetLockValueOnDeleteSource = true;

    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        ChangeRecord record = super.compareForChange(clone, backUp, owner, session);
        if (record != null && this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            this.postCalculateChanges(record, session);
        }
        return record;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord row, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        Vector<Object> key = new Vector<Object>(size);
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)this.sourceKeyFields.get(index);
            Object value = row.get(field);
            try {
                value = conversionManager.convertObject(value, field.getType());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected Vector extractSourceKeyFromRow(AbstractRecord row, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        Vector<Object> key = new Vector<Object>(size);
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetField = (DatabaseField)this.targetForeignKeyFields.get(index);
            DatabaseField sourceField = (DatabaseField)this.sourceKeyFields.get(index);
            Object value = row.get(targetField);
            try {
                value = conversionManager.convertObject(value, sourceField.getType());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable<CacheKey, Object> referenceObjectsByKey = null;
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceObjectsByKey = this.getBatchReadObjects(query, session);
            if (referenceObjectsByKey == null) {
                ReadAllQuery batchQuery = (ReadAllQuery)query;
                ComplexQueryResult complexResult = (ComplexQueryResult)session.executeQuery((DatabaseQuery)batchQuery, argumentRow);
                List results = (List)complexResult.getResult();
                referenceObjectsByKey = new Hashtable<CacheKey, Object>();
                List rows = (List)complexResult.getData();
                int size = results.size();
                for (int index = 0; index < size; ++index) {
                    Object eachReferenceObject = results.get(index);
                    CacheKey eachReferenceKey = new CacheKey(this.extractSourceKeyFromRow((AbstractRecord)rows.get(index), session));
                    if (!referenceObjectsByKey.containsKey(eachReferenceKey)) {
                        referenceObjectsByKey.put(eachReferenceKey, this.containerPolicy.containerInstance());
                    }
                    this.containerPolicy.addInto(eachReferenceObject, referenceObjectsByKey.get(eachReferenceKey), session);
                }
                this.setBatchReadObjects(referenceObjectsByKey, query, session);
            }
        }
        Object result = referenceObjectsByKey.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (result == null) {
            return this.containerPolicy.containerInstance();
        }
        return result;
    }

    public boolean isUnidirectionalOneToManyMapping() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.initializeAddTargetQuery(session);
        this.initializeRemoveTargetQuery(session);
        this.initializeRemoveAllTargetsQuery(session);
        if (this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            if (this.shouldIncrementTargetLockValueOnAddOrRemoveTarget) {
                this.descriptor.addMappingsPostCalculateChanges(this);
            }
            if (this.shouldIncrementTargetLockValueOnDeleteSource && !this.isPrivateOwned) {
                this.descriptor.addMappingsPostCalculateChangesOnDeleted(this);
            }
        }
    }

    public void postInitialize(AbstractSession session) {
        super.postInitialize(session);
        Iterator<DatabaseField> targetForeignKeys = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> sourceKeys = this.getSourceKeyFields().iterator();
        while (targetForeignKeys.hasNext()) {
            DatabaseField targetForeignKey = targetForeignKeys.next();
            DatabaseField sourcePrimaryKey = sourceKeys.next();
            if (targetForeignKey.getType() != null) continue;
            targetForeignKey.setType(this.getDescriptor().getObjectBuilder().getMappingForField(sourcePrimaryKey).getFieldClassification(sourcePrimaryKey));
        }
    }

    protected void initializeAddTargetQuery(AbstractSession session) {
        if (!this.addTargetQuery.hasSessionName()) {
            this.addTargetQuery.setSessionName(session.getName());
        }
        if (this.hasCustomAddTargetQuery) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List<DatabaseField> targetPrimaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        int size = targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = targetPrimaryKeyFields.get(index);
            Expression expression = ((Expression)builder).getField(targetPrimaryKey).equal(builder.getParameter(targetPrimaryKey));
            whereClause = expression.and(whereClause);
        }
        DatabaseRecord modifyRow = new DatabaseRecord();
        size = this.targetForeignKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            modifyRow.put(targetForeignKey, (Object)null);
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(this.getReferenceDescriptor().getDefaultTable());
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.addTargetQuery.setSQLStatement(statement);
    }

    protected void initializeRemoveTargetQuery(AbstractSession session) {
        if (!this.removeTargetQuery.hasSessionName()) {
            this.removeTargetQuery.setSessionName(session.getName());
        }
        if (this.hasCustomRemoveTargetQuery) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List<DatabaseField> targetPrimaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        int size = targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = targetPrimaryKeyFields.get(index);
            Expression expression = ((Expression)builder).getField(targetPrimaryKey).equal(builder.getParameter(targetPrimaryKey));
            whereClause = expression.and(whereClause);
        }
        DatabaseRecord modifyRow = new DatabaseRecord();
        size = this.targetForeignKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            modifyRow.put(targetForeignKey, (Object)null);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(targetForeignKey));
            whereClause = expression.and(whereClause);
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(this.getReferenceDescriptor().getDefaultTable());
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.removeTargetQuery.setSQLStatement(statement);
    }

    protected void initializeRemoveAllTargetsQuery(AbstractSession session) {
        if (!this.removeAllTargetsQuery.hasSessionName()) {
            this.removeAllTargetsQuery.setSessionName(session.getName());
        }
        if (this.hasCustomRemoveAllTargetsQuery) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        DatabaseRecord modifyRow = new DatabaseRecord();
        int size = this.targetForeignKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            modifyRow.put(targetForeignKey, (Object)null);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(targetForeignKey));
            whereClause = expression.and(whereClause);
        }
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(this.getReferenceDescriptor().getDefaultTable());
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.removeAllTargetsQuery.setSQLStatement(statement);
    }

    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(query, objectAdded, changeSet);
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{ObjectAdded, query, objectAdded};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.updateTargetForeignKeyPostUpdateSource_ObjectAdded(query, objectAdded);
        }
    }

    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted) throws DatabaseException, OptimisticLockException {
        if (!this.isPrivateOwned()) {
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{ObjectRemoved, query, objectDeleted};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
            } else {
                this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved(query, objectDeleted);
            }
        }
        super.objectRemovedDuringUpdate(query, objectDeleted);
    }

    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] == PostInsert) {
            this.updateTargetForeignKeysPostInsertSource((WriteObjectQuery)event[1]);
        } else if (event[0] == ObjectRemoved) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved((WriteObjectQuery)event[1], event[2]);
        } else if (event[0] == ObjectAdded) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectAdded((WriteObjectQuery)event[1], event[2]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.shouldObjectModifyCascadeToParts(query)) {
            super.preDelete(query);
        } else {
            this.updateTargetForeignKeyPreDeleteSource(query);
        }
    }

    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy policy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        policy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        policy.setShouldHandleUnmappedFields(true);
        this.getReferenceDescriptor().addCascadeLockingPolicy(policy);
    }

    public void postCalculateChanges(org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord, AbstractSession session) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        for (ObjectChangeSet change : collectionChangeRecord.getAddObjectList().values()) {
            if (change.hasChanges()) continue;
            change.setShouldModifyVersionField(Boolean.TRUE);
            ((UnitOfWorkChangeSet)change.getUOWChangeSet()).addObjectChangeSet(change, session, false);
        }
        if (!this.isPrivateOwned()) {
            for (ObjectChangeSet change : collectionChangeRecord.getRemoveObjectList().values()) {
                if (change.hasChanges()) continue;
                change.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)change.getUOWChangeSet()).addObjectChangeSet(change, session, false);
            }
        }
    }

    public void postCalculateChangesOnDeleted(Object deletedObject, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
        Object col = this.getRealCollectionAttributeValueFromObject(deletedObject, session);
        if (col != null) {
            Object iterator = this.containerPolicy.iteratorFor(col);
            while (this.containerPolicy.hasNext(iterator)) {
                Object target = this.containerPolicy.next(iterator, session);
                ObjectChangeSet change = this.referenceDescriptor.getObjectBuilder().createObjectChangeSet(target, uowChangeSet, session);
                if (change.hasChanges()) continue;
                change.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)change.getUOWChangeSet()).addObjectChangeSet(change, session, false);
            }
        }
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        super.postInsert(query);
        if (this.isReadOnly()) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{PostInsert, query};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.updateTargetForeignKeysPostInsertSource(query);
        }
    }

    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ReadAllQuery query) {
        ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
        mappingBatchQuery.setShouldIncludeData(true);
        int size = this.targetForeignKeyFields.size();
        for (int i = 0; i < size; ++i) {
            mappingBatchQuery.addAdditionalField((DatabaseField)this.targetForeignKeyFields.get(i));
        }
    }

    public void postUpdate(WriteObjectQuery query) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        Object objectsInMemoryModel = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        Object currentObjectsInDB = this.readPrivateOwnedForObject(query);
        if (currentObjectsInDB == null) {
            currentObjectsInDB = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(currentObjectsInDB, objectsInMemoryModel, query);
    }

    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, AbstractSession session) {
        int size = this.sourceKeyFields.size();
        for (int i = 0; i < size; ++i) {
            DatabaseField sourceKey = (DatabaseField)this.sourceKeyFields.get(i);
            if (translationRow.containsKey(sourceKey)) continue;
            Object value = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, sourceKey, session);
            translationRow.put(sourceKey, value);
        }
    }

    public void setAddTargetSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomAddTargetQuery(query);
    }

    public void setCustomAddTargetQuery(DataModifyQuery query) {
        this.addTargetQuery = query;
        this.hasCustomAddTargetQuery = true;
    }

    public void setCustomRemoveTargetQuery(DataModifyQuery query) {
        this.removeTargetQuery = query;
        this.hasCustomRemoveTargetQuery = true;
    }

    public void setCustomRemoveAllTargetsQuery(DataModifyQuery query) {
        this.removeAllTargetsQuery = query;
        this.hasCustomRemoveAllTargetsQuery = true;
    }

    public void setSessionName(String name) {
        super.setSessionName(name);
        this.addTargetQuery.setSessionName(name);
        this.removeTargetQuery.setSessionName(name);
        this.removeAllTargetsQuery.setSessionName(name);
    }

    public void setShouldIncrementTargetLockValueOnAddOrRemoveTarget(boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget) {
        this.shouldIncrementTargetLockValueOnAddOrRemoveTarget = shouldIncrementTargetLockValueOnAddOrRemoveTarget;
    }

    public void setShouldIncrementTargetLockValueOnDeleteSource(boolean shouldIncrementTargetLockValueOnDeleteSource) {
        this.shouldIncrementTargetLockValueOnDeleteSource = shouldIncrementTargetLockValueOnDeleteSource;
    }

    public boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget() {
        return this.shouldIncrementTargetLockValueOnAddOrRemoveTarget;
    }

    public boolean shouldIncrementTargetLockValueOnDeleteSource() {
        return this.shouldIncrementTargetLockValueOnDeleteSource;
    }

    public void updateTargetForeignKeysPostInsertSource(WriteObjectQuery query) throws DatabaseException {
        Object objects;
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.isEmpty(objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession()))) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        DatabaseRecord databaseRow = new DatabaseRecord();
        int size = this.sourceKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceKey = (DatabaseField)this.sourceKeyFields.get(index);
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(targetForeignKey, sourceKeyValue);
        }
        List<DatabaseField> targetPrimaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        size = targetPrimaryKeyFields.size();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            for (int index = 0; index < size; ++index) {
                DatabaseField targetPrimaryKey = targetPrimaryKeyFields.get(index);
                Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, targetPrimaryKey, query.getSession());
                databaseRow.put(targetPrimaryKey, targetKeyValue);
            }
            query.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, databaseRow);
        }
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectAdded(ObjectLevelModifyQuery query, Object objectAdded) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        DatabaseRecord databaseRow = new DatabaseRecord();
        int size = this.sourceKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceKey = (DatabaseField)this.sourceKeyFields.get(index);
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(targetForeignKey, sourceKeyValue);
        }
        List<DatabaseField> targetPrimaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        size = targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = targetPrimaryKeyFields.get(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(objectAdded, targetPrimaryKey, query.getSession());
            databaseRow.put(targetPrimaryKey, targetKeyValue);
        }
        query.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, databaseRow);
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectRemoved(ObjectLevelModifyQuery query, Object objectRemoved) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        AbstractSession session = query.getSession();
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), session);
        DatabaseRecord translationRow = new DatabaseRecord();
        int size = this.sourceKeyFields.size();
        DatabaseRecord modifyRow = new DatabaseRecord(size);
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceKey = (DatabaseField)this.sourceKeyFields.get(index);
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            translationRow.add(targetForeignKey, sourceKeyValue);
            modifyRow.add(targetForeignKey, null);
        }
        List<DatabaseField> targetPrimaryKeyFields = this.getReferenceDescriptor().getPrimaryKeyFields();
        size = targetPrimaryKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetPrimaryKey = targetPrimaryKeyFields.get(index);
            Object targetKeyValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(objectRemoved, targetPrimaryKey, session);
            translationRow.add(targetPrimaryKey, targetKeyValue);
        }
        DataModifyQuery removeQuery = (DataModifyQuery)this.removeTargetQuery.clone();
        removeQuery.setModifyRow(modifyRow);
        removeQuery.setHasModifyRow(true);
        removeQuery.setIsExecutionClone(true);
        session.executeQuery((DatabaseQuery)removeQuery, translationRow);
    }

    public void updateTargetForeignKeyPreDeleteSource(ObjectLevelModifyQuery query) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        int size = this.sourceKeyFields.size();
        DatabaseRecord translationRow = new DatabaseRecord(size);
        DatabaseRecord modifyRow = new DatabaseRecord(size);
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceKey = (DatabaseField)this.sourceKeyFields.get(index);
            DatabaseField targetForeignKey = (DatabaseField)this.targetForeignKeyFields.get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            translationRow.add(targetForeignKey, sourceKeyValue);
            modifyRow.add(targetForeignKey, null);
        }
        DataModifyQuery removeQuery = (DataModifyQuery)this.removeAllTargetsQuery.clone();
        removeQuery.setModifyRow(modifyRow);
        removeQuery.setHasModifyRow(true);
        removeQuery.setIsExecutionClone(true);
        query.getSession().executeQuery((DatabaseQuery)removeQuery, translationRow);
    }
}

