/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.io.File;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.ProjectClassGenerator;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class GettersAndSettersForProjectClassGeneratorTest
extends AutoVerifyTestCase {
    ProjectClassGenerator generator;
    Project project;
    String path = "testPath";
    String className = "EclipseLink";
    boolean foundException;

    public GettersAndSettersForProjectClassGeneratorTest() {
        this.setDescription("The setters and getters for ProjectClassGenerator ");
    }

    public void reset() {
        File file = new File(this.generator.getOutputFileName());
        file.delete();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.project = null;
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.project = new EmployeeProject();
        this.generator = new ProjectClassGenerator();
    }

    public void test() {
        try {
            this.generator.setProject(this.project);
            this.generator.setOutputPath(this.path);
            this.generator.setClassName(this.className);
            this.generator.generate();
        }
        catch (Exception e) {
            this.foundException = true;
        }
    }

    protected void verify() {
        Project projectTest = this.generator.getProject();
        String classTest = this.generator.getClassName();
        String pathTest = this.generator.getOutputPath();
        if (!projectTest.getName().equals(this.project.getName())) {
            throw new TestErrorException("Project name not set");
        }
        if (!classTest.equals(this.className)) {
            throw new TestErrorException("ClassName not set");
        }
        if (!pathTest.equals(this.path)) {
            throw new TestErrorException("Path not set");
        }
        if (this.foundException) {
            throw new TestErrorException("Exception has been thrown in IsTypeConversionMappingTest");
        }
    }
}

