/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class TransactionIsolationBuildObjectCacheHitTest
extends TestCase {
    protected boolean oldBindingValue;
    protected QuerySQLTracker sqlTracker;
    protected UnitOfWork uow;

    public TransactionIsolationBuildObjectCacheHitTest() {
        this.setDescription("Test looking up objects in the UnitOfWork IdentityMap when an early transaction has been started");
    }

    public void setup() {
        this.oldBindingValue = this.getSession().getLogin().shouldBindAllParameters();
        this.getSession().getLogin().setShouldBindAllParameters(false);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        PolicyHolder holder = (PolicyHolder)this.getSession().readObject((Object)PolicyHolder.example2());
        TransactionIsolationBuildObjectCacheHitTest.assertNotNull((Object)holder);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.beginEarlyTransaction();
        this.sqlTracker = new QuerySQLTracker(this.getSession());
    }

    public void test() {
        PolicyHolder policyHolder = (PolicyHolder)this.uow.readObject((Object)PolicyHolder.example2());
        TransactionIsolationBuildObjectCacheHitTest.assertNotNull((Object)policyHolder);
    }

    public void verify() {
        List statements = this.sqlTracker.getSqlStatements();
        Vector<CallSite> errors = new Vector<CallSite>();
        for (int i = 0; i < statements.size(); ++i) {
            String errorText;
            String statement = (String)statements.get(i);
            int occurrences = Helper.countOccurrencesOf((Object)statement, (List)statements);
            if (occurrences <= 1 || errors.contains(errorText = "SQL statement executed " + occurrences + " times: [" + statement + "] (Expected 1)")) continue;
            errors.add((CallSite)((Object)errorText));
        }
        if (!errors.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Errors occurred with duplicate SQL being executed whilst building an object tree. The UnitOfWork cache should have been hit instead:");
            buffer.append(Helper.cr());
            for (int i = 0; i < errors.size(); ++i) {
                buffer.append(errors.get(i));
                buffer.append(Helper.cr());
            }
            throw new TestErrorException(buffer.toString());
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getLogin().setShouldBindAllParameters(this.oldBindingValue);
        this.uow.release();
        this.uow = null;
        this.sqlTracker.remove();
        this.sqlTracker = null;
    }
}

