/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Date;
import java.sql.Time;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class DeepMergeCloneSerializedTest
extends AutoVerifyTestCase {
    public Employee origional;
    public Employee mergedClone;
    public Employee empObject;
    public String gender;
    public Time endTime;
    public PhoneNumber removedPhone;
    public PhoneNumber addedPhone;
    public java.util.Date endDate;

    public DeepMergeCloneSerializedTest() {
        this.setDescription("This test verifies that deepMergeClone works after a serialized transaction");
    }

    public DeepMergeCloneSerializedTest(Employee employee) {
        this.empObject = employee;
        this.setDescription("This test verifies that deepMergeClone works after a serialized transaction");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        try {
            Employee deserialEmp;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteStream);
            Session session = this.getSession();
            UnitOfWork uow = session.acquireUnitOfWork();
            this.empObject = (Employee)session.readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Bob"));
            ClassDescriptor descriptor = session.getDescriptor((Object)this.empObject);
            if (descriptor.isProtectedIsolation() && descriptor.shouldIsolateProtectedObjectsInUnitOfWork() && session instanceof IsolatedClientSession) {
                this.empObject = (Employee)((AbstractSession)session).getParentIdentityMapSession(descriptor, false, true).getIdentityMapAccessor().getFromIdentityMap((Object)this.empObject);
            }
            this.empObject.getPhoneNumbers();
            if (this.empObject.getManager() != null) {
                this.empObject.getManager().getManagedEmployees();
            }
            this.empObject.getResponsibilitiesList();
            stream.writeObject(this.empObject);
            stream.flush();
            byte[] arr = byteStream.toByteArray();
            ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
            ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
            try {
                deserialEmp = (Employee)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            Employee newManager = new Employee();
            if (deserialEmp.getManager() != null) {
                deserialEmp.getManager().removeManagedEmployee(deserialEmp);
                this.removedPhone = (PhoneNumber)deserialEmp.getPhoneNumbers().firstElement();
                deserialEmp.getPhoneNumbers().removeElement(deserialEmp.getPhoneNumbers().firstElement());
            }
            newManager.addManagedEmployee(deserialEmp);
            PhoneNumber phone = new PhoneNumber();
            phone.setNumber("5555897");
            phone.setType("Fax");
            phone.setOwner(deserialEmp);
            deserialEmp.addPhoneNumber(phone);
            this.addedPhone = phone;
            deserialEmp.setLastName("Willford");
            this.gender = deserialEmp.getGender();
            if (deserialEmp.getGender().equals("Female")) {
                deserialEmp.setMale();
            } else {
                deserialEmp.setFemale();
            }
            this.endDate = deserialEmp.getPeriod().getEndDate();
            deserialEmp.getPeriod().setEndDate(new Date(System.currentTimeMillis() + 300000L));
            this.endTime = deserialEmp.getEndTime();
            deserialEmp.setEndTime(Helper.timeFromHourMinuteSecond((int)15, (int)2, (int)3));
            deserialEmp.addResponsibility("A Very New Respons");
            byteStream = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(deserialEmp);
            stream.flush();
            arr = byteStream.toByteArray();
            inByteStream = new ByteArrayInputStream(arr);
            inObjStream = new ObjectInputStream(inByteStream);
            try {
                deserialEmp = (Employee)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            Employee empClone = (Employee)uow.deepMergeClone((Object)deserialEmp);
            uow.commit();
            uow = session.acquireUnitOfWork();
            byteStream = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(this.empObject);
            stream.flush();
            arr = byteStream.toByteArray();
            inByteStream = new ByteArrayInputStream(arr);
            inObjStream = new ObjectInputStream(inByteStream);
            try {
                deserialEmp = (Employee)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            deserialEmp.setFirstName("Danny");
            this.origional = deserialEmp;
            byteStream = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(deserialEmp);
            stream.flush();
            arr = byteStream.toByteArray();
            inByteStream = new ByteArrayInputStream(arr);
            inObjStream = new ObjectInputStream(inByteStream);
            try {
                deserialEmp = (Employee)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            deserialEmp = (Employee)uow.deepMergeClone((Object)deserialEmp);
            uow.commit();
            this.mergedClone = deserialEmp;
        }
        catch (IOException e) {
            throw new TestErrorException("Error running Test " + e.toString());
        }
    }

    public void verify() {
        if (!this.mergedClone.getFirstName().equals(this.origional.getFirstName())) {
            throw new TestErrorException("Clone did not merge properly");
        }
        Employee cachedEmp = (Employee)this.getSession().readObject((Object)this.mergedClone);
        if (cachedEmp.getPeriod().getEndDate().equals(this.endDate)) {
            throw new TestErrorException("Failed to update the aggregate");
        }
        if (cachedEmp.getEndTime().equals(this.endTime)) {
            throw new TestErrorException("Failed to update the Transformation mapping");
        }
        if (cachedEmp.getGender().equals(this.gender)) {
            throw new TestErrorException("Failed to update the TypeConversionMapping");
        }
        if (!cachedEmp.getPhoneNumbers().contains(this.getSession().readObject((Object)this.addedPhone))) {
            throw new TestErrorException("Failed to update one to many addition");
        }
        if (!cachedEmp.getResponsibilitiesList().contains("A Very New Respons")) {
            throw new TestErrorException("Failed to update Direct Collection mapping");
        }
        if (!cachedEmp.getLastName().equals("Willford")) {
            throw new TestErrorException("Failed to update Direct To Field");
        }
    }
}

