/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class CollectionMappingMergeObjectTest
extends AutoVerifyTestCase {
    Exception e;

    public CollectionMappingMergeObjectTest() {
        this.setDescription("Test that merging changes in a unit of work works successfully.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.e = null;
    }

    public void test() {
        Session session = this.getSession();
        session.getIdentityMapAccessor().initializeIdentityMaps();
        UnitOfWork uow1 = session.acquireUnitOfWork();
        Employee emp = new Employee();
        emp = (Employee)uow1.registerObject((Object)emp);
        uow1.commitAndResume();
        ReadObjectQuery readObjectQuery = new ReadObjectQuery((Object)emp);
        readObjectQuery.refreshIdentityMapResult();
        readObjectQuery.dontCascadeParts();
        session.executeQuery((DatabaseQuery)readObjectQuery);
        UnitOfWork uow2 = session.acquireUnitOfWork();
        SmallProject small = new SmallProject();
        small = (SmallProject)uow2.registerObject((Object)small);
        uow2.commitAndResume();
        readObjectQuery = new ReadObjectQuery((Object)small);
        readObjectQuery.refreshIdentityMapResult();
        readObjectQuery.dontCascadeParts();
        session.executeQuery((DatabaseQuery)readObjectQuery);
        small = (SmallProject)session.readObject((Object)small);
        small = (SmallProject)uow1.registerObject((Object)small);
        emp.addProject(small);
        try {
            uow1.commit();
        }
        catch (Exception e) {
            this.e = e;
            throw new TestErrorException("An exception should not have been thrown when commiting a unit of work.");
        }
    }

    public void verify() {
        if (this.e != null) {
            throw new TestErrorException("An exception should not have been thrown when commiting a unit of work: " + this.e.toString());
        }
    }
}

