/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class AllChangeSetsTest
extends AutoVerifyTestCase {
    SessionListener listener = new SessionListener();
    int changedObjectsCount;

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.getSession().getEventManager().removeListener((SessionEventListener)this.listener);
        }
    }

    public void setup() {
        this.getSession().getEventManager().addListener((SessionEventListener)this.listener);
        this.getAbstractSession().beginTransaction();
        this.changedObjectsCount = 0;
        this.listener.changedObjectsCount = -1;
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector employees = uow.readAllObjects(Employee.class);
        if (employees.size() <= 4) {
            throw new TestProblemException("only " + employees.size() + " employees were read, need at least 5");
        }
        Employee emp = (Employee)employees.firstElement();
        emp.setFirstName("Changed");
        ++this.changedObjectsCount;
        Address add = emp.getAddress();
        if (emp.getAddress() != null) {
            add.setCity("Changed");
            ++this.changedObjectsCount;
        }
        Employee newEmp = new Employee();
        Employee newEmpClone = (Employee)uow.registerObject((Object)newEmp);
        newEmpClone.setFirstName("New");
        ++this.changedObjectsCount;
        for (PhoneNumber phone : emp.getPhoneNumbers()) {
            String string = phone.getAreaCode();
        }
        Employee emp1 = (Employee)employees.elementAt(1);
        uow.forceUpdateToVersionField((Object)emp1, false);
        Employee emp2 = (Employee)employees.elementAt(2);
        uow.forceUpdateToVersionField((Object)emp2, true);
        ++this.changedObjectsCount;
        uow.commit();
    }

    public void verify() {
        if (this.listener.changedObjectsCount == -1) {
            throw new TestProblemException("postCalculateUnitOfWorkChangeSet was not handled");
        }
        if (this.listener.changedObjectsCount != this.changedObjectsCount) {
            throw new TestErrorException("uowChangeSet.getAllChangeSets().size() == " + this.listener.changedObjectsCount + "; " + this.changedObjectsCount + " is expected");
        }
    }

    static class SessionListener
    extends SessionEventAdapter {
        public int changedObjectsCount;

        SessionListener() {
        }

        public void preMergeUnitOfWorkChangeSet(SessionEvent event) {
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)event.getProperty("UnitOfWorkChangeSet");
            this.changedObjectsCount = uowChangeSet.getAllChangeSets().size();
        }
    }
}

