/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class BooleanTester
extends TypeTester {
    public boolean booleanValue;
    public Boolean booleanClassValue;

    public BooleanTester() {
        this(true);
    }

    public BooleanTester(boolean testValue) {
        super(Boolean.valueOf(testValue).toString());
        this.booleanValue = testValue;
        this.booleanClassValue = testValue;
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(BooleanTester.class);
        descriptor.setTableName("BOOLEANS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("booleanValue", "BOOLEANV");
        descriptor.addDirectMapping("booleanClassValue", "BOOLEANC");
        return descriptor;
    }

    public static RelationalDescriptor descriptorWithAccessors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(BooleanTester.class);
        descriptor.setTableName("BOOLEANS");
        descriptor.setPrimaryKeyFieldName("NAME");
        try {
            descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
            descriptor.addDirectMapping("booleanValue", "getBooleanValue", "setBooleanValue", "BOOLEANV");
            descriptor.addDirectMapping("booleanClassValue", "getBooleanClassValue", "setBooleanClassValue", "BOOLEANC");
        }
        catch (DescriptorException descriptorException) {
            // empty catch block
        }
        return descriptor;
    }

    public Boolean getBooleanClassValue() {
        return this.booleanClassValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanClassValue(Boolean boolValue) {
        this.booleanClassValue = boolValue;
    }

    public void setBooleanClassValue(boolean boolValue) {
        this.booleanClassValue = boolValue;
    }

    public void setBooleanValue(Boolean boolValue) {
        this.booleanValue = boolValue;
    }

    public void setBooleanValue(boolean boolValue) {
        this.booleanValue = boolValue;
    }

    public static TableDefinition tableDefinition(Session session) {
        TableDefinition definition = TypeTester.tableDefinition();
        definition.setName("BOOLEANS");
        FieldDefinition fieldDef = new FieldDefinition("BOOLEANV", Boolean.class);
        fieldDef.setShouldAllowNull(false);
        definition.addField(fieldDef);
        fieldDef = new FieldDefinition("BOOLEANC", Boolean.class);
        fieldDef.setShouldAllowNull(false);
        definition.addField(fieldDef);
        return definition;
    }

    public static Vector testInstances() {
        Vector<BooleanTester> tests = new Vector<BooleanTester>(2);
        tests.addElement(new BooleanTester(true));
        tests.addElement(new BooleanTester(false));
        return tests;
    }

    public String toString() {
        return "BooleanTester(" + this.getBooleanValue() + ")";
    }
}

