/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject1;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject2;
import org.eclipse.persistence.testing.tests.sessionbroker.ServerBrokerTestModel;
import org.eclipse.persistence.transaction.JTATransactionController;

public class VerifyClientBrokerCreationTest
extends AutoVerifyTestCase {
    SessionBroker serverBroker = null;
    SessionBroker clientBroker = null;

    public void test() {
        this.serverBroker = new SessionBroker();
        ServerSession ssession1 = new ServerSession((Login)ServerBrokerTestModel.getLogin1());
        ServerSession ssession2 = new ServerSession((Login)ServerBrokerTestModel.getLogin2());
        ssession1.addDescriptors((Project)new EmployeeProject1());
        ssession2.addDescriptors((Project)new EmployeeProject2());
        this.serverBroker.registerSession("broker1", (AbstractSession)ssession1);
        this.serverBroker.registerSession("broker2", (AbstractSession)ssession2);
        this.serverBroker.setLog(this.getSession().getLog());
        this.serverBroker.setLogLevel(3);
        this.serverBroker.setShouldPropagateChanges(true);
        CustomServerPlatform platform = new CustomServerPlatform((DatabaseSession)this.serverBroker);
        platform.setExternalTransactionControllerClass(JTATransactionController.class);
        this.serverBroker.setServerPlatform((ServerPlatform)platform);
        this.serverBroker.login();
        this.clientBroker = this.serverBroker.acquireClientSessionBroker();
    }

    public void verify() {
        if (this.clientBroker == this.serverBroker) {
            throw new TestErrorException("ClientBroker is == to serverBroker");
        }
        if (this.clientBroker.getAccessor() != this.serverBroker.getAccessor()) {
            throw new TestErrorException("Accessor not properly copied on client broker creation");
        }
        if (this.clientBroker.getName() != this.serverBroker.getName()) {
            throw new TestErrorException("Name not properly copied on client broker creation");
        }
        if (this.clientBroker.getSessionLog() != this.serverBroker.getSessionLog()) {
            throw new TestErrorException("SessionLog not properly copied on client broker creation");
        }
        if (this.clientBroker.getProject() != this.serverBroker.getProject()) {
            throw new TestErrorException("ShouldPropogateChanges not properly copied on client broker creation");
        }
        if (this.clientBroker.shouldPropagateChanges() != this.serverBroker.shouldPropagateChanges()) {
            throw new TestErrorException("ShouldPropogateChanges not properly copied on client broker creation");
        }
        if (this.clientBroker.getParent() != this.serverBroker) {
            throw new TestErrorException("Parent not properly set on client broker creation");
        }
        if (this.clientBroker.getCommandManager() != this.serverBroker.getCommandManager()) {
            throw new TestErrorException("CommandManager not properly copied on client broker creation");
        }
        if (this.clientBroker.getCommitManager() != this.serverBroker.getCommitManager()) {
            throw new TestErrorException("CommitManager not properly copied on client broker creation");
        }
        if (this.clientBroker.getExternalTransactionController() != this.serverBroker.getExternalTransactionController()) {
            throw new TestErrorException("ShouldPropogateChanges not properly copied on client broker creation");
        }
        if (this.clientBroker.getServerPlatform() != this.serverBroker.getServerPlatform()) {
            throw new TestErrorException("ShouldPropogateChanges not properly copied on client broker creation");
        }
        if (this.clientBroker.getSessionsByName().size() != this.serverBroker.getSessionsByName().size()) {
            throw new TestErrorException("Incorrect number of sessions in client broker");
        }
        for (String key : this.serverBroker.getSessionsByName().keySet()) {
            if (this.clientBroker.getSessionForName(key) != null) continue;
            throw new TestErrorException("Session " + key + " exists in server broker but not client broker.");
        }
    }
}

