/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario5_1c
extends ReportQueryTestCase {
    public Scenario5_1c() {
        this.setDescription("3x1:1 Join Custom SQL");
    }

    @Override
    protected void buildExpectedResults() throws Exception {
        Vector phones = this.getSession().readAllObjects(PhoneNumber.class);
        Enumeration e = phones.elements();
        while (e.hasMoreElements()) {
            PhoneNumber phone = (PhoneNumber)e.nextElement();
            Object[] result = new Object[]{phone.getAreaCode(), phone.getNumber(), phone.getOwner().getFirstName(), phone.getOwner().getLastName(), phone.getOwner().getAddress().getCity()};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(PhoneNumber.class);
        this.reportQuery.addAttribute("areaCode");
        this.reportQuery.addAttribute("number");
        this.reportQuery.addAttribute("firstName", this.reportQuery.getExpressionBuilder().get("owner").get("firstName"));
        this.reportQuery.addAttribute("lastName", this.reportQuery.getExpressionBuilder().get("owner").get("lastName"));
        this.reportQuery.addAttribute("city", this.reportQuery.getExpressionBuilder().get("owner").get("address").get("city"));
        this.reportQuery.setSQLString("SELECT T0.AREA_CODE, T0.P_NUMBER, T1.F_NAME, T1.L_NAME, T2.CITY FROM PHONE T0, EMPLOYEE T1, ADDRESS T2 WHERE T0.EMP_ID = T1.EMP_ID AND T1.ADDR_ID = T2.ADDRESS_ID");
    }
}

