/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.options;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.Address;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class ReadObjectQueryDisableCacheHitsTest
extends AutoVerifyTestCase {
    ClassDescriptor m_addressDesc;
    ClassDescriptor m_policyHolderDesc;
    boolean m_addressDisableCacheHits;
    boolean m_addressAlwaysrefreshCache;
    boolean m_policyHolderDisableCacheHits;
    boolean m_policyHolderAlwaysrefreshCache;

    public ReadObjectQueryDisableCacheHitsTest() {
        this.setDescription("This test verifies that infinite recursion will not occur when reading an object with no cascade all, no indirection and disabled cache hits");
    }

    public void reset() {
        this.m_addressDesc.setShouldDisableCacheHits(this.m_addressDisableCacheHits);
        this.m_addressDesc.setShouldAlwaysRefreshCache(this.m_addressAlwaysrefreshCache);
        this.m_policyHolderDesc.setShouldDisableCacheHits(this.m_policyHolderDisableCacheHits);
        this.m_policyHolderDesc.setShouldAlwaysRefreshCache(this.m_policyHolderAlwaysrefreshCache);
    }

    public void setup() {
        this.m_addressDesc = this.getSession().getClassDescriptor(Address.class);
        this.m_addressDisableCacheHits = this.m_addressDesc.shouldDisableCacheHits();
        this.m_addressAlwaysrefreshCache = this.m_addressDesc.shouldAlwaysRefreshCache();
        this.m_addressDesc.disableCacheHits();
        this.m_addressDesc.alwaysRefreshCache();
        this.m_policyHolderDesc = this.getSession().getClassDescriptor(PolicyHolder.class);
        this.m_policyHolderDisableCacheHits = this.m_policyHolderDesc.shouldDisableCacheHits();
        this.m_policyHolderAlwaysrefreshCache = this.m_policyHolderDesc.shouldAlwaysRefreshCache();
        this.m_policyHolderDesc.disableCacheHits();
        this.m_policyHolderDesc.alwaysRefreshCache();
    }

    public void test() {
        try {
            ReadObjectQuery query = new ReadObjectQuery(PolicyHolder.class);
            this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (StackOverflowError ex) {
            throw new TestErrorException("ReadObjectQuery with disabled cache hits caused infinite recursion");
        }
    }
}

